/**
 * Copyright tkinjo ( http://wonderfl.net/user/tkinjo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/syUv
 */

package  
{
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.GradientType;
	import flash.display.SpreadMethod;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.KeyboardEvent;
	import flash.filters.GlowFilter;
	import flash.geom.ColorTransform;
	import flash.geom.Matrix;
	import flash.ui.Keyboard;
	[SWF(width=465,height=465,frameRate=60,backgroundColor=0x000000)]
	/**
	 * ...
	 * @author tkinjo
	 */
	public class Body extends Sprite
	{
		private const TANK_BITMAP_WIDTH:Number  = 60;
		private const TANK_BITMAP_HEIGHT:Number = 60;
		private const TANK_WIDTH:Number  = 50;
		private const TANK_HEIGHT:Number = 30;
		
		private var bitmap:Bitmap;
		private var tankBodyBitmapData:BitmapData;
		
		private var tankBody:Sprite;
		private var gun:Sprite;
		
		private var leftKey:Boolean;
		private var rightKey:Boolean;
		private var upKey:Boolean;
		private var downKey:Boolean;
		
		public function Body() 
		{
			tankBodyBitmapData = new BitmapData( TANK_BITMAP_WIDTH, TANK_BITMAP_HEIGHT, true, 0 );
			
			createTankBody();
			
			bitmap = new Bitmap( new BitmapData( TANK_BITMAP_WIDTH, TANK_BITMAP_HEIGHT, true, 0 ) );
			addChild( bitmap );
			
			addEventListener(Event.ENTER_FRAME, enterFrameHandler );
			stage.addEventListener(KeyboardEvent.KEY_DOWN, function( event:KeyboardEvent ):void { KeyboardManager.keyPressed ( event.keyCode ); } );
			stage.addEventListener(KeyboardEvent.KEY_UP,   function( event:KeyboardEvent ):void { KeyboardManager.keyReleased( event.keyCode ); } );
		}
		
		
		private function createTankBody():void {
			
			// draw tankBody
			tankBody = new Sprite();
			
			// body
			var gradientMatrix:Matrix = new Matrix();
			gradientMatrix.createGradientBox( TANK_WIDTH + 10, TANK_HEIGHT + 10, 0, -5 - ( TANK_WIDTH / 2 ), -5 - ( TANK_HEIGHT / 2 ) );
			tankBody.graphics.lineStyle( 1, 0xffffff, 0.5, true );
			tankBody.graphics.beginGradientFill( 
					GradientType.RADIAL, 
					new Array( 0x666666, 0x333333, 0x000000 ), 
					new Array( 1, 1, 1 ), 
					new Array( 0, 160, 255 ), 
					gradientMatrix
				);
			tankBody.graphics.drawRoundRect( -( TANK_WIDTH / 2 ), -( TANK_HEIGHT / 2 ), TANK_WIDTH, TANK_HEIGHT, 10, 10 );
			
			// direction mark
			tankBody.graphics.beginFill( 0xffffff );
			tankBody.graphics.moveTo(  3,  0 );
			tankBody.graphics.lineTo( -3,  3 );
			tankBody.graphics.lineTo( -3, -3 );
			
            tankBody.graphics.endFill();
			
			tankBody.filters = new Array( new GlowFilter( 0xffffff, 1, 8, 8, 0.2 ) );
			
			// gun
			gun = new Sprite();
			gun.graphics.beginFill( 0xffffff );
			gun.graphics.drawEllipse( 9, -1, 2, 2 );
            gun.graphics.endFill();
			
			tankBody.addChild( gun );
		}
		
		private function enterFrameHandler( event:Event ):void {
			
			draw( bitmap.bitmapData );
		}
		
		private function roatationBitmapData( bitmapData:BitmapData, degrees:Number ):BitmapData {
			
			var tempSprite:Sprite = new Sprite();
			var tempBitmap:Bitmap = new Bitmap( bitmapData );
			tempBitmap.x = -bitmapData.width / 2;
			tempBitmap.y = -bitmapData.height / 2;
			tempSprite.addChild( tempBitmap );
			
			var tempBitmapData:BitmapData = new BitmapData( bitmapData.width, bitmapData.height, true, 0 );
			var matrix:Matrix = new Matrix();
			matrix.createBox( 1, 1, degrees / 180 * Math.PI, bitmapData.width / 2, bitmapData.height / 2 );
			tempBitmapData.draw( tempSprite, matrix );
			bitmapData = new BitmapData( bitmapData.width, bitmapData.height, true, 0 );
			bitmapData.draw( tempBitmapData );
			
			return bitmapData;
		}
		
		private function draw( bitmapData:BitmapData ):void {
			
			tankBodyBitmapData = new BitmapData( TANK_BITMAP_WIDTH, TANK_BITMAP_HEIGHT, true, 0 );
			tankBodyBitmapData.draw( bitmapData );
			
			
			
			if ( KeyboardManager.getRepeatedKey( Keyboard.LEFT ) )
				tankBodyBitmapData = roatationBitmapData( tankBodyBitmapData, 4 );
				
			if ( KeyboardManager.getRepeatedKey( Keyboard.RIGHT ) )
				tankBodyBitmapData = roatationBitmapData( tankBodyBitmapData, -4 );
				
			if ( KeyboardManager.getRepeatedKey( Keyboard.UP ) )
				tankBodyBitmapData.scroll( 0, 2 );
				
			if ( KeyboardManager.getRepeatedKey( Keyboard.DOWN ) )
				tankBodyBitmapData.scroll( 0, -2 );
				
			if ( KeyboardManager.getRepeatedKeyAtChar( 'x' ) )
				gun.rotation--;
				
			if ( KeyboardManager.getRepeatedKeyAtChar( 'c' ) )
				gun.rotation++;
			
			
			
			tankBodyBitmapData.colorTransform(tankBodyBitmapData.rect, new ColorTransform(1, 1, 1, 1 - 1 / 4) );
			
			// draw bitmap
			var matrix:Matrix = new Matrix();
			matrix.createBox( 1, 1, -( Math.PI / 2 ),  TANK_BITMAP_WIDTH / 2, TANK_BITMAP_HEIGHT / 2 );
			tankBodyBitmapData.draw( tankBody, matrix );
			
			bitmapData.colorTransform( bitmapData.rect, new ColorTransform( 1, 1, 1, 0 ) );
			bitmapData.draw( tankBodyBitmapData );
		}
	}
}

import flash.errors.IllegalOperationError;
	
/**
 * ...
 * @author tkinjo
 */
class KeyboardManager 
{
	private static var pressedKey :Vector.<Boolean>;
	private static var releasedKey:Vector.<Boolean>;
	private static var repeatedKey:Vector.<Boolean>;
	
	private static var instance:KeyboardManager = new KeyboardManager();
	
	private static const alphabets:Array = new Array( "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z" );
	
	public function KeyboardManager():void {
		
		if ( instance != null )
			throw new IllegalOperationError ("Use Singleton.getInstance() to get the instance");
		
		pressedKey = new Vector.<Boolean>(0xff);
		releasedKey = new Vector.<Boolean>(0xff);
		repeatedKey = new Vector.<Boolean>(0xff);
	}
	
	
	
	
	
	
	public static function keyPressed( nChar:uint ):void
	{
		pressedKey[nChar] = true;
		repeatedKey[nChar] = true;
	}

	public static function keyReleased( nChar:uint ):void
	{
		repeatedKey[nChar] = false;
		releasedKey[nChar] = true;
	}
	
	
	
	
	
	
	
	
	

	public static function getPressedKey( nChar:uint ):Boolean
	{
		if(pressedKey[nChar]) {
			pressedKey[nChar] = false;
			return true;
		} else {
			return false;
		}
	}

	public static function getReleasedKey( nChar:uint ):Boolean
	{
		if(releasedKey[nChar]) {
			releasedKey[nChar] = false;
			return true;
		} else {
			return false;
		}
	}

	public static function getRepeatedKey( nChar:uint ):Boolean
	{
		return repeatedKey[nChar];
	}

	
	
	
	
	
	
	
	
	public static function getPressedKeyAtChar( char:String ):Boolean
	{
		var keyCode:uint = charToKeyCode( char );
		
		return getPressedKey( keyCode );
	}

	public static function getReleasedKeyAtChar( char:String ):Boolean
	{
		var keyCode:uint = charToKeyCode( char );
		
		return getReleasedKey( keyCode );
	}

	public static function getRepeatedKeyAtChar( char:String ):Boolean
	{
		var keyCode:uint = charToKeyCode( char );
		
		return getRepeatedKey( keyCode );
	}
	
	
	
	
	
	
	
	
	
	private static const CHAR_CODE_0:uint = 48;
	private static const CHAR_CODE_9:uint = 57;
	private static const CHAR_CODE_SMALL_A:uint = 97;
	private static const CHAR_CODE_SMALL_Z:uint = 122;
	private static const KEY_CODE_0:uint = 48;
	private static const KEY_CODE_9:uint = 57;
	private static const KEY_CODE_A:uint = 60;
	private static const KEY_CODE_Z:uint = 90;
	private static const ALPHABET_CHAR_CODE_TO_KEY_CODE:int = -32;
	private static const ALPHABET_KEY_CODE_TO_CHAR_CODE:int = 32;
	
	public static function charToKeyCode( char:String ):uint {
		
		var charCode:uint = char.charCodeAt();
		var keyCode:uint = charCodeToKeyCode( charCode );
		
		return keyCode;
	}
	
	public static function charCodeToKeyCode( charCode:uint ):uint {
		
		// number
		if( CHAR_CODE_0 <= charCode && charCode <= CHAR_CODE_9 )
			return charCode;
		
		// alphabet
		if( CHAR_CODE_SMALL_A <= charCode && charCode <= CHAR_CODE_SMALL_Z )
			return charCode + ALPHABET_CHAR_CODE_TO_KEY_CODE;
		
		return 0;
	}
	
	public static function keyCodeToChar( keyCode:uint ):String {
		
		// number
		if( KEY_CODE_0 <= keyCode && keyCode <= KEY_CODE_9 )
			return ( keyCode - KEY_CODE_0 ).toString();
		
		// alphabet
		if( KEY_CODE_A <= keyCode && keyCode <= KEY_CODE_Z )
			return alphabets[ keyCode - KEY_CODE_A ];
		
		return null;
	}
	
	public static function keyCodeToCharCode( keyCode:uint ):uint {
		
		// number
		if( KEY_CODE_0 <= keyCode && keyCode <= KEY_CODE_9 )
			return keyCode;
		
		// alphabet
		if( KEY_CODE_A <= keyCode && keyCode <= KEY_CODE_Z )
			return keyCode + ALPHABET_KEY_CODE_TO_CHAR_CODE;
		
		return 0;
	}
}