/**
 * Copyright greatcojika ( http://wonderfl.net/user/greatcojika )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/swTV
 */

// forked from sake's PV3Dその3
/*
    Vectorvision3DがPV3Dに統合されたらしいと。
    ただ、Word3D → text3Dと、VectorShapeMaterial → Letter3DMaterial　となってる。
    ここ以外はたぶん同じ。
*/

package
{
	import caurina.transitions.Tweener;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.filters.BlurFilter;
	import flash.utils.setInterval;
	import org.papervision3d.cameras.Camera3D;
	import org.papervision3d.materials.special.Letter3DMaterial;
	import org.papervision3d.objects.DisplayObject3D;
	import org.papervision3d.render.BasicRenderEngine;
	import org.papervision3d.scenes.Scene3D;
	import org.papervision3d.typography.Text3D;
	import org.papervision3d.typography.fonts.HelveticaBold;
	import org.papervision3d.view.Viewport3D;
	import org.papervision3d.view.layer.ViewportLayer;
	import flash.events.IOErrorEvent;
	import flash.events.MouseEvent;
	import flash.net.URLLoader;
	import flash.net.URLRequest;
	import flash.text.StyleSheet;
	import flash.text.TextField;
	import flash.text.TextFieldAutoSize;
	import flash.text.TextFieldType;

	
	[SWF(width="465", height="465", backgroundColor="0xFFFFFF", frameRate="30")]
	public class PV3D_sample03 extends Sprite
	{
		private var container:Sprite;
		private var viewport:Viewport3D;
		private var scene:Scene3D;
		private var camera:Camera3D;
		private var render:BasicRenderEngine;
		private var rootNode:DisplayObject3D;
		private var words1:Text3D;
		private var words2:Text3D;
		private var words3:Text3D;
		private var theta:Number;
		private var delayTime:Number;
		private var WordMoveType:Number;
		private const zoom:Number=20;
		private const focus:Number=30;
		private const distance:Number=600;
		private var atom:Namespace = new Namespace("http://www.w3.org/2005/Atom");


		public function PV3D_sample03()
		{
			
			//PV3Dの設定
			theta=0;
			WordMoveType=0;
			delayTime=0;

			container=new Sprite();
			addChild(container);
			container.x=stage.stageWidth / 2;
			container.y=stage.stageHeight / 2;

			viewport=new Viewport3D(0, 0, true, true);
			scene=new Scene3D();
			camera=new Camera3D();
			render=new BasicRenderEngine();
			rootNode=scene.addChild(new DisplayObject3D("rootNode"));
			addChild(viewport);
			camera.target=DisplayObject3D.ZERO;
			camera.zoom=zoom;
			camera.focus=focus;

			var mat:Letter3DMaterial=new Letter3DMaterial();
			mat.fillColor=0xFFCC00;
			mat.doubleSided=true;
			mat.doubleSided=mat.interactive=true;
			
			words1=new Text3D("tfsasdasdasdadaaa", new HelveticaBold(), mat);
			rootNode.addChild(words1);
			words1.y=50;
			words1.scale=0.3;

			dispersionWords(words1);
			setInterval(moveWords, 10000);
			addEventListener(Event.ENTER_FRAME, onFrame);
			
			
			//ここからXMLのよみこみ
			var tf:TextField = new TextField();
			tf.width = 412;
			tf.height = 412;
			tf.wordWrap = true;
			tf.selectable = true;
			addChild(tf);
			
			var loader:URLLoader = new URLLoader();
			loader.addEventListener(Event.COMPLETE, loaderCompleteHundler);
			loader.load(new URLRequest("http://search.twitter.com/search.atom?q=signage"));
			
			function loaderCompleteHundler (e:Event):void 
			{
				default xml namespace = atom;
				var entrys:XMLList = XML(loader.data).entry;
				var s:String = "";
				
				for each(var x:XML in entrys)
				{
					s += entryToString(x);
				}
				tf.text = s;
			}
		}
		
		private function entryToString(entry:XML):String
		{
			var s:String =  entry.title[0] + "\n\n";
			return s;
		}

		private function dispersionWords(words:Text3D):void
		{
			for each(var word:DisplayObject3D in words.letters)
			{
				word.extra={x:word.x, y:word.y, z:word.z};
				word.x=word.y=word.z=word.scale=0;
				Tweener.addTween(word, {scale:1, x:Math.random() * 2000 - 1000, y:Math.random() * 2000 - 1000, z:Math.random() * 2000 - 1000, rotationX:Math.random() * 360, rotationY:Math.random() * 360, rotationZ:Math.random() * 360, time:3, delay:2 * Math.random() + 1});
			}
		}

		private function moveWords():void
		{
			if (WordMoveType % 2 == 0)
			{
				resetWords(words1);
				delayTime=0;
				WordMoveType++;
			}
			else
			{
				breakWords(words1);
				WordMoveType++;
			}
		}

		private function resetWords(words:Text3D):void
		{
			for each(var word:DisplayObject3D in words.letters)
			{
				Tweener.addTween(word, {x:word.extra.x, y:word.extra.y, z:word.extra.z, rotationX:0, rotationY:0, rotationZ:0, time:1, transition:"easeOutBounce", delay:delayTime});
				Tweener.addTween(word, {rotationY:720, time:1, delay:delayTime + 2});
				delayTime+=0.1;
			}
		}

		private function breakWords(words:Text3D):void
		{
			for each(var word:DisplayObject3D in words.letters)
			{
				Tweener.addTween(word, {x:Math.random() * 2000 - 1000, y:Math.random() * 2000 - 1000, z:Math.random() * 2000 - 1000, rotationX:Math.random() * 360, rotationY:Math.random() * 360, rotationZ:Math.random() * 360, time:4, delay:3 * Math.random()});
			}
		}

		private function onFrame(e:Event):void
		{
			camera.x=distance * Math.sin(theta * Math.PI / 180);
			camera.z=distance * Math.cos(theta * Math.PI / 180);
			theta+=0.2;

			setBlur(words1);
			render.renderScene(scene, camera, viewport);
		}

		private function DistanceFromCamera(obj:DisplayObject3D):Number
		{
			var vecX:Number=obj.sceneX - camera.x;
			var vecY:Number=obj.sceneY - camera.y;
			var vecZ:Number=obj.sceneZ - camera.z;
			return Math.sqrt((vecX * vecX) + (vecY * vecY) + (vecZ * vecZ));
		}

		private function setBlur(words:Text3D):void
		{
			for each(var word:DisplayObject3D in words.letters)
			{
				var vpl:ViewportLayer=word.createViewportLayer(viewport, true);
				var d:Number=Math.abs(DistanceFromCamera(word) - distance) / 40;
				vpl.filters=[new BlurFilter(d, d, 1)];
			}
		}
	}
}