/**
 * Copyright gaina ( http://wonderfl.net/user/gaina )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/swIR
 */

package 
{
    import caurina.transitions.Tweener;
    import caurina.transitions.properties.ColorShortcuts;
    import com.bit101.components.Label;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.media.SoundMixer;
    import flash.utils.ByteArray;
    
    /**
     * ...
     * @author gaina
     * Music by AlainMikuni
     */
    
    public class Main extends Sprite 
    {
        private var _sp:Sprite;
        private var _sp2:Sprite;
        private const HEN:Number = 10;
        
        public function Main():void 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            ColorShortcuts.init();
            _sp = new Sprite();
            _sp.graphics.beginFill(0);
            _sp.graphics.drawRect(-HEN / 2, -HEN / 2, HEN, HEN);
            _sp.graphics.endFill();
            addChild(_sp);
            _sp.x = stage.stageWidth / 3;
            _sp.y = stage.stageHeight / 2;
            var _label:Label = new Label(stage, 0, 0, "FFTMode = FALSE");
            _label.x = _sp.x -_label.width / 2;
            _label.y = _sp.y + HEN;
            
            _sp2 = new Sprite();
            _sp2.graphics.beginFill(0);
            _sp2.graphics.drawRect(-HEN / 2, -HEN / 2, HEN, HEN);
            _sp2.graphics.endFill();
            addChild(_sp2);
            _sp2.x = stage.stageWidth / 3 * 2;
            _sp2.y = stage.stageHeight / 2;
            var _label2:Label = new Label(stage, 0, 0, "FFTMode = TRUE");
            _label2.x = _sp2.x -_label2.width / 2;
            _label2.y = _sp2.y + HEN;
            
            addEventListener(Event.ENTER_FRAME, loop);
            
            var _sound:PlaySound = new PlaySound("http://www.takasumi-nagai.com/soundfiles/sound006.mp3");
        }
        
        private function loop(e:Event):void 
        {
            var _bytesF:ByteArray = new ByteArray();
            var _bytesT:ByteArray = new ByteArray();
            SoundMixer.computeSpectrum(_bytesF, false, 0);
            SoundMixer.computeSpectrum(_bytesT, true, 0);
            var p:Number = 0;
            var o:Number = 0;
            for (var i:int = 0; i < 512; i++)
            {
                p += _bytesF.readFloat();
                o += _bytesT.readFloat();
            }
            _sp.rotation = p * 12;
            _sp2.rotation = o * 12;
            Tweener.addTween(_sp, { scaleY:p, scaleX:p, time: 0.5 } );
            
            if(p < 0) {
                Tweener.addTween(_sp, {_color:0x0000FF} );
            }else{
                Tweener.addTween(_sp, {_color:0x000000} );
            }
            
            Tweener.addTween(_sp2, { scaleY:o, scaleX:o, time: 0.5 } );
        }
        
    }
    
}

import flash.events.Event;
import flash.media.Sound;
import flash.media.SoundLoaderContext;
import flash.media.SoundTransform;
import flash.net.URLRequest;

class PlaySound
{
    private var sound:Sound;

        public function PlaySound(url:String)
        {
            sound = new Sound();
            var _context:SoundLoaderContext = new SoundLoaderContext(1000, true);
            sound.addEventListener(Event.COMPLETE, SoundLoadeComplete);
            sound.load(new URLRequest(url), _context);
        }
        
        private function SoundLoadeComplete(e:Event):void 
        {
            sound.play(0, 10, new SoundTransform(0.3, 0));
        }
}