/**
 * Copyright bambula.filip1 ( http://wonderfl.net/user/bambula.filip1 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/svyM
 */

// forked from fladdict's forked from: fladdict challenge for professionals
// forked from checkmate's fladdict challenge for professionals
/**
 * Theme:
 * Play with BitmapPatterBuilder.
 * Purpose of this trial is to find the possibility of the dot pattern.
 *
 * by Takayuki Fukatsu aka fladdict
 **/
package {
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.events.*;
    import flash.geom.Matrix;
    import flash.display.Graphics;
    import flash.display.Sprite;
    import flash.display.StageScaleMode;
    
    
    public class Professional extends Sprite {
        public var ar:Array;
        public var rot:Number = 0;
        public function Professional() {
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.addEventListener(Event.ENTER_FRAME, enterFrameHandler);
            ar = [[]];
        }
        
        protected function enterFrameHandler(e:Event):void
        {
            rot += 0.01;
            var mat:Matrix = new Matrix();
            mat.translate(Math.random()*10, Math.random()*10);
            mat.scale(10,10);
            mat.rotate(rot);
            //mat.scale(Math.random()*2,Math.random()*2);
            var div:Number = 4
            ar = [[int(mat.a)%div, int(mat.b)%div],[int(mat.c)%div, int(mat.d)%div], [int(mat.tx)%div, int(mat.ty)%div]];
            
            
            var pattern:BitmapData = BitmapPatternBuilder.build(ar, [0xff000000, 0xff66666666, 0xff999999, 0xffffffff]);
            var g:Graphics = graphics;
            g.clear();
            g.beginBitmapFill(pattern);
            g.drawRect(0,0,48,480);
            g.endFill();
        }
        
        //most simple patern
        public function sample1():BitmapData{
            return BitmapPatternBuilder.build(
                [[1,0],
                 [0,1]],
                [0xff000000, 0xffffffff]
            );
        }
    
        
    }
}

/**-----------------------------------------------------
 * Use following BitmapPatternBuilder class 
 * 
 * DO NOT CHANGE any codes below this comment.
 *
 * -----------------------------------------------------
*/
import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.Graphics;
    
class BitmapPatternBuilder{
    /**
     * creates BitmapData filled with dot pattern.
     * First parameter is 2d array that contains color index for each pixels;
     * Second parameter contains color reference table.
     *
     * @parameter pattern:Array 2d array that contains color index for each pixel.
     * @parameter colors:Array 1d array that contains color table.
     * @returns BitmapData
     */
    public static function build(pattern:Array, colors:Array):BitmapData{
        var bitmapW:int = pattern[0].length;
        var bitmapH:int = pattern.length;
        var bmd:BitmapData = new BitmapData(bitmapW,bitmapH,true,0x000000);
        for(var yy:int=0; yy<bitmapH; yy++){
            for(var xx:int=0; xx<bitmapW; xx++){
                var color:int = colors[pattern[yy][xx]];
                bmd.setPixel32(xx, yy, color);
            }
        }
        return bmd;
    }
    
    /**
     * short cut function for Graphics.beginBitmapFill with pattern.
     */
    public static function beginBitmapFill(pattern:Array, colors:Array, graphics:Graphics):void{
        var bmd:BitmapData = build(pattern, colors);
        graphics.beginBitmapFill(bmd);
        bmd.dispose();        
    }
}