/**
 * Copyright WLAD ( http://wonderfl.net/user/WLAD )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/svlC
 */

package {
    import flash.geom.Point;        
    import flash.display.Sprite;
    import flash.display.Shape;
    public class Main extends Sprite
    {
        
        private var tailLenght:Number=1;
        private var tailNodes:Number=600;
        private var bgShape:Shape=new Shape();
        private var tailShape:Shape=new Shape();
        private var nodes:Vector.<Point>=new Vector.<Point>();
        
        public function Main() 
        {
            graphics.beginFill(0);
            graphics.drawRect(0,0,stage.stageWidth,stage.stageWidth);
            graphics.endFill();
            addChild(bgShape);
            bgShape.graphics.beginFill(0x000000);
            bgShape.graphics.drawRect(0, 0,640, 480);
            bgShape.graphics.endFill();
            addChild(tailShape);
            for (var i:Number=0; i<tailNodes; i++) 
                nodes[i]=new Point(320,240);
            stage.addEventListener('mouseMove', draw);  
        }
        
        private function draw(e:*=null):void
        {
            var localPos:Point=new Point(mouseX, mouseY);
            tailShape.graphics.clear();
            tailShape.graphics.lineStyle(4,0xffffff);
            tailShape.graphics.beginFill(0xffffff);
            tailShape.graphics.drawCircle(localPos.x,localPos.y,5);
            tailShape.graphics.endFill();
            tailShape.graphics.moveTo(localPos.x,localPos.y);
            nodes[0]=new Point(localPos.x,localPos.y);
            for (var i:Number=1; i<tailNodes-1; i++) 
            {
                var nodeAngle:Number=Math.atan2(nodes[i].y-nodes[i-1].y,nodes[i].x-nodes[i-1].x);
                nodes[i]=new Point(nodes[i-1].x+tailLenght*Math.cos(nodeAngle),nodes[i-1].y+tailLenght*Math.sin(nodeAngle));
                tailShape.graphics.lineTo(nodes[i].x,nodes[i].y);
            }
        }
    }
}