/**
 * Copyright zahir ( http://wonderfl.net/user/zahir )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/svXK
 */

/*
 再生するとファイルを保存するためのダイアログが勝手に開くので注意
 
 フォトショップのスウォッチ用のファイル.acoを保存するサンプルです。
 カラーパレットを他のソフト向けに変換したりしたいと思い調べてみました。
 読み込むのは前回の投稿になります。
 
 * */
package{
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.net.FileReference;
	import flash.utils.ByteArray;

	public class SaveACOFormat extends Sprite{
		private const color:Array = [
			{	"r":0,			"g":16,	 		"b":32,			"name":"abc" },
			{	"r":255, 		"g":0, 				"b":0,				"name":"Red" },
			{	"r":0, 			"g":0, 				"b":255,			"name":"青" }
		];
		public function SaveACOFormat(){
			stage.addEventListener(MouseEvent.CLICK, onClick);
		}
		private function onClick(e:MouseEvent):void{
			stage.removeEventListener(MouseEvent.CLICK, onClick);
			var f:FileReference = new FileReference();
			f.addEventListener(Event.SELECT, function(e:MouseEvent):void{});
			f.save( parse( color ) , "test.aco" );
		}
		
		private function parse( data:Array ):ByteArray{
			if(!data) return null;
			// formatはUTF-16
			var b:ByteArray = new ByteArray();
			
			//セクション1
			//スウォッチをサムネ表示の時に使う部分（と思われる
			b.writeShort( 1 ); // セクションナンバー
			b.writeShort( data.length ); //色の数
			
			//ここから色の登録
			for(var i:int = 0, len:int = data.length; i<len; i++){
				b.writeShort( 0 ); //セパレータ
				b.writeShort( (data[i].r<<8 | data[i].r) ); //　R
				b.writeShort( (data[i].g<<8 | data[i].g) ); //　G
				b.writeShort( (data[i].b<<8 | data[i].b) ); //　B
				b.writeShort( 0 ); //セパレータ
			}
			
			//セクション2
			//スウォッチをリスト表示の時に使う部分
			b.writeShort( 2 ); // セクションナンバー
			b.writeShort( data.length ); //色の数
			
			//ここから色の登録
			for(i=0; i<len; i++){
				b.writeShort( 0 ); //セパレータ
				b.writeShort( (data[i].r<<8 | data[i].r) ); //　R
				b.writeShort( (data[i].g<<8 | data[i].g) ); //　G
				b.writeShort( (data[i].b<<8 | data[i].b) ); //　B
				b.writeShort( 0 ); //セパレータ
				
				//色の名前 無名(空白)にしたらどうなるんだろう？
				var _name:String = data[i].name;
				b.writeShort( 0 ); //セパレータ
				b.writeShort( _name.length + 1 ); //名前のストリングの長さを定義
				
				// 名前をutf-16で書き込み
				for(var j:int = 0, nlen:int = _name.length; j<nlen; j++){
					b.writeShort( _name.charCodeAt( j ) ); // writeMultiBytes(_name,"unicode");では駄目でした
				}
				
				b.writeShort( 0 ); //セパレータ
			}
			
			b.position = 0;
			return b;
		}// end function parse
		
	}// end class
}// end package


