/**
 * Copyright zier ( http://wonderfl.net/user/zier )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/suVA
 */

package {
    import flash.events.Event
    import org.papervision3d.view.BasicView
    import org.papervision3d.lights.*
    import org.papervision3d.materials.utils.MaterialsList;
    import org.papervision3d.materials.shadematerials.*
    import org.papervision3d.objects.primitives.*

    [SWF(backgroundColor='0x4e616b')]
    public class CubeSample extends BasicView {
        private const DEGREE_TO_RADIAN: Number = Math.PI / 180
        //private var objects: Array = new Array()
        private var rot: Number = 0
        
        private var light:PointLight3D = new PointLight3D()
        private var white: FlatShadeMaterial = new FlatShadeMaterial(light, 0xFFFFFF, 0xFFFFFF, 0)
        private var blue: FlatShadeMaterial = new FlatShadeMaterial(light, 0x0000FF, 0x0000FF, 0)
        private var green: FlatShadeMaterial = new FlatShadeMaterial(light, 0x00FF00, 0x00FF00, 0)
        private var red: FlatShadeMaterial = new FlatShadeMaterial(light, 0xFF0000, 0xFF0000, 0)
        private var yellow: FlatShadeMaterial = new FlatShadeMaterial(light, 0xFFFF00, 0xFFFF00, 0)
        private var orange: FlatShadeMaterial = new FlatShadeMaterial(light, 0xFF8000, 0xFF8000, 0)
        private var black: FlatShadeMaterial = new FlatShadeMaterial(light, 0x000000, 0x000000, 0)
         
        private function createCube(x: int, y: int, z: int, size: int, space: int): Cube {
            var list: MaterialsList = new MaterialsList()
            list.addMaterial((z <= 0) ? black : red, "front")
            list.addMaterial((y <= 0) ? black : white, "top")
            list.addMaterial((x <= 0) ? black : green, "right")
            list.addMaterial((0 <= x) ? black : yellow, "left")
            list.addMaterial((0 <= y) ? black : blue, "bottom")
            list.addMaterial((0 <= z) ? black : orange, "back")
            
            var cube: Cube = new Cube(list, size, size, size, 1, 1, 1, 0, 0)
            var pos: Number = (size + space)
            cube.x = x * pos
            cube.y = y * pos
            cube.z = z * pos
            return cube
        }
        
        public function CubeSample() {
            const SIZE: Number = 150
            const SPACE: Number = 50

            for (var x: int = -1; x <= 1; x++)
            for (var y: int = -1; y <= 1; y++)
            for (var z: int = -1; z <= 1; z++) {
                if (0 == x && 0 == y && 0 == z) continue
            
                var cube: Cube = createCube(x, y, z, SIZE, SPACE)
                //objects.push(cube)
                scene.addChild(cube)
            }
            
            startRendering()
            addEventListener(Event.ENTER_FRAME, onEnterFrame)
        }
        
        private function onEnterFrame(e: Event): void {
            rot = (rot + 2) % 360
            
            camera.x = 1000 * Math.sin(rot * DEGREE_TO_RADIAN)
            camera.z = 1000 * Math.cos(rot * DEGREE_TO_RADIAN)
            camera.y = 500 * Math.sin(rot * DEGREE_TO_RADIAN)
            
            /*
            for each (var object in objects) {
                object.rotationY += 2
                object.rotationX += 1
            }
            */
        }
    }
}