/**
 * Copyright kotobuki ( http://wonderfl.net/user/kotobuki )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/su9B
 */

package {
  import flash.display.Sprite;
  import flash.events.Event;

  import funnel.*;

  public class UseTouchPanel extends Sprite {
    // Arduino
    private var arduino:Arduino;

    // タッチパネルのXとYに接続したピン、タッチされているか否かを示すピン
    private var xPin:Pin;

    private var yPin:Pin;

    private var touchPin:Pin;

    // 現在タッチされているか否か
    private var isTouched:Boolean = false;

    // 前回のXとYの値
    private var lastX:Number = 0;

    private var lastY:Number = 0;

    public function UseTouchPanel() {
      // Arduinoの初期化
      arduino = new Arduino(Arduino.FIRMATA);

      // タッチパネルのXとYに接続したピンにスケーラをセット
      xPin = arduino.analogPin(0);
      xPin.addFilter(new Scaler(0, 1, 0, 399));
      yPin = arduino.analogPin(1);
      yPin.addFilter(new Scaler(0, 1, 0, 299));

      // タッチされているか否かを示すピンにSetPointフィルタをセットし
      // イベントリスナをセット
      touchPin = arduino.analogPin(2);
      touchPin.addFilter(new SetPoint([0.5, 0.1]));
      touchPin.addEventListener(PinEvent.RISING_EDGE, 
                                onMake);
      touchPin.addEventListener(PinEvent.FALLING_EDGE, 
                                onBreak);

      // 毎フレームごとに発生するイベントに対するリスナをセット
      addEventListener(Event.ENTER_FRAME, onEnterFrame);
    }

    // パネルに触れたら
    private function onMake(e:PinEvent):void {
      // フラグをtrueにセットし
      isTouched = true;

      // それまで描画されていたものをクリアし、ここから描画を開始する
      graphics.clear();
      graphics.lineStyle(1, 0x000000);
      graphics.moveTo(xPin.value, yPin.value);
    }

    // パネルから離れたら
    private function onBreak(e:PinEvent):void {
      // フラグをfalseにセット
      isTouched = false;
    }

    // 毎フレームごとに以下を実行
    private function onEnterFrame(e:Event):void {
      // もしパネルに触れていたら
      if (isTouched) {
        // xとyの値を読み取る
        var x:Number = xPin.value;
        var y:Number = yPin.value;

        // xまたはyの値が前回と異なっていたら
        if (lastX != x || lastY != y) {
          // 新しい点まで直線を描画する
          graphics.lineTo(x, y);
        }

        // 前回のxとyの値として今回の値をセット
        lastX = x;
        lastY = y;
      }
    }
  }
}
