/**
 * Copyright shinta ( http://wonderfl.net/user/shinta )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/su1o
 */

package{
    
    import alternativ7.engine3d.controllers.SimpleObjectController;
    import alternativ7.engine3d.core.Camera3D;
    import alternativ7.engine3d.core.Object3DContainer;
    import alternativ7.engine3d.core.View;
    import alternativ7.engine3d.materials.FillMaterial;
    import alternativ7.engine3d.primitives.Box;
    import alternativ7.engine3d.primitives.Sphere;
    
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.Event;

    public class main extends Sprite {
        
        private var rootContainer:Object3DContainer = new Object3DContainer();
        private var objectContainer:Object3DContainer;
        private var camera:Camera3D;
        private var box:Box;
        private var innerBox:Box;
        private var controller:SimpleObjectController;
        
        public function main() {
            stage.align = StageAlign.TOP_LEFT;
            stage.scaleMode = StageScaleMode.NO_SCALE;
            
            // Camera and view
            camera = new Camera3D();
            camera.view = new View(stage.stageWidth, stage.stageHeight);
            addChild(camera.view);
            addChild(camera.diagram);
            
            // Initial position
            camera.rotationX = -120*Math.PI/180;
            camera.y = -800;
            camera.z = 400;
            rootContainer.addChild(camera);
            
            // add objectcontainer to root
            objectContainer = new Object3DContainer();
            rootContainer.addChild(objectContainer);
            
            // inner Coloured box
            var dm:Array = [];
            
            dm[0] = new FillMaterial(0x00FF00, 3, 3, 0x909090);
            dm[1] = new FillMaterial(0x9900CC, 3, 3, 0x909090);
            dm[2] = new FillMaterial(0x33FFFF, 3, 3, 0x909090);
            dm[3] = new FillMaterial(0xFF0066, 3, 3, 0x909090);
            dm[4] = new FillMaterial(0x909090, 3, 3, 0x909090);
            
            innerBox = new Box(100, 100, 100, 1, 1, 1,true, false,dm[0],dm[1],dm[2],dm[3],dm[4]);
            objectContainer.addChild(innerBox);
            
            // Coloured box
            // forked from narutohyper's Material [Alternativa3D 7.6 TIPS]
            var cm:Array = [];
            
            cm[0] = new FillMaterial(0x00FF00, 3, 3, 0x909090);
            cm[1] = new FillMaterial(0x9900CC, 3, 3, 0x909090);
            cm[2] = new FillMaterial(0x33FFFF, 3, 3, 0x909090);
            cm[3] = new FillMaterial(0xFF0066, 3, 3, 0x909090);
            cm[4] = new FillMaterial(0x909090, 3, 3, 0x909090);
            
            box = new Box(100, 100, 100, 1, 1, 1,false, false,cm[0],cm[1],cm[2],cm[3],cm[4]);
            objectContainer.addChild(box);
            
            //controler
            controller = new SimpleObjectController(stage, objectContainer, 100);
            controller.mouseSensitivity = 1
            controller.unbindAll()
                
            // Listeners
            stage.addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }
        
        private function onEnterFrame(e:Event):void {
            // Width and height of view
            camera.view.width = stage.stageWidth;
            camera.view.height = stage.stageHeight;
            
            // Render
            camera.render();
            
            // Controller
            controller.update();
        }
        
    }
}