/**
 * Copyright Quasimondo ( http://wonderfl.net/user/Quasimondo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/stRn
 */

// forked from actionscriptbible's Chapter 35 Example 14
package {
  import flash.display.*;
  import flash.events.Event;
  import flash.net.*;
  import flash.utils.ByteArray;
  import flash.utils.getTimer;
  
  [SWF(backgroundColor="#000000")]
  public class ch35ex14 extends Sprite {
    protected var shaders:Vector.<Shader>;
    protected var shape:Shape;
    protected var shaderCount:int = 30;

    public function ch35ex14() {
      shaders =new Vector.<Shader>();

      shape = new Shape();
      shape.x = stage.stageWidth/2; shape.y = stage.stageHeight/2;
      addChild(shape);
      var loader:URLLoader = new URLLoader();
      loader.dataFormat = URLLoaderDataFormat.BINARY;
      //plasma shader courtesy the inimitable mrdoob (Ricardo Cabello)
      loader.load(new URLRequest(
        "http://actionscriptbible.com/files/mrdoob-plasma.pbj"));
      loader.addEventListener(Event.COMPLETE, onLoadComplete);
    }
    
    protected function onLoadComplete(event:Event):void {
      var loader:URLLoader = URLLoader(event.target);
     
     for ( var i:int = 0; i < shaderCount; i++)
     {
     	var plasma:Shader = new Shader()
        plasma.byteCode = ByteArray(loader.data);
        shaders.push(plasma);
      }
      addEventListener(Event.ENTER_FRAME, onEnterFrame);
    }
    
    protected function onEnterFrame(event:Event):void {
      var t:int = getTimer();
      var w:Number = stage.stageWidth/2; 
      var h:Number = stage.stageHeight/2;
      
      
      shape.graphics.clear();
      shape.graphics.lineStyle(10, 0, 1, false, null, CapsStyle.NONE);
      for ( var i:int = 1; i <= shaderCount; i++ )
      {
      	var d:ShaderData = shaders[i-1].data;
      	d.center.value = [i+Math.sin(t*.002)*300+w, Math.cos(t*.0001)*300+h];
      	d.wave.value = [Math.sin(i*t*.0001)*.06+0.01, Math.cos(i*t*.00005)*.05];
      	d.offset.value = [Math.sin(i*t*.0004)*200, Math.cos(i*t*.00003)*200];
      	d.color_offset.value = [Math.sin(i*t*.0002)*2, Math.sin(i*t*.000009)*2,
        Math.cos(i*t*.00005)*2];
      	d.distort.value = [Math.sin(t*.0008)*.05];
      	shape.graphics.lineShaderStyle(shaders[i-1]);
      	shape.graphics.drawCircle(200,200,30+i*11);
    	}
    }
  }
}