/**
 * Copyright hacker_fjam9dgc ( http://wonderfl.net/user/hacker_fjam9dgc )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/stDP
 */

// 消費税などの計算をas3で無難にやり過ごす方法 (たぶん大丈夫)
// 
// as3では、小数が絡んだ掛け算・割り算の処理が面倒。
// 消費税の計算なんかで、慣れていないと頭をかかえることに。
// 
// 例えば、7 x 1.197 の計算は、手持ちのキャノンの計算機では　素直に
// 8.379 とはじき出してくれるのに、何故か　as3 では　8.379000000000001 
// みたいになる事がある。
// これは、自分には難しくて分からないけど as3 の　「仕様」　らしい。
// 参照："Flash returns erroneous results for certain mathematical calculations"
// http://www.adobe.com/cfusion/knowledgebase/index.cfm?id=tn_13989
// 
// 更には、その計算結果を四捨五入しなさいとくれば、余計面倒くさい。
// 
// 最近では toFixed を使って、小数第3位を四捨五入しています。（合っているかな？）
// 以下は、その方法を簡単に纏めてみたものです。
// 注） toFixed の結果は、Sting型の文字列になります。

package {
    // diaplay系
    import flash.display.Sprite;

    // text系
    import flash.text.TextField;
    import flash.text.TextFieldType;
    
    public class FlashTest extends Sprite {
    	
		public function FlashTest() {
            // テキストフィールド準備
            makeMessageField ("fld_message_1", "inputテキストフィールドですので、出力結果欄を自由にスクロール出来ます。詳しくはコメント欄を御覧下さい。" , 0 , 0 , 40) ;
            makeMessageField ("fld_message_2", "四捨五入無し" , 0 , 40, 40) ;
            makeMessageField ("fld_message_3", "" , 0 , 80 , 120 ) ;
            // makeMessageField ("fld_message_4", "補正あり（  使用）" , 0 , 120) ;
            // makeMessageField ("fld_message_5", "" , 0 , 160 );
            makeMessageField ("fld_message_6", "少数第３位で四捨五入（ toFixed 使用 ）" , 0 , 200 , 40) ;
            makeMessageField ("fld_message_7", "" , 0 , 240 , 120 );
            
            // 本題の計算ループ
            // 
            var target_mc_sans : Object  = getChildByName ( "fld_message_3" ) ;
            var target_mc_avec : Object  = getChildByName ( "fld_message_7" ) ;
            var vatInclus : Number ;
            for (var euro : int = 0 ; euro <= 200 ; euro ++ ) {
            		vatInclus = 1.197 * euro ;
            		target_mc_sans.text += euro + " : " + String ( vatInclus ) + "\n";
            		target_mc_avec.text += euro + " : " + vatInclus.toFixed ( 2 ) + "\n";	
            }
        }
        
        private function makeMessageField (namae : String, defaultMessage : String , zahyoX : Number, zahyoY : Number , takasa : Number) : void {
        		var tf_messageField : TextField = new TextField ();
        		tf_messageField.name = namae;
        		tf_messageField.type = "input";
        		tf_messageField.width = 400;
        		tf_messageField.height = takasa;
        		tf_messageField.x = zahyoX;
        		tf_messageField.y = zahyoY;
        		tf_messageField.border = true;
        		tf_messageField.wordWrap = true;
        		tf_messageField.text = defaultMessage;
        		addChild( tf_messageField );
        }
    }
}