/**
 * Copyright christian ( http://wonderfl.net/user/christian )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/stAu
 */

package
{
    import flash.media.*;
    import flash.events.Event;
    import flash.net.URLRequest;
    import flash.display.Sprite;

    import com.bit101.components.HUISlider;

    public class Main extends Sprite
    {
        // https://developers.soundcloud.com/docs/api/reference
        private var CLIENT_ID : String = 'c644fa92a0e751bad397bdd5b8e35ae5',
                     TRACK_ID : Number = 147748576;

        private var smoothstep : SMOOTHSTEPS;

        private var channel : SoundChannel;
        
        private var slider : HUISlider;

        private var volume_previous : Number = 0,
                    index : int = 0;

        private var steps : int = 200, 
                    scale : int = 150,
                    align : int = 150,
                    len : Number;

        private var h : int, w : int;


        public function Main () { addEventListener (Event.ADDED_TO_STAGE, init); }

        private function init (e : Event) : void
        {
            w = stage.stageWidth; h = stage.stageHeight; len = w / steps;

            with (stage) { align = 'TL'; scaleMode = 'noScale'; frameRate = 60; }

            var URL : String = 'https://api.soundcloud.com/tracks/' + TRACK_ID + '/stream?client_id=' + CLIENT_ID;

            var sound : Sound = new Sound (new URLRequest (URL));

            channel = sound.play ();

            with (slider = new HUISlider (this, 10, 10, 'SMOOTHSTEPS', reset))
            { setSliderParams (1, 10, 5); labelPrecision = 0; y = h - 25; tick = 1; }

            reset (); addEventListener (Event.ENTER_FRAME, tick);
        }
        
        private function reset (e : Event = null) : void
        {
            index = 0;

            graphics.clear ();

            smoothstep = new SMOOTHSTEPS (slider.value);
        }

        private function tick (e : Event) : void
        {
            if (index == 0) graphics.clear ();

            var volume : Number = (channel.leftPeak + channel.rightPeak) / 2;

            graphics.lineStyle (1, 0x0080FF);
            graphics.moveTo ((index-1) * len, ((h - align) / 2) - scale * volume_previous);
            graphics.lineTo ( index    * len, ((h - align) / 2) - scale * volume);

            volume_previous = volume;

            smoothstep.push (volume);

            graphics.lineStyle (1, 0);
            graphics.moveTo ((index-1) * len, (h - align) - scale * smoothstep.previous);
            graphics.lineTo ( index    * len, (h - align) - scale * smoothstep.current);

            index += 1;
            index %= steps;
        }
    }
}

final class SMOOTHSTEPS
{
    public var previous : Number, current : Number = 0;

    private var values : Vector.<Number>;

    private var iterator : int = 0;

    private var steps : int;


    public function SMOOTHSTEPS (steps : int) : void
    {
        values = new Vector.<Number> (steps, true);

        this.steps = steps;
    }

    public function push (value : Number) : void
    {
        values [iterator++ % steps] = value;

        var sum : Number = 0,

            tmp : int = iterator < steps ? iterator : steps;

        for (var i : int = 0; i < tmp; i++)
        {
            sum += values [i];
        }

        previous = current;

        current = sum / tmp;
    }
}