/**
 * Copyright Pete ( http://wonderfl.net/user/Pete )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ssH3
 */

// http://www.vectorjunky.com/detail-Other-Another_vector_abstract.php が作りたかったの
//　どなたか助けてください
// http://www.d-project.com/flex/001_DrawPie/　参考にさせてもらいました
// 自分で書いた部分はひどいです

package {
import flash.display.*;
import flash.events.*;
import flash.utils.*;
import flash.text.TextField;
    
public class Main extends Sprite{AVM1Movie
    private var sector7:Sector7;
    private var currentOption:int=0;
    private var optionSet:Array=[ {name:"Default"},
        {name:"Static"    , gradType:0, animation:0, speedDec:0.5, zoom:2.6, rotationY:-20},
        {name:"Clock"     , gradType:0, animation:2, speed:1},
        {name:"Shine"     , gradType:1, animation:0, speed:5, speedDec:0.6, zoom:3.6, rotationZ:-20},
        {name:"Less Level", gradType:0, animation:1, numLevel:7, zoom:5, speedDec:0.8},
        {name:"Reverse"   , gradType:1, animation:0, speed:0.3, speedDec:1.4,zoom:2.6, rotationZ:-40},
        {name:"Preloader" , preloader:true}
    ];
    private var textInfo:TextField=new TextField();
        
    public function Main(){
        addChild(textInfo);
        startDemo();
        stage.addEventListener(MouseEvent.MOUSE_DOWN, function(event:MouseEvent):void{startDemo()});
     }   

    private function startDemo():void{
        textInfo.text=optionSet[currentOption%optionSet.length].name; 
        if(sector7){removeChild(sector7)}
        sector7 = new Sector7(optionSet[currentOption%optionSet.length] );
        sector7.x=200;
        sector7.y=150;
        currentOption++;
        addChild(sector7);
    }
}
}

import flash.text.TextField;
import flash.display.Sprite;
import flash.events.Event;
import com.greensock.*;
import com.greensock.easing.*;

class Sector7 extends Sprite {
    private var colorList:Array = [0x5169cc, 0xdc8840, 0xd11762, 0x3d824c, 0x994a73, 0x5eb4cb, 0xb9c061];
    private var loaderText:TextField;
    private var meter:Number = 0;
    private var list:Array=new Array();
    private var option:Object={gradType:0, animation:1, gradType:1, speed:4.0, speedDec:0.7, numLevel:10, zoom:3.0, rotationX:-50, rotationY:10, rotationZ:10, preloader:false};

    public function Sector7(ref:Object=undefined){
        for(var p:* in ref){ option[p]=ref[p] }
        var cnt:int = 0;
        var speed:Number = option.speed;
        
        for (var n:int = 0; n < option.numLevel; n++){
            var rotSum:Number = 0;
            speed *= option.speedDec;
            for (var i:int = 0; i < 100; i++){
                var len:Number = 0.1 + Math.random() * 1.5;
                list[cnt] = new Object();
                list[cnt].r1 = (5 + n * 12 + Math.random() * Math.random() * 40) * option.zoom;
                list[cnt].r2 = (40 + n * 12) * option.zoom; 
                list[cnt].t1 = rotSum;
                list[cnt].t2 = rotSum + len;
                list[cnt].speed = speed;
                list[cnt].rotation = 0;
                list[cnt].alpha = 0.8 - n / option.numLevel / 10;
                list[cnt].color = colorList[int(Math.random() * colorList.length)];
                rotSum = list[cnt].t2 + 0.01 + Math.random() * Math.random() * 2;
                if (rotSum > 6){ break }
                addPie(list[cnt].r1, list[cnt].r2, list[cnt].t1, list[cnt].t2, list[cnt].speed, list[cnt].rotation, list[cnt].color, list[cnt].alpha);
                cnt++;
            }
        }
       
        this.rotationX = option.rotationX;
        this.rotationY = option.rotationY;
        this.rotationZ = option.rotationZ;
        
        if(option.animation){
            TweenMax.to(this, 8, {rotationX: 30, repeat: -1, yoyo: true, ease: Cubic.easeInOut});
            TweenMax.to(this, 13, {rotationY: 40, repeat: -1, yoyo: true, ease: Cubic.easeInOut});
            TweenMax.to(this, 8, {scaleX: 2, scaleY: 2, repeat: 1, yoyo: true, ease: Cubic.easeInOut});
        }
        
        if(option.preloader){
            loaderText =new TextField();
            addChild(loaderText);
            addEventListener(Event.ENTER_FRAME, function(event:Event):void{
                meter += Math.random() * 5;
                loaderText.text = int(meter) + "%";
            });
        }
    }
    
    private function addPie(r1:Number, r2:Number, t1:Number, t2:Number, speed:Number, rot:Number, col:int, alpha:Number):void {
        var pie:Pie = new Pie(r1, r2, t1, t2, col, alpha, option.gradType);
        pie.x = 0;
        pie.y = 0;
        pie.rotation = rot;
        pie.addEventListener(Event.ENTER_FRAME, function(e:Event):void {
            pie.rotation += speed;
            if(option.animation==2){
                 if(!TweenMax.isTweening(pie)){
                     TweenMax.to(pie, 0.5, {delay:0.01/speed/speed, rotation: pie.rotation+40,  ease: Cubic.easeInOut});
                 }
            }       
        });
        addChild(pie);
        setChildIndex(pie,0);
    }
}

import flash.display.Graphics;
import flash.display.Sprite;
import flash.geom.Point;

class GraphicsLib {
    
    private static const RIGHT_ANGLE:Number = Math.PI / 2;
    
    public static function drawPie(g:Graphics, x:Number, y:Number, r:Number, t1:Number, t2:Number, lineTo:Boolean = false):void {
        
        // 曲線の分割数。多いほど近似の精度は高くなる。
        var div:int = Math.max(1, Math.floor(Math.abs(t1 - t2) / 0.4));
        
        var lx:Number;
        var ly:Number;
        var lt:Number;
        
        for (var i:int = 0; i <= div; i++){
            
            var ct:Number = t1 + (t2 - t1) * i / div;
            var cx:Number = Math.cos(ct) * r + x;
            var cy:Number = Math.sin(ct) * r + y;
            
            if (i == 0){
                if (lineTo){
                    g.lineTo(cx, cy);
                } else {
                    g.moveTo(cx, cy);
                }
            } else {
                var cp:Point = getControlPoint(lx, ly, lt + RIGHT_ANGLE, cx, cy, ct + RIGHT_ANGLE);
                g.curveTo(cp.x, cp.y, cx, cy);
            }
            
            lx = cx;
            ly = cy;
            lt = ct;
        }
    }
    
    public static function getControlPoint(x1:Number, y1:Number, t1:Number, x2:Number, y2:Number, t2:Number):Point {
        
        var x12:Number = x2 - x1;
        var y12:Number = y2 - y1;
        
        var l12:Number = Math.sqrt(x12 * x12 + y12 * y12);
        var t12:Number = Math.atan2(y12, x12);
        
        var l13:Number = l12 * Math.sin(t2 - t12) / Math.sin(t2 - t1);
        
        var x3:Number = x1 + l13 * Math.cos(t1);
        var y3:Number = y1 + l13 * Math.sin(t1);
        
        return new Point(x3, y3);
    }
}



import flash.display.InterpolationMethod;
import flash.display.SpreadMethod;
import flash.geom.Matrix;
import flash.display.Graphics;
import flash.display.Sprite;
import flash.display.GradientType;
import flash.display.GraphicsGradientFill; 

class Pie extends Sprite {
    
    public function Pie(r1:Number, r2:Number, t1:Number, t2:Number, color:uint = 0x000000, alpha:Number = 1.0, gradType:int=1){
        var g:Graphics = graphics;
        var matrix:Matrix = new Matrix();
        matrix.createGradientBox(100, 100, Math.random()*360, 0, 0);
        if(gradType==1){
            matrix= new Matrix( 1 , 0 , 0 , 0 , 0 , 0 );
            g.beginGradientFill(GradientType.LINEAR, [color, 0xFFFFFF], [alpha, alpha], [120, 180],matrix, SpreadMethod.PAD, InterpolationMethod.LINEAR_RGB, 0.0);
         }else{
            g.beginGradientFill(GradientType.LINEAR, [color, color], [alpha, alpha/2], [85, 200],matrix, SpreadMethod.PAD, InterpolationMethod.LINEAR_RGB, 0.0);
        }
        GraphicsLib.drawPie(g, 0, 0, r1, t1, t2, false);
        GraphicsLib.drawPie(g, 0, 0, r2, t2, t1, true);
        g.endFill();
    }
}

