/**
 * Copyright kuma360 ( http://wonderfl.net/user/kuma360 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/srqm
 */

package  
{
    import flash.display.*;
    import flash.events.*;
    
    /**
     * [企画]皆で動くパズル作ろうぜ
     * http://wonderfl.net/c/yb0z
     * 前から気になってた事があって、Wonderfl は色んな作品があるけど作品同士のつながりがないのが気になっていた。
     * 例えば、パーツだけ作って読み込んでロードするだけで使える[素材]を作るとか。
     * あと Fork することで何かに参加できるようにすればもっと面白い事になって行きそうなきがする。
     * チェックメイトやJAMのような方法ではなく、Forkされたもの全てが一つの作品を作るというか。
     * これからもチェックメイトやJAM以外にも[企画]タグや[素材]タグが増えていくといいなぁ。
     * @author jc at bk-zen.com
     */
    [SWF (backgroundColor = "0x000000", frameRate = "60", width = "465", height = "465")]
    public class MoviePuzzle extends Sprite 
    {
        private static const BG_COLOR: uint = 0x000000;
        private static const FRAME_RATE: uint = 30;
        
        public function MoviePuzzle() 
        {
            // ローダーで読み込まれなかった時の為のデモ用
            addEventListener(Event.ADDED_TO_STAGE, demo);
        }
        
        /**
         * 
         * MoviePuzzle -> MovieJigsawPuzzle
         *         obj["disp"]      : DisplayObject : 描画対象このオブジェクトの440x440の範囲で切り取られて描画されます。
         *         obj["color"]     : uint : 背景色(省略時は0x000000)
         *         obj["frameRate"] : uint : フレームレート(省略時は60)
         *         obj["level"]     : uint : 上限レベル(省略時は1)
         * @param    obj : <Object>
         */
        public function initialize(obj: Object): void
        {
            disp = new ZAKO();
            obj["disp"]  = disp;
            obj["color"] = BG_COLOR;
            obj["frameRate"]  = FRAME_RATE;
        }
        
        /**
         * スタートする時に呼ばれます。
         * @param    level : uint : 指定レベル : 変える必要があれば。
         */
        public function start(level: uint): void
        {
            Object(disp).start(level);
        }
        
        /**
         * 終了した時に呼ばれます。
         */
        public function end(): void
        {
            Object(disp).end();
        }
        
        private var disp: DisplayObject;
        
        /**
         * デモ用
         * @param    e
         */
        private function demo(e: Event): void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, demo);
            //
            var obj: Object = {};
            initialize(obj);
            disp = obj["disp"];
            var col: uint = obj["color"];
            var bmd: BitmapData = new BitmapData(440, 440, false, col);
            var bmp: Bitmap = new Bitmap(bmd, "auto", true);
            start(1);
            addChild(bmp);
            addEventListener(Event.ENTER_FRAME, function(e: Event): void {
                bmd.lock();
                bmd.fillRect(bmd.rect, col);
                bmd.draw(disp);
                bmd.unlock();
            } );
        }
    }
}
import flash.display.*;
import flash.events.*;
import flash.filters.*;
import flash.geom.*;
import flash.net.*;
import flash.system.*;
import org.libspark.betweenas3.*;
import org.libspark.betweenas3.tweens.*;






class ZAKO extends Sprite {
    
    private var _sceneManager:SceneManager ;
    
    public function ZAKO() {
        _sceneManager = new SceneManager ;
        SceneManager._next = new SceneBattle;
        addChild ( _sceneManager ) ;
    }
    
    public function start ( l:uint ) :void {
        addEventListener ( Event.ENTER_FRAME , _sceneManager.run ) ;
    }
    
    public function end ( ) :void {
        removeEventListener ( Event.ENTER_FRAME , _sceneManager.run ) ;
    }
    
    
}

///
class Global {
    public static var _key:Array = new Array ( 256 ) ;
    public static var _canvas:BitmapData = new BitmapData ( 465 , 465 , false , 0 ) ;
    public static var _back  :BitmapData = new BitmapData ( 465 , 465 , false , 0xF0F0F0 ) ;
}


///
class Effect {
    
    private var _img:BitmapData = null ;
    private var _V:Vector.<Object> = new Vector.<Object> ;
    
    ////////////////////////////////////
    public function Effect() {
    
        _img = new BitmapData ( 50 , 50 , true , 0 ) ;
        
        var S:Sprite = new Sprite ;
        var G:Graphics = S.graphics ;
        var M:Matrix = new Matrix ;
        M.createGradientBox ( 50 , 50 , 0 , 0 , 0 ) ;
        G.lineStyle ( 1 ) ;
        G.lineGradientStyle ( "radial" , [ 0xFFFFFF , 0xFFA020 ] , [ 1 , 0 ] , [ 0 , 255 ] , M ) ;
        for ( var I:int = 0 ; I < 50 ; ++ I ) {
            G.moveTo ( 25 , 25 ) ;
            var R:Number = I / 50 * 360 * Math.PI / 180 ;
            G.lineTo ( Math.cos ( R ) * 25 + 25 , Math.sin ( R ) * 25 + 25 ) ;
        }
        S.filters = [ new BlurFilter ] ;
        _img.draw ( S ) ;
        
    }
    
    ////////////////////////////////////
    public function release ( ) :void {
        _img.dispose ( ) ;
        _img = null ;
    }
    
    ////////////////////////////////////
    public function push ( x:int , y:int ) :void {
        _V.push ( { P:new Point ( x - _img.width * .5 , y - _img.height * 1.5 ) , T:6 } ) ;
    }
    
    ////////////////////////////////////
    public function update () :void {
        for ( var I:int = 0 ; I < _V.length ; ++ I ) {
            if ( -- _V[I].T < 0 ) {
                _V.splice ( I , 1 ) ;
            }
        }
    }
    
    ////////////////////////////////////
    public function render ( ) :void {
        for each ( var O:Object in _V ) {
            Global._canvas.copyPixels ( _img , _img.rect , O.P ) ;
        }
    }
    
}


//
interface Iactor {
    function render_shadow ( ) :void ;
    function render ( ) :void ;
    function get pos ( ) :Vector3D ;
}


//
class BaseActor {
    
    //固有ID
    private static var UNIQUE:uint = 0 ;
    private var _id:uint = 0 ;
    
    //座標
    protected var _pos:Vector3D = new Vector3D ;
    protected var _velocity:Vector3D = new Vector3D ;
    
    //描画用
    protected var _renderpos:Point = new Point ;
    protected var _shadowpos:Point = new Point ;
    
    public function BaseActor() {
        _id = UNIQUE ++ ;
    }
    
    public function get id ( ) :uint {
        return _id ;
    }
    
    public function get pos ( ) :Vector3D {
        return _pos ;
    }
    
}


//
class ActorParam extends BaseActor {
    
    //キャラクタのスケール
    protected const SCALE:Number = 1.5 ;
    
    //キャラクタの実サイズ
    protected var SIZE :int = 0 ;
    protected var _render_rect:Rectangle = null ;
    
    //画像
    protected var _img:BitmapData = null ;
    protected var _img_r:BitmapData = null ;
    protected var _shadow:BitmapData = null ;
    
    public function ActorParam ( B:Bitmap , C:ColorTransform , charctorSize:int ) {
        
        super ( ) ;
        
        SIZE = charctorSize * SCALE ;
        
        var M:Matrix = new Matrix ;
        var S:Sprite = new Sprite;
        var G:Graphics = S.graphics;
        var I:int = 0 ;
        var J:int = 0 ;
        
        var S1:Number = SIZE/4   * SCALE ;
        var S2:Number = SIZE/8   * SCALE ;
        var S3:Number = B.width  * SCALE ;
        var S4:Number = B.height * SCALE ;
        
        //スケーリング
        M.scale ( SCALE , SCALE ) ;
        
        //影
        G.beginFill ( 0 , .5 ) ;
        G.drawEllipse ( 0 , 0 , S1 , S2 ) ;
        G.endFill () ;
        _shadow = new BitmapData ( S1 , S2 , true , 0 ) ;
        _shadow.draw ( S ) ;
        
        //キャラクタ-
        _img = new BitmapData ( S3 , S4 , true , 0 ) ;
        _img.draw ( B , M , C ) ;
        
        //反転キャラクター
        _img_r = new BitmapData ( S3 , S4 , true , 0 ) ;
        for ( I = 0 ; I < S3 ; I += SIZE ) {
            for ( J = 0 ; J < SIZE ; ++ J ) {
                _img_r.copyPixels ( 
                    _img , 
                    new Rectangle ( I + J , 0 , 1 , S4 ) , 
                    new Point ( I + SIZE - J , 0 ) 
                ) ;
            }
        }
        
        //
        _pos.x = Math.random ( ) * 465 ;
        _pos.y = 0 ;
        _pos.z = Math.random ( ) * 100 + 300 ;
        
        _render_rect  = new Rectangle ( 0 , 0 , SIZE , SIZE ) ;
        
    }
    
    public function release ( ):void {
        
        _img.dispose ( ) ;
        _img = null ;
        
        _img_r.dispose ( ) ;
        _img_r = null ;
        
        _shadow.dispose ( ) ;
        _shadow = null ;
        
    }

}


//
class CharctorBase extends ActorParam implements Iactor {
    
    //アニメーションテーブル
    private var $A:Array = null ;
    private var $B:Array = null ;
    private var $C:Array = null ;
    private var $D:Array = null ;
    private var $E:Array = null ;
    private var $F:Array = null ;
    
    //体力
    private var _hp:int = 0 ;
    private var _death:Boolean = false ;
    private var _death_cnt:int = 0;
    
    //アニメーション用
    private var _anim:int = 0 ;
    private var _animwait:int = 0 ;
    private var _action:int = 0 ;
    private var _actionstep:int = 0 ;
    private var _dirc:Boolean = false;
    
    //入力用
    private var _input_damage:Boolean = false ;
    private var _input_attack:Boolean = false ;
    private var _input_jump  :Boolean = false ;
    private var _target_x:int = 0 ;
    private var _target_z:int = 0 ;
    private var _speed:Number = 0 ;
    
    //ジャンプ管理
    private var _jump_state:Boolean = false;
    
    //攻撃管理
    private var _attack_state:int = 0 ;
    private var _attack_shake:int = 0 ;
    private var _hitRegist:Vector.<int> = new Vector.<int> ;
    
    //被ダメージ管理
    private var _damage_action:int = 0 ;
    private var _damage_shake:int = 0 ;
    
    ////////////////////////////////////
    public function CharctorBase ( B:Bitmap , C:ColorTransform , $$A:Array , $$B:Array , $$C:Array , $$D:Array , $$E:Array , $$F:Array ) {
        
        super ( B , C , 64 ) ;
        
        $A = $$A ;
        $B = $$B ;
        $C = $$C ;
        $D = $$D ;
        $E = $$E ;
        $F = $$F ;
        
        _hp = 10 ;
        _death = false ;
        _death_cnt = 0 ;
        input ( Math.random() * 400 , 300 + Math.random() * 150 , false , false ) ;
        
    }
    
    ////////////////////////////////////
    public function input ( x:int , y:int , keyA:Boolean , keyJ:Boolean ):void {
        _input_attack = keyA ;
        _input_jump   = keyJ ;
        _target_x     = x ;
        _target_z     = y ;
    }
    
    ////////////////////////////////////
    public function inputAuto ( ):void {
        
        _input_attack = Math.random() < 0.01 ;
        _input_jump   = Math.random() < 0.01 ;
        
        var V:Vector3D = _pos.clone() ;
        V.x -= _target_x ;
        V.z -= _target_z ;
        if ( V.length < 20 * SCALE ) {
            _target_x = Math.random() * 465 ;
            _target_z = Math.random() * ( 465 - ZMAX ) + ZMAX ;
        }
    }
    
    ////////////////////////////////////
    public function update ( ):void {
        
        var CHK:Boolean = true ;
        var TC:int = $C[_action][_actionstep] ;
        var Ba:int = _action;
        var Bas:int = _actionstep;
        var X:Number = 0 ;
        var Y:Number = 0 ;
        var L:Number = 0 ;
        
        if ( _death ) {
            
            if ( 60 < ++ _death_cnt ) {
                
                _hp = 10 ;
                _death = false ;
                _death_cnt = 0 ;
                
                _pos.x = ( Math.random() < .5 )? -100 : 500 ;
                _pos.y = 0 ;
                _velocity.y = 0 ;
                
                _action = 12 ;
                
            }
            
        }
        
        if ( 0 < _damage_shake ) {
            CHK = false ;
            -- _damage_shake ;
        }
        
        if ( 0 < _attack_shake ) {
            CHK = false ;
            -- _attack_shake ;
        }
        
        {//入力の反映
            
            if ( 1 & TC ) {
                
                X = _pos.x - _target_x ;
                Y = _pos.z - _target_z ;
                L = X * X + Y * Y ;
                _action = ( 10 * 10 < L )? 1 : 0 ;
                
            }
            
            if ( 2 & TC ) {
                
                if ( _input_attack ) {
                    
                    if ( _jump_state ) {
                        
                        _action = 6 ;
                        
                    } else {
                        
                        switch ( _attack_state ) {
                            case 0 : _attack_state = 1 ;  _action = 3 ; break ;
                            case 1 : _attack_state = 2 ;  _action = 7 ; break ;
                            case 2 : _attack_state = 0 ;  _action = 4 ; break ;
                        }
                    }
                    
                } else {
                    
                    _attack_state = 0 ; 
                    
                }
                
            }
            
            if ( 4 & TC ) {
                if ( _input_jump ) {
                    _action = 2 ;
                }
            }
            
            //強制動作
            if ( _damage_action ) {
                _action = _damage_action ;
                _damage_action = 0 ;
            }
            
            if ( Ba != _action ) {
                _actionstep = 0 ;
                _animwait = 0 ;
            }
            
        }
        
        if ( CHK ) 
        {//アニメーション
            
            var TD:int = $D[_action][_actionstep];
            switch ( TD ) {
                
                case 0 :
                    ++ _animwait;
                    break ;
                
                case 1 :
                    if ( 0 < _velocity.y ) {
                        ++ _animwait ;
                    }
                    break ;
                
                case 2:
                    if ( false == _jump_state ) {
                        ++ _animwait ;
                    }
                    break;
                    
                case 3:
                    break;
            }
            
            if ( $B[_action][_actionstep] <= _animwait ) {
                
                _animwait = 0 ;
                
                switch ( $E[_action][_actionstep] ) {
                    case 1: _velocity.y = -5 ; break;
                    case 2: _action = (_jump_state)? 12 : 0 ; break ;
                    default: break;
                }
                
                if ( $A[_action].length <= ++ _actionstep ) {
                    _actionstep = 0 ;
                }
                
                while ( _hitRegist.length ) {
                    _hitRegist.pop () ;
                }
                
            }
            
        }
        
        if ( CHK && ( 1 & TC ) )
        {//加速
            
            _dirc = ( _target_x < _pos.x ) ;
            
            var ty:Number = _velocity.y;
            _velocity.y = 0 ;
            
            X = ( _target_x - _pos.x ) ;
            Y = ( _target_z - _pos.z ) ;
            L = X * X + Y * Y ;
            if ( 10 * 10 < L ) {
                _velocity.x += X * .01 ;
                _velocity.z += Y * .01 ;
            }
            
            _speed = _velocity.length ;
            _speed = ( 2 < _speed )? 2 : _speed ;
            
            _velocity.normalize ( ) ;
            _velocity.scaleBy ( _speed ) ;
            
            _velocity.y = ty ;
            
        }
        
        if ( CHK ) 
        {//移動
            
            _pos.x += _velocity.x * SCALE ;
            _pos.y += _velocity.y * SCALE ;
            _pos.z += _velocity.z * SCALE *.5 ;
            _velocity.y += .2 ;
            
            if ( false == _jump_state ) {
                _velocity.x *= .9 ;
                _velocity.z *= .9 ;
            }
            
            if ( 0 <= _pos.y ) {
                _pos.y = 0 ;
                _jump_state = false ;
            } else {
                _jump_state = true ;
            }
            
            if ( _pos.z < ZMAX ) {
                _pos.z = ZMAX ;
            }
            
        }
        
        _anim = $A[_action][_actionstep] ;
        
    }
    
    ////////////////////////////////////
    public function attackChk ( e:Hero , effect:Effect ):void {
        
        if ( this == e ) {
            return ;
        }
        
        if ( e._death ) {
            return ;
        }
        
        for each ( var N:int in _hitRegist ) {
            if ( N == e.id ) {
                return ;
            }
        }
        
        var temp:int = $F[_action][_actionstep] ;
        if ( temp != 0 ) {
            
            var V:Vector3D = _pos.subtract ( e._pos ) ;
            
            if ( _dirc ) {
                V.x -= 16 * SCALE ;
            } else {
                V.x += 16 * SCALE ;
            }
            
            if ( V.length < 30 ) {
                _attack_shake = 10 ;
                e.damage ( ) ;
                _hitRegist.push ( e.id ) ;
                effect.push ( e.pos.x , e.pos.z + e.pos.y ) ;
            }
            
        }
        
    }
    
    ////////////////////////////////////
    public function damage ( ) :void {
        
        //死亡チェック
        if ( -- _hp <= 0 ) {
            
            _death = true ;
            _death_cnt = 0 ;
            _damage_action = 11 ;
            
        } else {
            
            _damage_action = 8 + Math.floor ( Math.random() * 3 ) ;
            
        }
        
        //ノックバック
        _velocity.x = (_dirc)? -1 : 1 ;
        _damage_shake = 15 ;
        
    }
    
    ////////////////////////////////////
    public function moveChk ( e:Hero ):void {
        
        if ( this == e ) {
            return ;
        }
    
        var V:Vector3D = _pos.subtract ( e._pos ) ;
        if ( V.length < 20 * SCALE ) {
            V.normalize();
            _velocity.x = V.x * 1 ;
            _velocity.z = V.z * 1 ;
        }
        
    }

    ////////////////////////////////////
    public function render_shadow ( ):void {
        _shadowpos.x = _pos.x - SIZE/4/2 * SCALE ;
        _shadowpos.y = _pos.z - SIZE/8/2 * SCALE ;
        Global._canvas.copyPixels ( _shadow , _shadow.rect , _shadowpos ) ;
    }
    
    ////////////////////////////////////
    public function render ( ):void {
                
        if ( _death ) {
            if ( _death_cnt % 10 < 5 ) {
                return ;
            }
        }

        _anim %= 40 ;
        _render_rect.x = Math.floor ( _anim % 8 ) * SIZE ;
        _render_rect.y = Math.floor ( _anim / 8 ) * SIZE ;
        
        _renderpos.x = _pos.x          - SIZE /2 ;
        _renderpos.y = _pos.z + _pos.y - SIZE ;
        
        if ( _damage_shake ) {
            _renderpos.x += Math.random() * 10 - 5 ;
            _renderpos.y += Math.random() * 10 - 5 ;
        }
        
        if ( _dirc ) {
            Global._canvas.copyPixels ( _img_r , _render_rect , _renderpos ) ;
        } else {
            Global._canvas.copyPixels ( _img   , _render_rect , _renderpos ) ;
        }
        
    }
    
}


//シーン管理
class SceneManager extends Sprite {
    
    private var _step:int = 0 ;
    private var _scene:SceneBase = null ;
    public static var _next:SceneBase = null ;
    
    public function SceneManager ( ) {
        _next = new SceneBattle ;
    }

    public function run ( e:Event ):void {
        
        if ( null == _scene ) {
            
            _scene = _next ;
            addChild ( _scene ) ;
            _scene.alpha = 0 ;
            
            _next = null ;
            _step = 0 ;
            
        } else {
            
            switch ( _step ) {
                case 0: 
                    {
                        _step = 1 ;
                        
                        BetweenAS3.to ( _scene , { alpha:1 } , .5 ).play() ;
                        
                        _scene.init ();
                        
                    }
                    break ;
                    
                case 1: 
                    {
                        
                        _scene.core () ; 
                        if ( _next ) {
                            _step = 2 ;
                        }
                        
                    }
                    break ;
                    
                case 2: 
                    {
                        _step = 3 ;
                        
                        _scene.filters = [ new BlurFilter ( 10, 10 ) ] ;
                        var it:ITween = BetweenAS3.to ( _scene , { alpha:0 } , .5 ) ;
                        
                        it.addEventListener (
                            Event.COMPLETE ,
                            function ( e:Event ) :void {
                                it.removeEventListener ( Event.COMPLETE , arguments.callee ) ;
                                _step = 4;
                            }
                        );
                        
                        it.play() ;
                        
                    }
                    break; 
                    
                case 3: 
                    {
                        //待ち
                    }
                    break ;
                    
                case 4:
                    {
                        _scene.release ( ) ;
                        
                        stage.removeChild ( _scene ) ;
                        _scene = null ;
                        
                    }
                    break ;
                
            }
            
        }
        
    }    
    
}


//シーンの基礎
class SceneBase extends Sprite {
    public function init( ):void { } ;
    public function core( ):void { } ;
    public function release( ):void { } ;
}



//戦闘シーン
class SceneBattle extends SceneBase {
    
    private var _rendering_container:Vector.<Iactor> = new Vector.<Iactor> ( ) ;
    private var _h:Vector.<Hero> = null ;
    private var _mainHero:Hero = null ;
    private var _effect:Effect = null ;
    
    ////////////////////////////////////
    public function SceneBattle () {
        
        //キャラクター用
        _h = new Vector.<Hero>;
        
        //ヒットマーク用
        _effect = new Effect ;
        
        //キャラクタ画像読み込み(雑魚)
        var L:Loader = new Loader;
        L.contentLoaderInfo.addEventListener ( Event.COMPLETE, compLoad ) ;
        L.contentLoaderInfo.addEventListener ( IOErrorEvent.IO_ERROR , function ():void { } ) ;
        L.load ( new URLRequest ( FILENAME ) , new LoaderContext ( true ) ) ;
        
        addChild ( new Bitmap ( Global._canvas ) ) ;
        
    }
    
    ////////////////////////////////////
    public override function release ( ) :void {
        
        _effect.release ( ) ;
        
        for each ( var H:Hero in _h ) {
            H.release ( ) ;
        }
        
    }
    
    ////////////////////////////////////
    private function compLoad( e:Event ):void {
        
        var B:Bitmap = e.target.content as Bitmap ;
        
        _mainHero = null ;
        //_mainHero = new Hero ( B ) ;
        //_h.push ( _mainHero ) ;
        
        _h.push ( new Hero ( B , new ColorTransform (  1 , .3 , .3 , 1 ) ) ) ;
        _h.push ( new Hero ( B , new ColorTransform ( .3 ,  1 , .3 , 1 ) ) ) ;
        _h.push ( new Hero ( B , new ColorTransform ( .3 , .3 ,  1 , 1 ) ) ) ;
        _h.push ( new Hero ( B , new ColorTransform (  1 ,  1 , .3 , 1 ) ) ) ;
        _h.push ( new Hero ( B , new ColorTransform (  1 , .3 ,  1 , 1 ) ) ) ;
        _h.push ( new Hero ( B , new ColorTransform ( .3 ,  1 ,  1 , 1 ) ) ) ;
        _h.push ( new Hero ( B , new ColorTransform ( .7 , .7 , .7 , 1 ) ) ) ;
        _h.push ( new Hero ( B , new ColorTransform ( 1 , 1 , 1 , 1 ) ) ) ;
        
    }
    
    ////////////////////////////////////
    public override function core ( ):void {
        
        var TH1:Hero ;
        var TH2:Hero ;
        var SB:Iactor ;
        
        //背景
        Global._back.fillRect ( Global._back.rect , 0x303030 ) ;
        Global._back.fillRect ( new Rectangle ( 5 , 5 , 440 - 10 , 440 - 10 ) , 0xF0F0F0 ) ;
        Global._canvas.copyPixels ( Global._back , Global._back.rect , ZERO_POINT ) ;
        
        //入力
        for each ( TH1 in _h ) {
            if ( TH1 == _mainHero ) {
                _mainHero.input ( mouseX , mouseY , Global._key[90] , Global._key[88] ) ;
            } else {
                TH1.inputAuto() ;
            }
        }
        
        //更新
        for each ( TH1 in _h ) {
            TH1.update ( ) ;
        }
        
        //攻撃判定
        for each ( TH1 in _h ) {
            for each ( TH2 in _h ) {
                TH1.attackChk ( TH2 , _effect ) ;
            }
        }
        
        //移動判定
        for each ( TH1 in _h ) {
            for each ( TH2 in _h ) {
                TH1.moveChk ( TH2 ) ;
            }
        }
        
        
        
        //描画順決定
        _rendering_container = _rendering_container.concat ( _h ) ;
        _rendering_container.sort ( function ( A:Iactor , B:Iactor ) :Number { return A.pos.z - B.pos.z ; } ) ;
        
        //影描画
        for each ( SB in _rendering_container ) {
            SB.render_shadow ( ) ;
        }
        
        //描画
        for each ( SB in _rendering_container ) {
            SB.render ( ) ;
        }
        
        while ( _rendering_container.length ) {
            _rendering_container.pop ( ) ;
        }
        
        _effect.update ( ) ;
        _effect.render ( ) ;
        
    }
    
    
}


//雑魚のモーション
class Hero extends CharctorBase {
        
    //アニメパターン
    private const $HERO_A:Array = [
        [ 0 , 1 , 2 , 3 ] , //歩く
        [ 32 , 33 , 34 , 35 , 36 , 37 ] , //走る
        [ 4 , 5 , 6 , 7 , 4 ] , //飛ぶ
        [ 8 , 9 ] , //パンチ
        [ 10 , 11 , 12 ] , //強いパンチ
        [ 13 , 4 ] , //ジャンプパンチ
        [ 14 , 4 ] , //ジャンプキック
        [ 29 , 15 ] , //キック
        [ 16 ] , //弱ダメージ
        [ 17 ] , //中ダメージ
        [ 18 ] , //強ダメージ
        [ 19 , 20 , 21 , 22 , 22 ] , //ダウン
        [ 7 , 4 ] //落下
    ];

    //ウェイト
    private const $HERO_B:Array = [
        [ 8 , 8 , 8 , 8 ] , //歩く
        [ 5 , 5 , 5 , 5 , 5 , 5 ] , //走る
        [ 2 , 2 , 5 , 2 , 5 ] , //飛ぶ
        [ 9 , 9 ] , //パンチ
        [ 7, 7, 8 ] , //強いパンチ
        [ 2 , 5 ] , //ジャンプパンチ
        [ 2 , 5 ] , //ジャンプキック
        [ 3 , 6 ] , //キック
        [ 15 ] , //弱ダメージ
        [ 15 ] , //中ダメージ
        [ 15 ] , //強ダメージ
        [ 9 , 9 , 9 , 9 , 99 ] , //ダウン
        [ 2 , 5 ] //落下
    ] ;
    
    //入力の許可 1=移動 + 2=攻撃 + 4=ジャンプ + 8=投擲
    private const $HERO_C:Array = [
        [ 15, 15, 15, 15] , //歩く
        [ 15, 15, 15, 15, 15, 15] , //走る
        [ 0 , 2 , 2 , 2 , 0 ] , //飛ぶ
        [ 0 , 0 ] , //パンチ
        [ 0 , 0 , 0 ] , //強いパンチ
        [ 0 , 0 ] , //ジャンプパンチ
        [ 0 , 0 ] , //ジャンプキック
        [ 0 , 0 ] , //キック
        [ 0 ] , //弱ダメージ
        [ 0 ] , //中ダメージ
        [ 0 ] , //強ダメージ
        [ 0 , 0 , 0 , 0 , 0 ] , //ダウン
        [ 0 , 0 ] //落下
    ] ;

    //アニメーションの条件 0=ウェイト 1=_velocity.yが+方向 2=地面に接地 3=終わらない
    private const $HERO_D:Array = [
        [ 0 , 0 , 0 , 0 ] , //歩く
        [ 0 , 0 , 0 , 0 , 0 , 0 ] , //走る
        [ 0 , 1 , 0 , 2 , 0 ] , //飛ぶ
        [ 0 , 0 ] , //パンチ
        [ 0 , 0 , 0 ] , //強いパンチ
        [ 2 , 0 ] , //ジャンプパンチ
        [ 2 , 0 ] , //ジャンプキック
        [ 0 , 0 ] , //キック
        [ 0 ] , //弱ダメージ
        [ 0 ] , //中ダメージ
        [ 0 ] , //強ダメージ
        [ 0 , 0 , 0 , 0 , 3 ] , //ダウン
        [ 2 , 0 ] //落下
    ] ;

    //アニメーション切り替わりの際の特殊動作ＩＤ 1=ジャンプ 2=[歩くor落下]状態に戻る 3=飛び道具発生
    private const $HERO_E:Array = [
        [ 0 , 0 , 0 , 0 ] , //歩く
        [ 0 , 0 , 0 , 0 , 0 , 0 ] , //走る
        [ 1 , 0 , 0 , 0 , 2 ] , //飛ぶ
        [ 0 , 2 ] , //パンチ
        [ 0 , 0 , 2 ] , //強いパンチ
        [ 0 , 2 ] , //ジャンプパンチ
        [ 0 , 2 ] , //ジャンプキック
        [ 0 , 2 ] , //キック
        [ 2 ] , //弱ダメージ
        [ 2 ] , //中ダメージ
        [ 2 ] , //強ダメージ
        [ 0 , 0 , 0 , 0 , 2 ] , //ダウン
        [ 0 , 2 ] //落下
    ] ;

    //攻撃判定
    private const $HERO_F:Array = [
        [ 0 , 0 , 0 , 0 ] , //歩く
        [ 0 , 0 , 0 , 0 , 0 , 0 ] , //走る
        [ 0 , 0 , 0 , 0 , 0 ] , //飛ぶ
        [ 0 , 1 ] , //パンチ
        [ 0 , 1 , 0 ] , //強いパンチ
        [ 1 , 0 ] , //ジャンプパンチ
        [ 1 , 0 ] , //ジャンプキック
        [ 0 , 1 ] , //キック
        [ 0 ] , //弱xダメージ
        [ 0 ] , //中ダメージ
        [ 0 ] , //強ダメージ
        [ 0 , 0 , 0 , 0 , 0 ] , //ダウン
        [ 0 , 0 ] //落下
    ] ;

    public function Hero ( B:Bitmap , C:ColorTransform = null ) :void {
        super ( B , C , $HERO_A , $HERO_B , $HERO_C , $HERO_D , $HERO_E , $HERO_F ) ;
    }
    
}


////////////////////////////////////
const FILENAME:String = "http://assets.wonderfl.net/images/related_images/a/a7/a79f/a79f6550f46ab03e548ec7fee72569ee99b89823" ;
const ZERO_POINT:Point = new Point ( 0 , 0 ) ;
const ZMAX:int = 0 ;
