/**
 * Copyright littlepad ( http://wonderfl.net/user/littlepad )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/srnu
 */

// forked from hacker_9vjnvtdz's GYAOS_sample
/**
 * Copyright hacker_9vjnvtdz ( http://wonderfl.net/user/hacker_9vjnvtdz )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/f6f2
 */

/*
attak
*/
package
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Loader;
    import flash.display.MovieClip;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.events.TimerEvent;
    import flash.geom.Matrix;
    import flash.geom.Rectangle;
    import flash.net.URLRequest;
    import flash.system.LoaderContext;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import flash.text.TextFormat;
    import flash.utils.Timer;
    import org.libspark.betweenas3.BetweenAS3;
    import org.libspark.betweenas3.easing.Cubic;
    import org.libspark.betweenas3.tweens.ITween;
    import org.si.sion.SiONData;

    [SWF( width="465", height="465", frameRate="30", backgroundColor="#000000" )]

    public class FlashTest extends MovieClip
    {
        private var _imgUrl : String; // モンスターのパス
        private var _loader : Loader; // モンスター表示用コンテナ
        private var _blinkTimer : Timer; // 攻撃エフェクト用のタイマー
        private var _monsterHp : int; // モンスターのHP
        private var _myHp:int = 100;    // 自分のHP
        private var _monsterHpView : HpView; // HP表示
        private var _myHpView:HpView;    // 自分のHP表示
        private var _monsterParts : Array; // モンスターパーツ画像
        private var _monsterLayer : Sprite; // モンスターパーツ表示用
        private var _monsterImgs : Array; // モンスター画像情報
        private var _monsterDefaultX : Number;
        private var _monsterDefaultY : Number;
        
        private var _controllPanelLayer:Sprite;    // 情報表示用

        private var _mb : MessageBoard; // メッセージボード
        private var _attackBtn : AttackButton; // アタックボタン
        private var _dpt : DamagePoint; // ダメージポイント

        private var _myAttackFlg:Boolean;    // 攻撃フラグ
        private var _sound : SionSound; // サウンド

        public function FlashTest()
        {
            // 背景
            var bg : Background = new Background();
            addChild( bg );
            
            // モンスター表示用
            _monsterLayer = new Sprite();
            addChild( _monsterLayer );
            _monsterLayer.x = 112;
            _monsterLayer.y = -5;
            _monsterDefaultX = _monsterLayer.x;
            _monsterDefaultY = _monsterLayer.y;
            
            // パネル類表示用
            _controllPanelLayer = new Sprite();
            addChild(_controllPanelLayer);

            // メッセージボード
            _mb = new MessageBoard();
            _controllPanelLayer.addChild( _mb );

            // アタックボタン
            _attackBtn = new AttackButton();
            _controllPanelLayer.addChild( _attackBtn );
            _attackBtn.addEventListener( MouseEvent.MOUSE_DOWN, atc );

            // HP表示
            _monsterHpView = new HpView("monster");
            _monsterHpView.x = 335;
            _monsterHpView.y = 55;
            addChild( _monsterHpView );
            
            _myHpView = new HpView("me");
            _myHpView.x = 20;
            _myHpView.y = 55;
            addChild(_myHpView);
            
            // モンスターのパス
            _monsterImgs = [ "http://assets.wonderfl.net/images/related_images/6/6d/6d2a/6d2aac9165308e05d07f52232f99bfe9d52a06fb", 
                            "http://assets.wonderfl.net/images/related_images/9/9a/9a67/9a674310835d956620db269594b14241d8c079ba", 
                            "http://assets.wonderfl.net/images/related_images/5/57/5728/5728bb5057da70c62a2bff824fac59cf139bcb44" ];
            
            // タイマーを初期化する
            _blinkTimer = new Timer( 60, 4 );
            _blinkTimer.addEventListener( "timer", timerHandler );

            // サウンド
            _sound = new SionSound();

            init();
        }

        private function init() : void
        {
            _myAttackFlg = true;
            _monsterHp = 100;
            _monsterHpView.setFullCharge();

            // モンスターをランダムに選択
            _imgUrl = _monsterImgs[ uint( Math.random() * _monsterImgs.length )];

            // モンスターをロードする
            _loader = new Loader();
            var context : LoaderContext = new LoaderContext( true );
            _loader.contentLoaderInfo.addEventListener( Event.COMPLETE, picsOnComplete );
            _loader.load( new URLRequest( _imgUrl ), context );
        }

        // モンスターのロード完了時の処理
        private function picsOnComplete( eventObj : Event ) : void
        {
            _loader.contentLoaderInfo.removeEventListener( Event.COMPLETE, picsOnComplete );

            _monsterParts = new Array();

            var loaderW : uint = _loader.width;
            var loaderH : uint = _loader.height;

            var partsW : Number = 10; // パーツの横サイズ
            var partsH : Number = 10; // パーツの縦サイズ

            //　モンスターをパーツに分ける
            for ( var i : uint = 0; i < loaderH / partsH; i++ )
            {
                for ( var j : uint = 0; j < loaderW / partsW; j++ )
                {
                    var bmd : BitmapData = new BitmapData( partsW, partsH, true, 0x00000000 );
                    bmd.draw( _loader, new Matrix( 1, 0, 0, 1, -partsW * j, -partsH * i ), null, null, new Rectangle( 0, 0, partsW, partsH ), false );
                    _monsterParts.push({ bmp: new Bitmap( bmd ), x: partsW * j, y: partsH * i });
                }
            }
            
            // モンスター出現
            var partsLength : uint = _monsterParts.length;
            for ( var k : uint = 0; k < partsLength; k++ )
            {
                _monsterParts[ k ].bmp.x = _monsterParts[ k ].x;
                _monsterParts[ k ].bmp.y = _monsterParts[ k ].y;
                _monsterParts[ k ].bmp.alpha = 0;
                BetweenAS3.serial( 
                    BetweenAS3.addChild( _monsterParts[ k ].bmp, _monsterLayer ), 
                    BetweenAS3.delay( BetweenAS3.tween( _monsterParts[ k ].bmp, { alpha: 1 }, null, 0.2 ), 0.001 * k )
                ).play();
            }
            
            // 個別パーツを配置するんだけど、モンスター攻撃の拡大時にパーツの境目が気になるので
            // 結局 _loader を配置する。あんまスマートじゃないけど。
            // 配置したパーツは爆発の時にまた使うので、とりあえず透明度を0にしておく。
            var t:ITween = BetweenAS3.delay(BetweenAS3.addChild(_loader, _monsterLayer), 2);
            t.onComplete = function():void {
                for( var l:uint = 0; l < partsLength; l++){
                    _monsterParts[ l ].bmp.alpha = 0;
                }
            }
            t.play();
            
            // メッセージボードに出力
            _mb.setText( "モンスターが現れた！" );

            // サウンド
            _sound.fightSound();

            // ダメージポイント
            _dpt = new DamagePoint();
            addChild( _dpt );
        }

        // 攻撃処理
        private function atc( e : MouseEvent ) : void
        {
            if(_myAttackFlg){
                _myAttackFlg = false;
                
                // ダメージを計算する
                var r : int = int( Math.random() * 10 ) + 10;
                _monsterHp -= r;
                
                // 攻撃エフェクト
                if( _myHp < 20 ){    // HP回復
                    var timer:Timer = new Timer(2, 1);
                    timer.addEventListener(TimerEvent.TIMER, function():void{
                        timer.removeEventListener(TimerEvent.TIMER, arguments.callee);
                        _myHpView.setFullCharge();
                        _myHp = 100;
                        
                        // サウンド
                        _sound.chargeSound();
                        
                        // メッセージボードに出力
                        _mb.setText( "薬草を使った。\nHPが100ポイントに回復した。" );
                        
                        // モンスターの攻撃
                        monsterAttack();
                    });
                    timer.start();
                } else if ( _monsterHp < 1 ) // モンスター死亡時
                {
                    _monsterHp = 0;
                    _monsterHpView.setParcent( _monsterHp );
                    
                    // メッセージボードに出力
                    _mb.setText( "モンスターを倒した！" );
                    
                    // モンスター爆発
                    _monsterLayer.removeChild(_loader);
                    var partsLength : uint = _monsterParts.length;
                    for ( var i : uint = 0; i < partsLength; i++ )
                    {
                        _monsterParts[i].bmp.alpha = 1;
                        var t : ITween = BetweenAS3.tween( _monsterParts[ i ].bmp, { x: Math.random() * 465 - _monsterLayer.x, y: Math.random() * 465 - _monsterLayer.y, scaleX:Math.random() * 2, scaleY:Math.random() * 2, alpha: 0, rotation: Math.random() * 360 }, null, 2, Cubic.easeOut );
                        t.onComplete = _monsterLayer.removeChild;
                        t.onCompleteParams = [ _monsterParts[ i ].bmp ];
                        t.play();
                    }
                    
                    // YOU WIN 表示
                    var winText : WinText = new WinText();
                    addChild( winText );
                    winText.setWinText();
                    
                    // REPLAY ボタン
                    var replayBtn : ReplayButton = new ReplayButton();
                    replayBtn.addEventListener( MouseEvent.MOUSE_DOWN, function() : void
                    {
                        replayBtn.removeEventListener( MouseEvent.MOUSE_DOWN, arguments.callee );
                        removeChild( winText );
                        removeChild( replayBtn );
                        init();
                    });
                    addChild( replayBtn );
                    replayBtn.setReplayBtn();
                    
                    // サウンド
                    _sound.clearSound();
                }
                else if ( _monsterHp > 0 ) // 攻撃成功時
                {
                    // 攻撃エフェクトを開始する
                    _blinkTimer.reset();
                    _blinkTimer.start();
                    
                    BetweenAS3.serial( BetweenAS3.to( _monsterLayer, { x: _monsterDefaultX - 2, y: _monsterDefaultY + 2 }, 0 ), BetweenAS3.delay( BetweenAS3.to( _monsterLayer, { x: _monsterDefaultX + 3, y: _monsterDefaultY - 3 }, 0 ), 0.1 ), BetweenAS3.delay( BetweenAS3.to( _monsterLayer, { x: _monsterDefaultX - 3, y: _monsterDefaultY + 3 }, 0 ), 0.1 ), BetweenAS3.delay( BetweenAS3.to( _monsterLayer, { x: _monsterDefaultX + 3, y: _monsterDefaultY - 3 }, 0 ), 0.1 ), BetweenAS3.delay( BetweenAS3.to( _monsterLayer, { x: _monsterDefaultX, y: _monsterDefaultY }, 0 ), 0.1 )).play();
                    
                    // ダメージポイント
                    _dpt.setPoint( r );
                    _monsterHpView.setParcent( _monsterHp );
                    
                    // サウンド
                    _sound.attackSound();
                    
                    // メッセージボードに出力
                    _mb.setText( "モンスターに" + r + "ポイントのダメージを与えた！" );
                    
                    // モンスターの攻撃
                    monsterAttack();
                }
            }
        }
        
        // モンスターの攻撃
        private function monsterAttack() : void{
            var timer:Timer = new Timer(2000, 1);
            timer.addEventListener(TimerEvent.TIMER, function():void{
                timer.removeEventListener(TimerEvent.TIMER, arguments.callee);
                
                // サウンド
                _sound.damagedSound();
                
                BetweenAS3.serial( 
                    BetweenAS3.to( _monsterLayer, { scaleX:1.8, scaleY:1.8, x: (stage.stageWidth-_monsterLayer.width*1.8)/2, y:_monsterDefaultY-90 }, 0.08 ),
                    BetweenAS3.to( _monsterLayer, { scaleX:1, scaleY:1, x:_monsterDefaultX, y:_monsterDefaultY }, 0.08 ), 
                    BetweenAS3.to( _controllPanelLayer, { x: -2, y: 2 }, 0 ), 
                    BetweenAS3.delay( BetweenAS3.to( _controllPanelLayer, { x: 2, y: -2 }, 0 ), 0.03 ), 
                    BetweenAS3.delay( BetweenAS3.to( _controllPanelLayer, { x: -2, y: 2 }, 0 ), 0.03 ), 
                    BetweenAS3.delay( BetweenAS3.to( _controllPanelLayer, { x: 2, y: -2 }, 0 ), 0.03 ), 
                    BetweenAS3.delay( BetweenAS3.to( _controllPanelLayer, { x: 0, y: 0 }, 0 ), 0.03 )
                ).play();
                
                // ダメージを計算する
                var r:int = int( Math.random() * 10 ) + 10;
                _myHp -= r;
                _myHpView.setParcent(_myHp);
                
                // メッセージボードに出力
                _mb.setText( "モンスターの攻撃。\n" + r + "ポイントのダメージを受けた！" );
                
                _mb.addEventListener(MessageBoard.TEXT_COMPLETE, function():void {
                    _mb.removeEventListener(MessageBoard.TEXT_COMPLETE, arguments.callee);
                    _myAttackFlg = true;
                });
            });
            timer.start();
        }
        
        // タイマー処理
        private function timerHandler( event : TimerEvent ) : void
        {
            if ( _blinkTimer.currentCount % 2 == 1 )
            {
                _monsterLayer.visible = false;
            }
            else
            {
                _monsterLayer.visible = true;
            }
        }
    }
}

import flash.display.GradientType;
import flash.display.Sprite;
import flash.events.Event;
import flash.events.MouseEvent;
import flash.events.TimerEvent;
import flash.filters.DropShadowFilter;
import flash.filters.GradientBevelFilter;
import flash.geom.Matrix;
import flash.text.TextField;
import flash.text.TextFormat;
import flash.text.TextFormatAlign;
import flash.utils.Timer;

import org.libspark.betweenas3.BetweenAS3;
import org.libspark.betweenas3.core.easing.*;
import org.libspark.betweenas3.easing.*;
import org.si.sion.SiONData;
import org.si.sion.SiONDriver;

class Background extends Sprite
{
    public function Background()
    {
        init();
    }

    private function init() : void
    {
        var matrix : Matrix = new Matrix();
        matrix.createGradientBox( 465, 385, 90 * Math.PI / 180, 0, 0 );
        this.graphics.beginGradientFill( GradientType.LINEAR, [ 0x008080, 0x192223 ], [ 1, 1 ], [ 0, 255 ], matrix );
        this.graphics.drawRect( 0, 40, 465, 385 );
        this.graphics.endFill();
    }
}

// メッセージボード
class MessageBoard extends Sprite
{
    public static const TEXT_COMPLETE:String = "text_complete";
    private var _tf : TextField;

    public function MessageBoard()
    {
        init();
    }

    private function init() : void
    {
        x = 60;
        y = 265;

        this.graphics.beginFill( 0x000000 );
        this.graphics.drawRect( 1, 0, 343, 90 );
        this.graphics.beginFill( 0x000000 );
        this.graphics.drawRect( 0, 1, 345, 88 );
        this.graphics.beginFill( 0xFFFFFF );
        this.graphics.drawRect( 2, 1, 341, 88 );
        this.graphics.beginFill( 0xFFFFFF );
        this.graphics.drawRect( 1, 2, 343, 86 );
        this.graphics.beginFill( 0x000000 );
        this.graphics.drawRect( 5, 4, 335, 82 );
        this.graphics.beginFill( 0x000000 );
        this.graphics.drawRect( 4, 5, 337, 80 );
        this.graphics.endFill();

        _tf = new TextField();
        var tfm : TextFormat = new TextFormat( "_ゴシック", 13, 0xFFFFFF, true, false, false, null, null, null, null, null, null, 5 );
        _tf.defaultTextFormat = tfm;
        _tf.width = 321;
        _tf.height = 66;
        _tf.x = _tf.y = 12;
        addChild( _tf );

        this.filters = [ new DropShadowFilter( 0, 45, 0, 0.3, 6, 6 )];
    }

    public function setText( text : String ) : void
    {
        var count : int = 0;
        _tf.text = "";
        var timer : Timer = new Timer( 15, text.length );
        timer.addEventListener( TimerEvent.TIMER, function() : void
        {
            _tf.appendText( text.substr( count, 1 ));
            count++;
        });
        timer.addEventListener( TimerEvent.TIMER_COMPLETE, function():void {
            dispatchEvent( new Event(MessageBoard.TEXT_COMPLETE) );
        });
        timer.start();
    }
}

// HP表示
class HpView extends Sprite
{
    private var _bar : Sprite;
    private var _defaultBarW : int;
    private var _tf : TextField;
    private var _who:String;
    
    public function HpView(who:String)
    {
        if(who == "monster"){
            _who = "モンスター";
        } else {
            _who = "あなた";
        }
        init();
    }
    
    private function init() : void
    {
        this.graphics.beginFill( 0x333333, 0.5 );
        this.graphics.drawRect( 0, 0, 110, 4 );
        this.graphics.endFill();
        
        _bar = new Sprite();
        if( _who == "モンスター" ){
            _bar.graphics.beginFill( 0xFF0000 );
        } else {
            _bar.graphics.beginFill( 0x00FFFF );
        }
        _bar.graphics.drawRect( 0, 0, 110, 4 );
        _bar.graphics.endFill();
        _defaultBarW = _bar.width;
        if(_who == "モンスター")_bar.width = 0;
        addChild( _bar );
        
        _tf = new TextField();
        var tfm : TextFormat = new TextFormat( "_ゴシック", 11, 0xFFFFFF, false );
        _tf.defaultTextFormat = tfm;
        _tf.selectable = false;
        _tf.text = _who + "のHP：100";
        _tf.width = _tf.textWidth + 4;
        _tf.y = 5;
        addChild( _tf );
        
        this.filters = [ new DropShadowFilter( 0, 45, 0, 0.3, 4, 4 )];
    }
    
    public function setFullCharge() : void
    {
        BetweenAS3.tween( _bar, { width: _defaultBarW }, 0.1 ).play();
        _tf.text = _who + "のHP：100";
    }
    
    public function setParcent( hp : int ) : void
    {
        _bar.width = int( _defaultBarW * ( hp / 100 ));
        _tf.text = _who + "のHP：" + hp;
    }    
}

// ダメージポイント
class DamagePoint extends Sprite
{
    private var _tf : TextField;
    private var _defaltY : uint;

    public function DamagePoint()
    {
        init();
    }

    private function init() : void
    {
        x = 260;
        y = 40;
        _defaltY = y;

        _tf = new TextField();
        var tfm : TextFormat = new TextFormat( "Arial", 18, 0xFF0000, true );
        _tf.defaultTextFormat = tfm;
        _tf.selectable = false;
        _tf.filters = [ new DropShadowFilter( 0, 45, 0xFFFFFF, 1, 2, 2, 255 )];
        addChild( _tf );
    }

    public function setPoint( point : uint ) : void
    {
        alpha = 0;
        y = _defaltY;
        _tf.text = String( point ) + "pt";
        BetweenAS3.serial( 
            BetweenAS3.tween( this, { y: 100, alpha: 1 }, null, 0.4, Bounce.easeOut ), 
            BetweenAS3.delay( BetweenAS3.tween( this, { alpha: 0 }, null, 0 ), 0.5 )
        ).play();
    }
}

// 攻撃ボタン
class AttackButton extends Sprite
{
    private var _defaultY : Number;

    public function AttackButton()
    {
        init();
    }

    private function init() : void
    {
        buttonMode = true;
        this.mouseChildren = false;

        x = 143;
        y = 370;
        _defaultY = y;

        var matrix : Matrix = new Matrix();
        matrix.createGradientBox( 180, 35, 90 * Math.PI / 180, 0, 0 );
        this.graphics.lineStyle( 1, 0xFF0000 );
        this.graphics.beginGradientFill( GradientType.LINEAR, [ 0xFF6464, 0xFF0000 ], [ 1, 1 ], [ 0, 255 ], matrix );
        this.graphics.drawRoundRect( 0, 0, 180, 35, 5, 5 );
        this.graphics.endFill();

        var tf : TextField = new TextField();
        var tfm : TextFormat = new TextFormat( "_ゴシック", 16, 0xFFFFFF, true, false, false, null, null, "center" );
        tf.defaultTextFormat = tfm;
        tf.selectable = false;
        tf.text = "攻撃する";
        tf.y = 8;
        tf.width = 180;
        addChild( tf );

        this.filters = [ new DropShadowFilter( 0, 45, 0, 0.3, 6, 6 )];

        this.addEventListener( MouseEvent.MOUSE_DOWN, function() : void
        {
            y = _defaultY + 2;
        });
        this.addEventListener( MouseEvent.MOUSE_UP, function() : void
        {
            y = _defaultY;
        });
    }
}

// REPLAY ボタン
class ReplayButton extends Sprite
{
    private var _defaultY : Number;

    public function ReplayButton()
    {
        init();
    }

    private function init() : void
    {
        buttonMode = true;
        this.mouseChildren = false;

        alpha = 0;
        x = 198;
        y = 210;
        _defaultY = y;

        this.graphics.lineStyle( 1, 0xFFFFFF, 0.3 );
        this.graphics.beginFill( 0x000000, 0.3 );
        this.graphics.drawRoundRect( 0, 0, 70, 25, 10, 10 );
        this.graphics.endFill();

        var tf : TextField = new TextField();
        var tfm : TextFormat = new TextFormat( "Arial", 9, 0xFFFFFF, false, false, false, null, null, "center" );
        tf.defaultTextFormat = tfm;
        tf.selectable = false;
        tf.text = "REPLAY";
        tf.y = 5;
        tf.width = 70;
        addChild( tf );

        this.addEventListener( MouseEvent.MOUSE_DOWN, function() : void
        {
            y = _defaultY + 1;
        });
        this.addEventListener( MouseEvent.MOUSE_UP, function() : void
        {
            y = _defaultY;
        });
    }

    /**
     *
     */
    public function setReplayBtn() : void
    {
        BetweenAS3.delay( BetweenAS3.tween( this, { alpha: 1 }, { alpha: 0 }, 0.2 ), 2 ).play();
    }
}

// WinText
class WinText extends Sprite
{
    public function WinText()
    {
        init();
    }

    private function init() : void
    {
        var tf : TextField = new TextField();
        var tfm : TextFormat = new TextFormat( "Impact", 70, 0xFFF100, false );
        tf.defaultTextFormat = tfm;
        tf.text = "YOU WIN!";
        tf.filters = [ new DropShadowFilter( 0, 45, 0x000000, 0.4, 5, 5, 10 ), new GradientBevelFilter( 2, 45, [ 0x9b9418, 0xFFFFFF, 0x9b9418 ], [ 0.5, 0.9, 0.5 ], [ 0, 127, 255 ], 1, 1, 3 )];
        tf.selectable = false;
        tf.width = tf.textWidth;
        tf.x = -tf.width / 2;
        tf.y = -tf.height / 2;
        addChild( tf );

        x = 232;
        y = 170;
    }

    /**
     *
     */
    public function setWinText() : void
    {
        BetweenAS3.tween( this, { scaleX: 1, scaleY: 1 }, { scaleX: 2, scaleY: 2 }, 1, Bounce.easeOut ).play();
    }
}

// Sound
class SionSound
{
    private var _driver : SiONDriver;
    private var _attack : SiONData; // 攻撃音
    private var _damaged:SiONData;    // ダメージ音
    private var _clear : SiONData; // クリア音
    private var _fight : SiONData; // 戦闘中
    private var _charge:SiONData;    // HP回復

    public function SionSound()
    {
        init();
    }

    private function init() : void
    {
        _driver = new SiONDriver();
        _attack = _driver.compile( "v16%0@1l32>>>>cd" );
        _damaged = _driver.compile( "v16%0@1l32>>>cd" );
        _clear = _driver.compile( "v32%0@1l32>>>cc+d+cc+d+cc+d+cc+d+c16v32l64<<<<<cc+dd+eff+gg+aa+b8" );
        _fight = _driver.compile( "v16l16>>ba+ag+gf+fed+dc+cr4v10$[c+dd+e]3c+ed+d" );
        _charge = _driver.compile("v16l32<cc+dd+a8");
    }

    // 攻撃音
    public function attackSound() : void
    {
        _driver.sequenceOn( _attack );
    }

    // ダメージ音
    public function damagedSound() : void
    {
        _driver.sequenceOn( _damaged );
    }
    
    // クリア音
    public function clearSound() : void
    {
        _driver.play( _clear );
    }

    // 戦闘中
    public function fightSound() : void
    {
        _driver.play( _fight );
    }
    
    // HP回復音
    public function chargeSound() : void
    {
        _driver.sequenceOn( _charge );
    }
}
