/**
 * Copyright umi_kappa ( http://wonderfl.net/user/umi_kappa )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/srBB
 */

// forked from kotobuki's Gainer Basic Example: LED
// 準備
// ・aout 0にLEDと抵抗器（330Ωなど）を接続する
// 
// 画面上のボタンを押すとI/Oモジュール上のLEDが点灯し、
// 同時にaout 0に接続したLEDがフェードインします。
// ボタンを離すとI/Oモジュール上のLEDが消灯し、同時に
// aout 0に接続したLEDもフェードアウトします。
// 
// 基本的なセットアップについては以下のURLを参照してください
// http://funnel.cc/Main/GettingStarted


//FORKもとはなんかフェードアウトしなかった？？
//externalLED.off()　を　;externalLED.fadeOut(500);に直したらできた！


//GainerはAS2の説明はあるけどAS3はないですよね。
//なんで、自分は1行ずつ自分なりの解釈で勉強します。
//ちなみにAS3も初心者です(笑)
//こういうことだよ！って突っ込みあったらご指導お願いします。

package {
    import flash.display.Sprite;
    import flash.events.MouseEvent;
    
    import funnel.*;
    import funnel.gui.*;
    import funnel.ui.*;

    public class GainerBasic_LED extends Sprite {
        private var externalLED:LED;
        //LEDを使うためのもの

        private var gio:Gainer;

        private var squareButton:Sprite;

        public function GainerBasic_LED() {
            gio = new Gainer();

            squareButton = new Sprite();
            squareButton.graphics.beginFill(0x808080);
            squareButton.graphics.drawRect(-25, -25, 50, 50);
            squareButton.graphics.endFill();
            squareButton.x = stage.stageWidth / 2;
            squareButton.y = stage.stageHeight / 2;
            squareButton.buttonMode = true;
            this.addChild(squareButton);
            //四角(ボタン)を表示

            var gui:GainerGUI = new GainerGUI();
            addChild(gui);
            gio.gui = gui;
            //右下のスライダーを表示

            externalLED = new LED(gio.analogOutput(0));

            squareButton.addEventListener(MouseEvent.MOUSE_DOWN, mousePressed);
            squareButton.addEventListener(MouseEvent.MOUSE_UP, mouseReleased);
        }

        private function mousePressed(e:MouseEvent):void {
            gio.led.on();
            //モジュールのLEDをon
            
            externalLED.fadeIn(500);
            //0.5sでフェードイン
            
            squareButton.scaleX = 1.2;
            squareButton.scaleY = 1.2;
        }

        private function mouseReleased(e:MouseEvent):void {
            gio.led.off();
            //モジュールのLEDをoff
            
            externalLED.fadeOut(500);
            //0.5sでフェードアウト　こっちがFORK元と違うとこ
            
            squareButton.scaleX = 1.0;
            squareButton.scaleY = 1.0;
        }
    }
}
