/**
 * Copyright umhr ( http://wonderfl.net/user/umhr )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/sqnI
 */

// forked from yasyasyas's flash on 2011-5-23
/*
花の中心の円をSpriteインスタンスのflowerとして、そこに花びらを角度をつけてくっつけていきました。花びらを表すShapeインスタンスをpetalとして楕円で作成しましたが、そのままだと基準点が左上隅なので、回転や移動がうまくできません。そこでSpriteインスタンスのbaseを作成し、そこにpetalをズラして置き、baseの方を移動・回転させました。

花を20個ランダムにstage上に置きました。

*/


package {
    import flash.display.*;
    import flash.geom.Point;
    
    public class DrawingFlowers extends Sprite {
        
        var num:int = 14;　//花びらの数
        var deg:Number = 360 / num; //花びらの枚数にしたがって、花びら自体を回転させる角度
        var len:int = 20;　//花の中心の円の半径
        var petalWidth:int = 60; //花びらの幅
        var petalHeight:int = 16; //花びらの高さ
        
        public function DrawingFlowers() {
                      
            for (var i:int = 0; i < 20; i++) {
                var flower:Sprite = new Sprite();
                addChild(flower);
                flower.graphics.lineStyle(5,0xFF9900);
                flower.graphics.beginFill(0xFFFF00);
                flower.graphics.drawCircle(0, 0, len);
                flower.graphics.endFill();
                var fx:Number = Math.random() * stage.stageWidth;
                var fy:Number = Math.random() * stage.stageHeight;
                flower.x = fx;
                flower.y = fy;
                
                var color:Number = Math.random() * 0xFFFFFF;
                          
                for (var j:int = 0; j < num; j++) {
                    var rad:Number = 2 * Math.PI / num;
                    var pt:Point = Point.polar(len, rad * j); //花びらをつける位置の作成
                    
                    var petal:Shape = new Shape();
                    flower.addChild(petal);
                    petal.graphics.lineStyle(1);
                    petal.graphics.beginFill(color);
                    petal.graphics.drawEllipse(0, -petalHeight/2, petalWidth, petalHeight);
                    petal.graphics.endFill();
                    petal.x = pt.x;
                    petal.y = pt.y;
                    petal.rotation = deg * j;
                }
            }
        }
    }
}