/**
 * Copyright lizhi ( http://wonderfl.net/user/lizhi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/spmE
 */

package  
{
	import flash.display.*
	import flash.events.Event;
	import flash.filters.DisplacementMapFilter;
	import flash.geom.*
	import sliz.miniui.Button;
	import sliz.miniui.layouts.BoxLayout;
	import sliz.miniui.Silder;
	import sliz.miniui.Window;
	/**
	 * ...
	 * @author sliz
	 */
	[SWF(backgroundColor=0)]
	public class FireEffect extends Sprite
	{
		private var bmd:BitmapData;
		private var target:Sprite;
		private var speed:Number;
		private var strengh:Number;
		private var size:Number;
		private var randomseed:Number = 0;
		private var offset:Point = new Point();
		private var v:Point;
		private var w:Number = 50;
		public function FireEffect() 
		{
			target = createSharp(stage.stageWidth, 30, 0);
			addChild(target);
			target.x = 0;
			target.y = 200;
			var w:Window = new Window(this, 140, 10);
			var s:Silder = new Silder(0,0,null,"num",sf);
			w.add(s);
			var st:Silder = new Silder(0, 0, null, "num", stf);
			w.add(st);
			st.value = 1;
			var sizes:Silder = new Silder(0, 0, null, "num", sizesf);
			w.add(sizes);
			w.add(new Button("random", 0, 0, null, randomh),null,0.8);
			var layout:BoxLayout = new BoxLayout(w, BoxLayout.Y_AXIS, 10);
			w.setLayout(layout);
			w.doLayout();
			addTo(target);
		}
		
		private function randomh(e:Event):void 
		{
			randomseed = Math.floor(Math.random() * 10000);
		}
		
		private function sizesf(v:Number):String 
		{
			v = v * 17 + 20;
			size = v;
			return v + "(size)";
		}
		
		private function stf(v:Number):String 
		{
			v = v * 60 + 60;
			strengh = v;
			return v + "(strengh)";
		}
		
		private function sf(v:Number):String 
		{
			v = v * 4 + 4;
			speed = v;
			this.v = new Point((speed / 4) - speed / 8,(speed / 4) + speed / 4 * 3);
			return v + "(speed)";
		}		
		private function createSharp(width:Number,height:Number,angle:Number):Sprite {
			var s:Sprite = new Sprite();
			s.graphics.beginFill(0, 0);
			s.graphics.drawRect( -w, -w, width + 2 * w,  w);
			s.graphics.beginFill(0xffffff);
			s.graphics.drawRect( -w, height, width + 2 * w,  w);
			var fillType:String = GradientType.LINEAR;
			var colors:Array = [0x900000, 0x900000,0xff9900,0xfffd8a,0xffffff];
			var alphas:Array = [0,1,1,1, 1];
			var ratios:Array = [0x00,0xff/16,0xff*2/6,0xff*2/3, 0xFF];
			var matr:Matrix = new Matrix();
			matr.createGradientBox(width, height, Math.PI / 2);
			var spreadMethod:String = SpreadMethod.PAD;
			s.graphics.beginGradientFill(fillType, colors, alphas, ratios, matr, spreadMethod); 
			s.graphics.drawRect(0, 0, width, height);
			return s;
		}
		public function addTo(target:Object):void {
			bmd = new BitmapData(target.width, target.height);
			v = new Point(Math.random() * (speed / 4) - speed / 8,Math.random() * (speed / 4) + speed / 4 * 3);
			target.addEventListener(Event.ENTER_FRAME, update);
		}
		private function update(e:Event):void {
			target.filters = [new DisplacementMapFilter(bmd, new Point(), BitmapDataChannel.RED,BitmapDataChannel.RED, 10, strengh, "clamp")];
			offset=offset.add(v);
			bmd.perlinNoise(size / 2, size, 3, randomseed, false, true, 1, true, [offset, offset]);
		}
	}
	
}