/**
 * Copyright umhr ( http://wonderfl.net/user/umhr )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/spKZ
 */

/*
 * 2010年1月に作ったんだけど、
 * wonderflの仕様変更に伴って動かなくなっていたので、調整。
 * いろいろなユーザーの状況が見れる機能があったけど、
 * いろいろ不明な挙動があるので、適当に妥協。
 * 
 * */
package
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.filters.BlurFilter;
    import flash.geom.ColorTransform;
    import flash.geom.Matrix;
    import flash.geom.Matrix3D;
    import flash.geom.Vector3D;
    import flash.text.TextField;
    import flash.text.TextFormat;
    import flash.net.navigateToURL;
    import flash.net.URLRequest;
    
    import org.libspark.betweenas3.BetweenAS3;
    import org.libspark.betweenas3.tweens.ITween;
    
    [SWF(backgroundColor="0x271010",width=465,height=465)]
    public class Main extends Sprite
    {
        private var tf:TextField;
        private var _api:API;
        private var _canvas:Sprite;
        private var _user:Vector.<Number>;
        private var _posted:Vector.<Number>;
        private var _friends:Vector.<Number>;
        private var _following:Vector.<Number>;
        private var _followers:Vector.<Number>;
        private var _tempPosted:Vector.<Number> = new Vector.<Number>();
        private var _tempFriends:Vector.<Number> = new Vector.<Number>();
        private var _tempFollowing:Vector.<Number> = new Vector.<Number>();
        private var _postedMatrix3D:Matrix3D;
        private var _friendsMatrix3D:Matrix3D;
        private var _followingMatrix3D:Matrix3D;
        private var _globalMatrix3D:Matrix3D;
        public function Main()
        {
            stage.scaleMode = "noScale";
            this.addEventListener(MouseEvent.MOUSE_DOWN, atMouseDown);
            
            _canvas = new Sprite();
            _canvas.x = 465 / 2;
            _canvas.y = 465 / 2;
            this.addChild(_canvas);
            
            //userListは↓から一部改変（followが極端に少ない人を削除）
            //http://wonderfl.net/code/b62d136618e3a9c80163313634c9f6957f3773b9
            var userList:Array = [ // fav>=50 @ 2009/11/16
"clockmaker","keim_at_Si","Saqoosha","tail_y","alumican_net","miyaoka","nutsu","sake","yd_niku","k3lab",
"Aquioux","makc3d","soundkitchen","k0rin","bkzen","psyark","keno42","nemu90kWw","uwi","shapevent",
"5ivestar","nitoyon","mrdoob","umhr","Nao_u","fumix","mtok","miniapp","HaraMakoto","coppieee",
"paq", "178ep3", "fladdict", "Hiiragi","yooKo","mash","9re","onedayitwillmake","beinteractive","a24",
"minon","demouth","ton","ABA","twistcube","yanbaka","rect","Murai","ll_koba_ll",
"naoto5959","knd","Kay","peko","northprint","hikipuro","enok","matsu4512","wanson",
"zahir","set0","cellfusion","abakane","seyself", "tkinjo","szktkhr","osamX","muta244","milkmidi",
"heriet","dubfrog","flashrod","nulldesign","TX_298","yonatan","katapad","enoeno",
"Nicolas","dizgid","k__","gyuque","yshu","TheCoolMuseum","poiasd",
"y_tti","coppieeee","munegon","matsumos","KinkumaDesign","ish_xxxx","cjcat2266","kappaLab","runouw","iong"];
            var user:String = userList[Math.floor(userList.length * Math.random())];
            user = "umhr";
            _api = new API(user);
            _api.atComp = atComp;
            _api.play();
            nowLoadings(user)
        }
        private function nowLoadings(name:String,targetSp:Sprite = null):void {
            var shield:Sprite = new Sprite();
            shield.graphics.beginFill(0x110000, 0.7);
            shield.graphics.drawRect( -stage.stageWidth / 2, -stage.stageHeight / 2, stage.stageWidth, stage.stageHeight);
            shield.graphics.endFill();
            _canvas.addChild(shield);
            
            var textY:int = 0;
            var nowloadingsText:TextField = new TextField();
            nowloadingsText.defaultTextFormat = new TextFormat("_sans", 12, 0xCC9999);
            nowloadingsText.text = "Now loadings...";
            nowloadingsText.autoSize = "left";
            var txtBitmapData:BitmapData = new BitmapData(nowloadingsText.width, nowloadingsText.height, true, 0x000000);
            txtBitmapData.draw(nowloadingsText);
            var txtBitmap:Bitmap = new Bitmap(txtBitmapData);
            txtBitmap.x = -txtBitmap.width / 2;
            _canvas.addChild(txtBitmap);
            var t0:ITween;
            t0 = BetweenAS3.tween(txtBitmap, { alpha:0.5 }, { alpha:1 }, 0.1);
            t0.stopOnComplete = false;
            t0.play();
            
            if(targetSp){
                var tz:Number = targetSp.z;
                targetSp.z = 0;
                var bitmapData:BitmapData = new BitmapData(targetSp.width+2,targetSp.height+2,true,0x000000);
                bitmapData.draw(targetSp);
                targetSp.z = tz;
                var bitmap:Bitmap = new Bitmap(bitmapData);
                bitmap.scaleX = bitmap.scaleY = 2;
                bitmap.x = -bitmap.width / 2;
                bitmap.y = -bitmap.height / 2;
                _canvas.addChild(bitmap);
                textY = bitmap.height / 2;
                txtBitmap.y = bitmap.y - txtBitmap.height;
                var t:ITween;
                t = BetweenAS3.tween(bitmap, { alpha:0.5 }, { alpha:1 }, 0.1);
                t.stopOnComplete = false;
                t.play();
            }else {
                txtBitmap.y = -txtBitmap.height;
            }
            var tf:TextField = new TextField();
            tf.defaultTextFormat = new TextFormat("_sans", 10, 0xFFFFFF);
            tf.text = name;
            tf.autoSize = "left";
            tf.x = -tf.width / 2;
            tf.y = textY;
            tf.selectable = false;
            _canvas.addChild(tf);
        }
        private function atMouseDown(event:MouseEvent):void {
            if(stage.displayState == "normal"){
                stage.displayState = "fullScreen";
            }else{
                stage.displayState = "normal";
            }
              return;
            //trace("atMouseDown",event.target.name)
            if (event.target.name.substr(0,8) == "instance") {
                return;
            }else if(event.target.name.substr(0,20) == "http://wonderfl.net/") {
                navigateToURL(new URLRequest(event.target.name), "_blank");
                return;
            }
            
            nowLoadings(event.target.name,event.target as Sprite);
            
            this.removeEventListener(Event.ENTER_FRAME, atEnterFrame);
            _api = new API(event.target.name);
            _api.atComp = atComp;
            _api.play();
        }
        private function atComp():void {
            while (_canvas.numChildren > 0) {
                _canvas.removeChildAt(0);
            }
            
            _postedMatrix3D = new Matrix3D();
            _friendsMatrix3D = new Matrix3D();
            _followingMatrix3D = new Matrix3D();
            _globalMatrix3D = new Matrix3D();
            _globalMatrix3D.prependTranslation(0, 0, 100);
            
            _user = new Vector.<Number>();
            _user = Vector.<Number>([0, 0, 0]);
            _canvas.addChild(_api.user.image);
            
            var n:int;
            n = _api.posted.length;
            _posted = new Vector.<Number>();
            for (var i:int = 0; i < n; i++) {
                var num:Number = n / 2 - Math.abs(i - n / 2);
                num /= (n / 2);
                _posted = _posted.concat(Vector.<Number>([num*100 * Math.sin(Math.PI * 4 * i / n), (i - n / 2) * 50, num*100 * Math.cos(Math.PI * 4 * i / n)]));
                _canvas.addChild(_api.posted[i].image);
            }
            
            n = _api.friends.length;
            _friends = new Vector.<Number>();
            for (i = 0; i < n; i++) {
                _friends = _friends.concat(Vector.<Number>([150 * Math.sin(Math.PI * 2 * i / n), 0, 150 * Math.cos(Math.PI * 2 * i / n)]));
                _canvas.addChild(_api.friends[i].image);
            }
            
            n = _api.following.length;
            _following = new Vector.<Number>();
            for (i = 0; i < n; i++) {
                var num2:Number = (i < n / 2)? -1:1;
                _following = _following.concat(Vector.<Number>([300 * Math.sin(Math.PI * 4 * i / n), num2*150, 300 * Math.cos(Math.PI * 4 * i / n)]));
                _canvas.addChild(_api.following[i].image);
            }
            
            n = _api.followers.length;
            _followers = new Vector.<Number>();
            for (i = 0; i < n; i++) {
                _followers = _followers.concat(Vector.<Number>([600 * Math.sin(Math.PI * 8 * i / n), (i - n / 2) * 1500/n, 600 * Math.cos(Math.PI * 8 * i / n)]));
                _canvas.addChild(_api.followers[i].image);
            }
            
            this.addEventListener(Event.ENTER_FRAME, atEnterFrame);
        }
        private function atEnterFrame(event:Event):void {
            var mx:Number = (stage.mouseX + (stage.stageWidth - 465) / 2) / stage.stageWidth-0.5;
            mx = Math.min(Math.max(mx, -0.5), 0.5);
            
            var my:Number = (stage.mouseY + (stage.stageHeight - 465) / 2) / stage.stageHeight-0.5;
            my = Math.min(Math.max(my, -0.5), 0.5);
            _globalMatrix3D.appendRotation(1,Vector3D.Y_AXIS);
            _globalMatrix3D.appendRotation(0.1,Vector3D.X_AXIS);
            _globalMatrix3D.prependRotation(mx,Vector3D.X_AXIS);
            _globalMatrix3D.appendTranslation(0, 0, my);
            animation();
        }
        private function animation():void {
            _postedMatrix3D.appendRotation(2,Vector3D.Y_AXIS);
            _postedMatrix3D.transformVectors(_posted, _tempPosted);
            _friendsMatrix3D.appendRotation(1,Vector3D.Y_AXIS);
            _friendsMatrix3D.transformVectors(_friends, _tempFriends);
            _followingMatrix3D.appendRotation(0.5,Vector3D.Y_AXIS);
            _followingMatrix3D.transformVectors(_following, _tempFollowing);
            render();
        }
        private function render():void {
            var n:int;
            var i:int;
            var blurZ:Number;
            var vote:Vector.<Number> = new Vector.<Number>();
            _globalMatrix3D.transformVectors(_user, vote);
            _api.user.image.x = vote[0]-_api.user.image.width/2;
            _api.user.image.y = vote[1]-_api.user.image.height/2;
            _api.user.image.z = vote[2];
            
            vote = new Vector.<Number>();
            _globalMatrix3D.transformVectors(_tempPosted, vote);
            n = _api.posted.length;
            for (i = 0; i < n; i++) {
                _api.posted[i].image.x = vote[i*3+0]-_api.posted[i].image.width/2;
                _api.posted[i].image.y = vote[i*3+1]-_api.posted[i].image.height/2;
                _api.posted[i].image.z = vote[i*3+2];
                blurZ = Math.abs(vote[i * 3 + 2]);
                if(Math.abs(blurZ) > 100){
                    _api.posted[i].image.filters = [new BlurFilter(blurZ/50,blurZ/50)];
                }else {
                    _api.posted[i].image.filters = [];
                }
            }
            vote = new Vector.<Number>()
            _globalMatrix3D.transformVectors(_tempFriends, vote);
            n = _api.friends.length;
            for (i = 0; i < n; i++) {
                _api.friends[i].image.x = vote[i*3+0]-_api.friends[i].image.width/2;
                _api.friends[i].image.y = vote[i*3+1]-_api.friends[i].image.height/2;
                _api.friends[i].image.z = vote[i * 3 + 2];
                blurZ = Math.abs(vote[i * 3 + 2]);
                if(Math.abs(blurZ) > 100){
                    _api.friends[i].image.filters = [new BlurFilter(blurZ/50,blurZ/50)];
                }else {
                    _api.friends[i].image.filters = [];
                }
            }
            vote = new Vector.<Number>()
            _globalMatrix3D.transformVectors(_tempFollowing, vote);
            n = _api.following.length;
            for (i = 0; i < n; i++) {
                _api.following[i].image.x = vote[i*3+0]-_api.following[i].image.width/2;
                _api.following[i].image.y = vote[i*3+1]-_api.following[i].image.height/2;
                _api.following[i].image.z = vote[i * 3 + 2];
                blurZ = Math.abs(vote[i * 3 + 2]);
                if(Math.abs(blurZ) > 100){
                    _api.following[i].image.filters = [new BlurFilter(blurZ/50,blurZ/50)];
                }else {
                    _api.following[i].image.filters = [];
                }
            }
            vote = new Vector.<Number>()
            _globalMatrix3D.transformVectors(_followers, vote);
            n = _api.followers.length;
            for (i = 0; i < n; i++) {
                _api.followers[i].image.x = vote[i*3+0]-_api.followers[i].image.width/2;
                _api.followers[i].image.y = vote[i*3+1]-_api.followers[i].image.height/2;
                _api.followers[i].image.z = vote[i * 3 + 2];
                blurZ = Math.abs(vote[i * 3 + 2]);
                if(Math.abs(blurZ) > 100){
                    _api.followers[i].image.filters = [new BlurFilter(blurZ/50,blurZ/50)];
                }else {
                    _api.followers[i].image.filters = [];
                }
            }
            zSort();
        }
        private function zSort():void {
            var n:int = _canvas.numChildren;
            var array:Array = [];
            var reference:Array = [];
            for (var i:int = 0; i < n; i++) {
                array[i] = _canvas.getChildAt(i).z;
                reference[i] = _canvas.getChildAt(i);
            }
            var temp:Array = array.sort(Array.NUMERIC | Array.RETURNINDEXEDARRAY);
            for (i = 0; i < n; i++) {
                _canvas.setChildIndex(reference[temp[i]],0)
            }
        }
    }
}

/*
 * WonderflAPIで取得した結果を元に、
 * Fileローダーで画像を取得して、素材をそろえる。
 * */
import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.Sprite;
import flash.filters.DropShadowFilter;
import flash.geom.ColorTransform;
import flash.geom.Matrix;
import flash.text.TextField;
import flash.text.TextFormat;
import flash.system.LoaderContext;
import flash.events.Event;
class API {
    private var _wonderflAPI:WonderflAPI;
    private var _multiLoader:MultiLoader;
    private var _userThumb:Array;
    private var _followersThumb:Array;
    private var _followingThumb:Array;
    private var _friendsThumb:Array;
    public var posted:Array;
    
    public var followers:Array;
    public var following:Array;
    public var friends:Array;
    
    public var user:Object;
    public var atComp:Function = function():void{};
    public function API(userName:String):void {
        //初期化系
        _multiLoader = new MultiLoader();
        _wonderflAPI = new WonderflAPI(userName);
        _userThumb = [];
        _wonderflAPI.atUserComp = atUserComp;
        
    }
    public function play():void {
        _wonderflAPI.loadUserData();
    }
    private function atUserComp():void{
        //var array:Array = [];
        var n:int = _wonderflAPI.data.userCodes.length;
        //ユーザーのサムネール
        //array.push("http://" + String(_wonderflAPI.data.user.icon).substr(7));
        _multiLoader.add("http://" + String(_wonderflAPI.data.user.icon).substr(7),{type:"byteImage",id:String(0),context:new LoaderContext()});
        for (var i:int = 0; i < n; i++) {
            if (String(_wonderflAPI.data.userCodes[i].thumbnail).substr(0, 19) == "http://wonderfl.net") {
            //制作物のサムネール
                //array.push("http://" + String(_wonderflAPI.data.userCodes[i].thumbnail).substr(7));
                _multiLoader.add("http://" + String(_wonderflAPI.data.userCodes[i].thumbnail).substr(7),{type:"byteImage",id:String(1+i),context:new LoaderContext()});
            }else{
                //array.push(String(_wonderflAPI.data.userCodes[i].thumbnail));
                _multiLoader.add(String(_wonderflAPI.data.userCodes[i].thumbnail),{type:"byteImage",id:String(1+i),context:new LoaderContext()});
            }
        }
        //_multiLoaderClass.isCheckPolicyFile = true;
        //trace(array[0]);
        //_userThumb = _multiLoaderClass.setLoad(array, atImgComp);
        _multiLoader.addEventListener(MultiLoader.COMPLETE, atImageComp);
        _multiLoader.start();
    }
    private function atImageComp(event:Event):void {
        //trace("atImageComp",_multiLoader.items.length);
        var n:int = _multiLoader.items.length;
        posted = [];
        for (var i:int = 0; i < n; i++) {
            //if(_userThumb[i]){
                var r:int = 20;
                if(i == 0){
                    r = 50;
                }
                var bitmapData:BitmapData = new BitmapData(r * 2 , r * 2);
                var bitmap:Bitmap = _multiLoader.getBitmap(String(i));
                var w:int = bitmap.width;
                var h:int = bitmap.height;
                bitmapData.draw(bitmap, new Matrix(r * 2 / w, 0, 0, r * 2 / h), null, null, null, true);
                var sp:Sprite = new Sprite();
                if (i == 0) {
                    sp.name = "http://wonderfl.net/user/" + _wonderflAPI.data.user.name;
                    var tf:TextField = new TextField();
                    tf.defaultTextFormat = new TextFormat("_sans", 12, 0xFFFFFF);
                    tf.text = _wonderflAPI.data.user.name;
                    tf.autoSize = "left";
                    var nameTagData:BitmapData = new BitmapData(tf.width+1, tf.height+1, true, 0xFF0000);
                    nameTagData.draw(tf);
                }else {
                    sp.name = "http://wonderfl.net/code/" + _wonderflAPI.data.userCodes[i-1].id;
                }
                sp.graphics.beginBitmapFill(bitmapData, new Matrix(), false, true);
                sp.graphics.drawCircle(r,r,r-1);
                sp.graphics.endFill();
                if (i == 0) {
                    sp.graphics.beginBitmapFill(nameTagData,new Matrix(1,0,0,1,(w-nameTagData.width)/2,h),false,true);
                    sp.graphics.drawRect((w-nameTagData.width)/2,h,nameTagData.width,20);
                    sp.graphics.endFill()
                }
                sp.buttonMode = true;
                posted.push({"image":sp});
            //}
        }
        user = posted.shift();
        _wonderflAPI.atFollowComp = atLoadComps;
        _wonderflAPI.loadFollow();
    }
    private function atLoadComps():void {
        var n:int = _wonderflAPI.followersSrc.length;
        var i:int;
        for (i = 0; i < n; i++) {
            if(_wonderflAPI.followersSrc[i]){
                _multiLoader.add(_wonderflAPI.followersSrc[i], { type:"byteImage", id:"followers" + String(i), context:new LoaderContext() } );
            }
        }
        n = _wonderflAPI.followingSrc.length;
        for (i = 0; i < n; i++) {
            if(_wonderflAPI.followingSrc[i]){
                _multiLoader.add(_wonderflAPI.followingSrc[i], { type:"byteImage", id:"following" + String(i), context:new LoaderContext() } );
            }
        }
        n = _wonderflAPI.friendsSrc.length;
        for (i = 0; i < n; i++) {
            if(_wonderflAPI.friendsSrc[i]){
                _multiLoader.add(_wonderflAPI.friendsSrc[i], { type:"byteImage", id:"friends" + String(i), context:new LoaderContext() } );
            }
        }
        _multiLoader.addEventListener(MultiLoader.COMPLETE, atfffComp);
        _multiLoader.start();
    }
    private function atfffComp(event:Event):void {
        var n:int = _wonderflAPI.followersSrc.length;
        var i:int;
        var followersTemp:Array = [];
        for (i = 0; i < n; i++) {
            if (_wonderflAPI.followersSrc[i]) {
                followersTemp.push(_multiLoader.getBitmap("followers" + String(i)));
            }
        }
        n = _wonderflAPI.followingSrc.length;
        var followingTemp:Array = [];
        for (i = 0; i < n; i++) {
            if (_wonderflAPI.followingSrc[i]) {
                followingTemp.push(_multiLoader.getBitmap("following" + String(i)));
            }
        }
        n = _wonderflAPI.friendsSrc.length;
        var friendsTemp:Array = [];
        for (i = 0; i < n; i++) {
            if (_wonderflAPI.friendsSrc[i]) {
                friendsTemp.push(_multiLoader.getBitmap("friends" + String(i)));
            }
        }
        
        followers = spFromBitmaps(followersTemp,_wonderflAPI.followersTitle,new ColorTransform(0.3,0.3,0.3,1));
        following = spFromBitmaps(followingTemp, _wonderflAPI.followingTitle, new ColorTransform());
        friends = spFromBitmaps(friendsTemp, _wonderflAPI.friendsTitle, new ColorTransform());
        atComp();
    }
    
    private function spFromBitmaps(loaders:Array,titles:Array,colorTransform:ColorTransform):Array {
        var array:Array = [];
        if (!loaders) {
            return array;
        }
        var n:int = loaders.length;
        for (var i:int = 0; i < n; i++) {
            if (loaders[i]) {
                var r:int = 25;
                var bitmapData:BitmapData = new BitmapData(r*2,r*2,true,0xFF0000);
                var w:int = loaders[i].width;
                var h:int = loaders[i].height;
                bitmapData.draw(loaders[i],new Matrix(r*2/w,0,0,r*2/h),colorTransform,null,null,true);
                var sp:Sprite = new Sprite();
                sp.graphics.beginBitmapFill(bitmapData,new Matrix(),false,true)
                sp.graphics.drawCircle(r,r,r-1);
                sp.graphics.endFill();
                sp.name = titles[i];
                sp.buttonMode = true;
                array.push({"image":sp});
            }
        }
        return array;
    }

}

/*
 * WonderflAPIやスクレイピングをして、データを取得
 * */
import com.adobe.serialization.json.JSON;
import flash.events.Event;
import flash.net.URLLoader;
import flash.net.URLRequest;

class WonderflAPI{
    public var key:String = "68cdee400688f6c1d7abe138bf209a867278e573";//loaderInfo.parameters.open_api_key;
    private const BASE_URL:String = "http://api.wonderfl.net";
    private var userName:String;
    public var atUserComp:Function = function():void{};
    public var atFollowComp:Function = function():void{};
    public var data:Object;
    private var userCompCount:int;
    public var followingTitle:Array;
    public var followingSrc:Array;
    public var followersTitle:Array;
    public var followersSrc:Array;
    public var friendsTitle:Array;
    public var friendsSrc:Array;
    public function WonderflAPI(userName:String):void{
        if(key == ""){
            //key = loaderInfo.parameters.open_api_key;
        }
        this.userName = userName;
        data = {};
    }
    public function loadUserData():void{
        userCompCount = 0;
        var loader1:URLLoader = new URLLoader();
        loader1.addEventListener(Event.COMPLETE, atUserComplete);
        loader1.load(new URLRequest(BASE_URL + "/user/" + userName + "?api_key=" + key));
        var loader2:URLLoader = new URLLoader();
        loader2.addEventListener(Event.COMPLETE, atUserComplete);
        loader2.load(new URLRequest(BASE_URL + "/user/" + userName + "/codes?api_key=" + key));
    }
    public function loadCodes(type:String):void{
        var loader:URLLoader = new URLLoader();
        if(type == "user"){
            loader.load(new URLRequest(BASE_URL + "/user/" + userName + "?api_key=" + key));
        }else if(type == "userCodes"){
            loader.load(new URLRequest(BASE_URL + "/user/" + userName + "/codes?api_key=" + key));
        }
        //loader1.load(new URLRequest(BASE_URL + "/user/" + userName + "?api_key=" + KEY));
        //loader2.load(new URLRequest(BASE_URL + "/user/" + userName + "/codes?api_key=" + KEY));
        //loader2.load(new URLRequest(BASE_URL + "/code/" + "6c8e1242b3b579be206fe52167d3a15696f9a086" + "?api_key=" + KEY));
        //loader2.load(new URLRequest(BASE_URL + "/code/" + "f4966c7c4356de0d287a06bc547efd76a84a1479" + "/forks?api_key=" + KEY));
    }
    private function atUserComplete(e:Event):void {
        //trace("WonderflAPI.atUserComplete", e.target.data);
        var json:Object = JSON.decode(e.target.data);
        if(json.user){
            data["user"] = json.user;
        }else if(json.codes){
            data["userCodes"] = json.codes;
        }
        userCompCount++;
        if(userCompCount == 2){
            atUserComp();
        }
    }
    ////////////
    public function loadFollow():void {
        loadFollowing();
        loadFollowers();
    }
    private function atFollowComplete():void {
        if (followingTitle != null && followersTitle != null) {
            friendsTitle = [];
            friendsSrc = [];
            var n:int = followingTitle.length;
            for (var i:int = 0; i < n; i++) {
                var m:int = followersTitle.length;
                for (var j:int = 0; j < m; j++) {
                    if (followingTitle[n-i-1] == followersTitle[m-j-1]) {
                        followingSrc.splice(n-i-1, 1);
                        friendsSrc.push(followersSrc.splice(m - j - 1, 1).toString());
                        followingTitle.splice(n-i-1, 1);
                        friendsTitle.push(followersTitle.splice(m - j - 1, 1).toString());
                    }else {
                        //trace(followingTitle[n-i-1] , followersTitle[m-j-1])
                    }
                }
            }
            atFollowComp();
        }
    }
    //htmlをスクレイピング
    public function loadFollowing():void {
        //trace("WonderflAPI.loadFollowing");
        var myURLLoader:URLLoader = new URLLoader();
        myURLLoader.addEventListener (Event.COMPLETE, atFollowingComplete);
        //YahooPipesの汎用feedPage
        var jsonURL:String = "http://pipes.yahooapis.com/pipes/pipe.run?_id=68fa588146242e845cbac5f0ce3804a2&_render=json&url=";
        //encodeURIComponentでエスケープして、feedProxyにくっつける。
        jsonURL += encodeURIComponent("http://wonderfl.net/user/"+userName);
        myURLLoader.load(new URLRequest(jsonURL));
    }
    private function atFollowingComplete(e:Event):void 
    {
        followingTitle = [];
        followingSrc = [];
        //jsonとして受け取る
        var json:Object = JSON.decode(e.target.data);
        if (json.value.items[0] == undefined) {
            atFollowComplete();
            return;
        }
        var jsonString:String = json.value.items[0].content;
        
        //一部imgタグが閉じてないので、置き換え
        jsonString = jsonString.replace(/class="btn"><\/a>/g, "class='btn' \/><\/a>");
        //一部のユーザーのページ（http://wonderfl.net/user/alumican_net）でパースがうまくいかないことがあるので。
        try {
            var bookXML:XML = new XML(jsonString);
            var n:int = bookXML.div.div[1].ul[0].li.length();
            for (var i:int = 0; i < n; i++) {
                
                if (bookXML.div.div[1].ul[0].li[i].span.a[0]) {
                    followingSrc.push(bookXML.div.div[1].ul[0].li[i].span.a[0].img.@src);
                    followingTitle.push(bookXML.div.div[1].ul[0].li[i].span.a[0].img.@title);
                }
            }
        }catch (error:*) {
            trace("error");
        }
        atFollowComplete();
    }
    ///
    public function loadFollowers():void {
        var myURLLoader:URLLoader = new URLLoader();
        myURLLoader.addEventListener (Event.COMPLETE, atFollowersComplete);
        //YahooPipesの汎用feedPage
        //http://pipes.yahoo.com/umhrhrs/ab76bac912c6fb6815d36717a848f190
        var jsonURL:String = "http://pipes.yahooapis.com/pipes/pipe.run?_id=68fa588146242e845cbac5f0ce3804a2&_render=json&url=";
        
        //encodeURIComponentでエスケープして、feedProxyにくっつける。
        //jsonURL += encodeURIComponent("http://wonderfl.net/user/" + userName + "/followers");
        //なぜかうまくとれないので、とりあえず。
        jsonURL += encodeURIComponent("http://mztm.heteml.jp/umhr/wonderfl/followers.htm");
        //trace(jsonURL);
        myURLLoader.load(new URLRequest(jsonURL));
    }
    private function atFollowersComplete(e:Event):void 
    {
        //trace("atFollowersComplete", e.target.data);
        
        followersTitle = [];
        followersSrc = [];
        //jsonとして受け取る
        var json:Object = JSON.decode(e.target.data);
        if (json.value.items[0] == undefined) {
            atFollowComplete();
            return;
        }
        var jsonString:String = json.value.items[0].content;
        //一部imgタグが閉じてないので、置き換え
        jsonString = jsonString.replace(/class="btn"><\/a>/g, "class='btn' \/><\/a>");
        //XML型にする
        var bookXML:XML = new XML(jsonString);
        
        var n:int = bookXML.div.div[1].div[4].ul.li.length();
        for (var i:int = 0; i < n; i++) {
            followersSrc[i] = "http://wonderfl.net"+bookXML.div.div[1].div[4].ul.li.span.a[i].img.@src.substr(21);
            followersTitle[i] = bookXML.div.div[1].div[4].ul.li.span.a[i].img.@title;
        }
        atFollowComplete();
    }
}


//MulitiLoader
    /**
     * Fileローダー
     * ...
     * @author umhr
     */

    
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Loader;
    import flash.events.Event;
    import flash.events.IOErrorEvent;
    import flash.net.URLLoader;
    import flash.net.URLLoaderDataFormat;
    import flash.net.URLRequest;
    import flash.system.LoaderContext;
    import flash.system.Security;
    import flash.utils.Dictionary;
    import flash.utils.ByteArray;
    import flash.utils.getQualifiedClassName;
    import flash.display.MovieClip;
    class MultiLoader{
        public static var IMAGE_EXTENSIONS:Array = ["swf", "jpg", "jpeg", "gif", "png"];
        public static var TEXT_EXTENSIONS:Array = ["txt", "js", "xml", "php", "asp"];
        public static const COMPLETE:String = "complete";
        private var _listener:Function = function(event:Event):void{};
        private var _loads:Dictionary;
        private var _keyFromId:Dictionary;
        private var _loadCount:int;
        private var _itemsLoaded:int;
        public var items:Array;
        public function MultiLoader(name:String = ""){
            _loads = new Dictionary();
            _keyFromId = new Dictionary();
            _itemsLoaded = 0;
            items = [];
        }
        public function add(url:String, props:Object = null):void {    
            var loadingItem:LoadingItem = new LoadingItem();
            loadingItem.url = url;
            loadingItem.type = getType(url, props);
            if(props){
                if(props.context){
                    loadingItem.context = props.context;
                }
                if (props.id) {
                    _keyFromId[props.id] = url;
                }
                if (props.preventCache) {
                    loadingItem.preventCache = props.preventCache;
                }
            }
            items.push(loadingItem); 
        }
        private function getType(url:String, props:Object = null):String{
            var result:String = "";
            if (props && props.type) {
                return props.type;
            }
            var i:int;
            var extension:String;
            var n:int = IMAGE_EXTENSIONS.length;
            for (i = 0; i < n; i++) {
                extension = IMAGE_EXTENSIONS[i];
                if(extension == url.substr(-extension.length).toLowerCase()){
                    result = "image";
                    break;
                }
            }
            if(result == ""){
                n = TEXT_EXTENSIONS.length;
                for (i = 0; i < n; i++) {
                    extension = TEXT_EXTENSIONS[i];
                    if(extension == url.substr(-extension.length).toLowerCase()){
                        result = "text";
                        break;
                    }
                }
            }
            return result;
        }
        
        public function start():void{
            var n:int = items.length;
            for (var i:int = 0; i < n; i++) {
                var type:String = items[i].type;
                var url:String = items[i].url;
                url += (items[i].preventCache)?"?rand=" + Math.random():"";
                var uRLRequest:URLRequest = new URLRequest(url);
                if(type == "image"){
                    _loads[items[i].url] = loadImage(uRLRequest, items[i].context);
                }else if(type == "text"){
                    _loads[items[i].url] = loadText(uRLRequest);
                }else if (type == "byteImage") {
                    byteImage(uRLRequest, items[i].context);
                }
            }
        }
        public function addEventListener(type:String,listener:Function):void{
            _listener = listener;
        }
        public function getBitmap(key:String):Bitmap{
            key = keyMatching(key);
            var bitmap:Bitmap;
            if (_loads[key] == undefined) {
                return new Bitmap();
            };
            if (getQualifiedClassName(_loads[key].content) == "flash.display::MovieClip") {
                var mc:MovieClip = _loads[key].content;
                var bitmapData:BitmapData = new BitmapData(mc.width, mc.height);
                bitmapData.draw(mc);
                bitmap = new Bitmap(bitmapData);
            }else {
                bitmap = _loads[key].content;
            }
            return bitmap;
        }
        public function getBitmapData(key:String):BitmapData{
            key = keyMatching(key);
            var bitmap:Bitmap = getBitmap(key);
            var bitmapData:BitmapData = new BitmapData(bitmap.width, bitmap.height);
            bitmapData.draw(bitmap);
            return bitmapData;
        }
        private function loadImage(url:URLRequest, context:LoaderContext = null):Loader {
            var loader:Loader = new Loader();
            loader.contentLoaderInfo.addEventListener(Event.COMPLETE, onComp);
            loader.load(url,context);
            return loader;
        }
        private function byteImage(url:URLRequest, context:LoaderContext = null):void {
            var loader:Loader = new Loader();
            loader.contentLoaderInfo.addEventListener(Event.COMPLETE, loadBytes);
            loader.load(url, context);
            function loadBytes(event:Event):void {
                _loads[url.url] = new Loader();
                _loads[url.url].contentLoaderInfo.addEventListener(Event.COMPLETE, onComp);
                _loads[url.url].loadBytes(event.target.bytes);
            }
        }
        public function getBinary(key:String):ByteArray{
            key = keyMatching(key);
            return _loads[key].contentLoaderInfo.bytes;
        }
        
        public function getText(key:String):String {
            key = keyMatching(key);
            return key?_loads[key].data:key;
        }
        public function getXML(key:String):XML {
            return XML(getText(key));
        }
        private function keyMatching(key:String):String {
            return _loads[key]?key:_keyFromId[key];
        }
        
        private function loadText(url:URLRequest):URLLoader{
            var loader:URLLoader = new URLLoader();
            loader.addEventListener(Event.COMPLETE, onComp);
            loader.load(url);
            return loader;
        }
        private function onComp(event:Event):void{
            _itemsLoaded ++;
            if (_itemsLoaded == items.length) {
                _itemsLoaded = 0;
                _listener(event);
            }
        }
        public function get itemsTotal():int{
            return items.length;
        }
        public function get itemsLoaded():int{
            return _itemsLoaded;
        }
        public function get loadedRatio():Number {
            return _itemsLoaded / items.length;
        }
    }

import flash.net.URLRequest;
import flash.system.LoaderContext;
class LoadingItem{
    public var url:String;
    public var preventCache:Boolean;
    public var type:String;
    public var status:String;
    public var context:LoaderContext;
    public function LoadingItem(){};
}

