/**
 * Copyright rfkrocktk ( http://wonderfl.net/user/rfkrocktk )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/sorj
 */

package {
    import flash.geom.Matrix;
    import flash.events.Event;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        
        private var target:Sprite = new Sprite();
        
        private var indicator:Sprite = new Sprite();
        
        public function FlashTest() {
            target.graphics.beginFill(0x770000, 1.0);
            target.graphics.lineStyle(1, 0x007700, 1.0);
            target.graphics.drawRect(0, 0, 100, 100);
            target.graphics.endFill();
            
            this.addChild(target);
            
            target.x = 10;
            target.y = 10;
            
            indicator.graphics.beginFill(0xFFFFFF);
            indicator.graphics.drawCircle(0, 0, 10);
            indicator.graphics.endFill();
            
            this.addChild(indicator);
            
            indicator.x = 60;
            indicator.y = 60;
            
            this.addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }
        
        private function onEnterFrame(e:Event):void {
            var matrix:Matrix = target.transform.matrix;
            
            var w:Number = target.width;
            var h:Number = target.height;
            // shift it so the center is moved to 0,0
            matrix.tx -= 50;
            matrix.ty -= 50;
            
            // do our rotation, now that the center is accurate
            matrix.rotate(0.05);
            
            // shift it back, so we create the illusion of rotation place
            matrix.tx += 50;
            matrix.ty += 50;
            
            // apply our matrix
            target.transform.matrix = matrix;
        }

    }
}