/**
 * Copyright kimo0517 ( http://wonderfl.net/user/kimo0517 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/soNh
 */

/*
 * @Author: kimo0517
 * Convert any image to Base64 String. 
 * For adding image in code easily. 
 * example of decoding: http://wonderfl.net/c/wKps
 */

package 
{
    import flash.display.Bitmap;
    import flash.display.Sprite;
    import flash.display.Loader;
    import flash.events.MouseEvent;
    import flash.events.Event;
    import flash.text.TextField;
    import flash.desktop.Clipboard;
    import flash.desktop.ClipboardFormats;
    import com.bit101.components.PushButton;
    
    import flash.net.FileReference;
    import flash.net.FileFilter;
    
    import mx.utils.Base64Encoder;    
    
    [SWF(width=468, height=468, backgroundColor=0xAADDFF)]
    public class Image2Base64 extends Sprite 
    {
        private var base64Str:String = "";
        private var bmd:Bitmap;
        private var tf:TextField;
        private var btnSelectPic:PushButton;
        private var btnCopyBase64:PushButton;
        private var btnReplaceNewLine:PushButton;
        private var btnBecomeCode:PushButton;
        private var fr:FileReference;
        
        private var base64Encoder:Base64Encoder;
        
        public function Image2Base64():void 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            // entry point
            
            tf = new TextField;
            tf.autoSize = "left";
            tf.textColor = 0x000000;
            tf.multiline = false;
            //tf.background = true;
            tf.x = 5;
            tf.y = 5;
            tf.mouseEnabled = false;
            addChild(tf);
            
            btnSelectPic = new PushButton(this, 5, 25, "Select Photo", _btnSelectPicClicked);
            btnCopyBase64 = new PushButton(this, btnSelectPic.x + btnSelectPic.width, 25, "Copy Base64 String", _btnCopyBase64Clicked);
            btnReplaceNewLine = new PushButton(this, btnCopyBase64.x + btnCopyBase64.width, 25, "Copy & Remove \\n", _btnCopyBase64WithNewLineClicked);
            btnBecomeCode = new PushButton(this, btnCopyBase64.x + btnCopyBase64.width, 25, "Copy as3 code", _btnBecomeCodeClicked);
            
            
            bmd = new Bitmap;
            bmd.y = btnSelectPic.y + btnSelectPic.height + 5;
            bmd.smoothing = true;
            addChild(bmd);
        }
        
        private function _btnCopyBase64Clicked(e:MouseEvent):void {
            if (base64Str != "") {
                Clipboard.generalClipboard.clear();
                Clipboard.generalClipboard.setData(ClipboardFormats.TEXT_FORMAT, base64Str);
            
                tf.text = "Base64 string is copied to clipboard!";
            } else {
                tf.text = "Open an image first!";
            }
        }
        
        private function _btnCopyBase64WithNewLineClicked(e:MouseEvent):void {
            if (base64Str != "") {
                var newLine:RegExp = /\n|\r\n/g;
                var newB64Str:String = base64Str.replace(newLine, "");
                Clipboard.generalClipboard.clear();
                Clipboard.generalClipboard.setData(ClipboardFormats.TEXT_FORMAT, newB64Str);
            
                tf.text = "Base64 string is copied to clipboard (newlines removed)!";
            } else {
                tf.text = "Open an image first!";
            }
        }

        private function _btnBecomeCodeClicked(e:MouseEvent):void {
            if (base64Str != "") {
                var newLine:RegExp = /\n|\r\n/g;
                var newB64Str:String = base64Str.replace(newLine, "\"\n+\"");
                Clipboard.generalClipboard.clear();
                Clipboard.generalClipboard.setData(ClipboardFormats.TEXT_FORMAT, "\"" + newB64Str + "\"");
            
                tf.text = "Base64 string is copied to clipboard (as3 code)!";
            } else {
                tf.text = "Open an image first!";
            }
        }

        
        
        private function _btnSelectPicClicked(e:MouseEvent):void {
            fr = new FileReference();
            fr.addEventListener(Event.SELECT, _startLoadPhoto);
            fr.addEventListener(Event.COMPLETE, _loadPhotoComplete);
            
            var filter:FileFilter = new FileFilter("Images (*.jpg, *.png)", "*.jpg;*.jpeg;*.png", null);
            
            fr.browse([filter]);
            
        }
        
        private function _startLoadPhoto(e:Event):void {
            fr.load();
        }
        
        private function _loadPhotoComplete(e:Event):void {
            var loader:Loader = new Loader();
            loader.contentLoaderInfo.addEventListener(Event.COMPLETE, _loadBMDComplete);
            loader.loadBytes(fr.data);
            
            base64Encoder = new Base64Encoder;
            base64Encoder.encodeBytes(fr.data);
            base64Str = base64Encoder.toString();
            tf.text = "Base 64 String is ready to copy!";
        }
        
        private function _loadBMDComplete(e:Event):void {
            if (bmd.bitmapData != null) {
                bmd.bitmapData.dispose();
            }
            bmd.bitmapData = e.target.content.bitmapData.clone();
            bmd.height = 468 - bmd.y;
            bmd.width = 468;
            if (bmd.scaleX < bmd.scaleY) {
                bmd.scaleY = bmd.scaleX;
            } else {
                bmd.scaleX = bmd.scaleY;
            }
            
        }
        
    }
    
}