/**
 * Copyright nitoyon ( http://wonderfl.net/user/nitoyon )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/snjn
 */

package {
import flash.display.*;
import flash.events.Event;
import flash.geom.Vector3D;
import flash.utils.setInterval;
import caurina.transitions.Tweener;

public class Test extends Sprite {
    private var container:Sprite;
    private var shapes:Vector.<Sprite> = new Vector.<Sprite>();

    private const SIZE:Number = 300;

    public function Test() {
        container = Sprite(addChild(new Sprite()));
        container.x = container.y = container.z = SIZE / 2;

        var plane:Sprite = Sprite(container.addChild(createPlane(0xffff00)));
        plane.z = -SIZE / 2;
        shapes.push(plane);

        plane = Sprite(container.addChild(createPlane(0x0000ff)));
        plane.x = SIZE / 2;
        plane.rotationY = 90;
        shapes.push(plane);

        plane = Sprite(container.addChild(createPlane(0xff00ff)));
        plane.z = SIZE / 2;
        plane.rotationY = 180;
        shapes.push(plane);

        plane = Sprite(container.addChild(createPlane(0xff0000)));
        plane.x = -SIZE / 2;
        plane.rotationY = 270;
        shapes.push(plane);
        doZSort();

        var rot:int = 0;
        setInterval(function():void {
            Tweener.addTween(container, {
                rotationY: ++rot * 90,
                time: 1.5,
                onUpdate: doZSort
            });
        }, 2000);
    }

    private function createPlane(color:uint):Sprite {
        var plane:Sprite = new Sprite();
        plane.graphics.beginFill(color);
        plane.graphics.drawRect(-SIZE / 2, -SIZE / 2, SIZE, SIZE);
        plane.graphics.endFill();
        return plane;
    }

    private function doZSort():void {
        shapes.sort(depthSort);
        for (var i:int = 0; i < shapes.length; i++) {
            container.addChildAt(shapes[i], i);
        }
    }

    private function depthSort(obj1:Sprite, obj2:Sprite):int {
        var pos1:Vector3D = obj1.transform.matrix3D.position;
        pos1 = container.transform.matrix3D.deltaTransformVector(pos1);
        var pos2:Vector3D = obj2.transform.matrix3D.position;
        pos2 = container.transform.matrix3D.deltaTransformVector(pos2);
        return pos2.z - pos1.z;
    }
}
}