/**
 * Copyright kotobuki ( http://wonderfl.net/user/kotobuki )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/snN4
 */

package {
  import flash.display.Sprite;
  import flash.events.Event;

  import funnel.*;

  public class ConnectWirelessly extends Sprite {
    // Arduino Fio
    private var fio:Fio;

    // センサに接続したピン
    private var sensorPin:Pin;

    // センサの値の変化を確認するシグナルスコープ
    private var signalScope:SignalScope;

    public function ConnectWirelessly() {
      // Fioのインスタンスを生成
      fio = new Fio([1], Fio.FIRMATA);

      // センサに接続したピンを表す変数を初期化
      sensorPin = fio.ioModule(1).analogPin(0);

      // シグナルスコープを生成
      signalScope = new SignalScope(10, 10, 200, 
                                    "Fio (1) A0");
      addChild(signalScope);

      // 毎フレームごとに発生するイベントにイベントリスナをセット
      addEventListener(Event.ENTER_FRAME, onEnterFrame);
    }

    private function onEnterFrame(e:Event):void {
      // 毎フレームごとに表示を更新
      signalScope.update(sensorPin);
    }
  }
}
