/**
 * Copyright albatrus_jp ( http://wonderfl.net/user/albatrus_jp )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/sm30
 */

package {
	import flash.events.*;
	import flash.filters.*;
	import flash.utils.*;
	import org.papervision3d.core.effects.*;
	import org.papervision3d.core.geom.*;
	import org.papervision3d.core.geom.renderables.*;
	import org.papervision3d.view.layer.*;
	import org.papervision3d.view.*;
	
	public class Pixel3DSample extends BasicView {
		public function Pixel3DSample():void {
			// ビットマップエフェクトレイヤーを作成
			var layer:BitmapEffectLayer = new BitmapEffectLayer(viewport, 640, 480);
			viewport.containerSprite.addLayer(layer);
			// ブラーエフェクトを設定
			layer.addEffect(new BitmapLayerEffect(new BlurFilter(8, 2, 4), false));
			
			// Picelsを作成
			var  pixels:Pixels = new Pixels(layer);
			scene.addChild(pixels);
			
			for (var i:int = 0; i < 1000; i++) {
				// 座標を設定
				var rot:Number = (i / 1000) * 360 * 6; // 4回転
				var pointX:Number = 500 * Math.sin(rot * Math.PI / 180);
				var pointZ:Number = 500 * Math.cos(rot * Math.PI / 180);
				var pointY:Number = i - 500; // らせん状に配置
				
				// 点を描写する
				var pixel:Pixel3D = new Pixel3D(0xFF339900, pointX, pointY, pointZ);
				pixels.addPixel3D(pixel);
			}
			
			// レンダリング
			startRendering();
			
			// エンターフレームイベントの登録
			addEventListener(Event.ENTER_FRAME, loop);
		}
		
		private function loop(e:Event):void {
			// カメラの運動を設定
			camera.x = 1500 * Math.sin(getTimer() / 2000);
			camera.z = 1500 * Math.cos(getTimer() / 2000);
			camera.y = 800 * Math.sin(getTimer() / 1000);
		}
	}
}
