/**
 * Copyright alpicola ( http://wonderfl.net/user/alpicola )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/skU7
 */

package {
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;

	[SWF(backgroundColor="#ffffff", frameRate="60")]

	public class LissajousCurve extends Sprite {

		private var spin:Number = 0;
		private var s:Number = 0;
		private var cMouseX:Number;
		private var cMouseY:Number;

		public function LissajousCurve() {
            stage.align = "TL";
            stage.scaleMode = "noScale";
			x = stage.stageWidth / 2;
			y = stage.stageHeight / 2;
			scaleX = x * 0.004;
			scaleY = y * 0.004;
			cMouseX = mouseX;
			cMouseY = mouseY;

			addEventListener(Event.ENTER_FRAME, loop);
			stage.addEventListener(MouseEvent.MOUSE_MOVE, move);
		}

		public function loop(e:Event):void {
			graphics.clear();
			s *= 0.99;
			spin += s;

			for (var i:int = 0; i < 1000; i++) {	
				var xx:Number = i * mouseX * 0.0002 + spin * 0.002;
				var yy:Number = i * mouseY * 0.0002 + spin * 0.002;
				var c:Object = hsv2rgb(i * 0.5, 0.6, 0.8);
				graphics.beginFill((c.r & 0xff) << 16 | (c.g & 0xff) << 8 | (c.b & 0xff), 0.75);
				graphics.drawRect(200 * Math.sin(xx), 200 * Math.cos(yy), 2, 2);
			}
		}

		public function move(e:Event):void {
			s += Math.sqrt(Math.pow(mouseX - cMouseX, 2) + Math.pow(mouseY - cMouseY, 2)) * 0.01
			cMouseX = mouseX;
			cMouseY = mouseY;
		}

		private function hsv2rgb(h:Number, s:Number, v:Number):Object {
			var r:int;
			var g:int;
			var b:int;

			if (s == 0) {
				r = g = b = v * 0xff;
			} else {
				var ht:Number = h;
				ht = (((ht %= 360) < 0) ? ht + 360 : ht) / 60;
				var vt:Number = Math.max(0, Math.min(0xff, v * 0xff));
				var hi:int = Math.floor(ht);

				switch(hi) {
					case 0:
						r = vt;
						g = vt * (1 - (1 - ht + hi) * s);
						b = vt * (1 - s);
						break;
					case 1:
						r = vt * (1 - s * ht + s * hi);
						g = vt;
						b = vt * (1 - s);
						break;
					case 2:
						r = vt * (1 - s);
						g = vt;
						b = vt * (1 - (1 - ht + hi) * s);
						break;
					case 3:
						r = vt * (1 - s);
						g = vt * (1 - s * ht + s * hi);
						b = vt;
						break;
					case 4:
						r = vt * (1 - (1 - ht + hi) * s);
						g = vt * (1 - s);
						b = vt;
						break;
					case 5:
						r = vt;
						g = vt * (1 - s);
						b = vt * (1 - s * ht + s * hi);
						break;
				}
			}
			
			return { r:r, g:g, b:b };
		}

	}
}
