/**
 * Copyright hacker_rur__k1j ( http://wonderfl.net/user/hacker_rur__k1j )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/skNw
 */

// forked from sekiryou's forked from: Saqoosha challenge for amateurs [ Iridescent Locus ]
//forked from: Saqoosha challenge for amateurs
package {
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.geom.Point;
    import flash.geom.Matrix;
    import flash.geom.ColorTransform;
    import flash.geom.Rectangle;
    import flash.filters.BlurFilter;
    import org.libspark.betweenas3.easing.Circ;

    [SWF(width=465, height=465, backgroundColor=0x000000, frameRate=30)]

    public class IridescentLocus extends Sprite {
        private const STAGE_WIDTH = stage.stageWidth;
        private const STAGE_HEIGHT = stage.stageHeight;
        private const STAGE_CENTER_X = stage.stageWidth / 2;
        private const STAGE_CENTER_Y = stage.stageHeight / 2;

        private var SatelliteAmount:uint = 20;
        private var satellites:Array = [];
        private var FocalLength:Number = 124;

        private var grad:Gradation;
        private var rAcrc:uint = 12;

        private var _canvas:BitmapData;
        private var bmp:Bitmap;
        private var _particles:Array;
        private var _rect:Rectangle;
        private var cTra:ColorTransform;

        public function IridescentLocus() {
            init();
        }
        private function init():void {
            _canvas = new BitmapData (STAGE_WIDTH, STAGE_HEIGHT, true, 0xFFFFFF);
            bmp = new Bitmap (_canvas);
            addChild (bmp);

            _rect = new Rectangle(0, 0, STAGE_WIDTH, STAGE_HEIGHT);
            cTra = new ColorTransform( 0.92, 0.92, 0.92, 1.0 );

            IridescentMake();
            for ( var i:uint = 0; i < SatelliteAmount; i++ )
            {
                var s:Satellite = new Satellite();
                satellites.push( s );
                WtoS( s );
            }
            addEventListener( Event.ENTER_FRAME, onEnterFrameHandler );
        }
        private function WtoS( t ):void {
            if ( t.pz > -FocalLength ) {
                t.bv_orgX = t.v_orgX;
                t.bv_orgY = t.v_orgY;
                t.bv_trmX = t.v_trmX;
                t.bv_trmY = t.v_trmY;
                t.bx = t.x;
                t.by = t.y;
                t.scale = FocalLength / ( FocalLength + t.pz );
                t.x = STAGE_CENTER_X + t.px * t.scale;
                t.y = STAGE_CENTER_Y + t.py * t.scale;
                t.v_orgX = STAGE_CENTER_X + t.orgX * t.scale;
                t.v_orgY = STAGE_CENTER_Y + t.orgY * t.scale;
                t.v_trmX = STAGE_CENTER_X + t.trmX * t.scale;
                t.v_trmY = STAGE_CENTER_Y + t.trmY * t.scale;
                t.scaleX = t.scaleY = t.scale;
                t.visible = true;
            } else {
                t.visible = false;
            }
        }
        private function onEnterFrameHandler( e:Event ) {
            _canvas.lock();
            _canvas.colorTransform(_rect, cTra);
            for ( var i:uint = 0; i < SatelliteAmount; i++ )
            {
                var s = satellites[ i ];
                s.motion();
                s.axisCalculate();
                WtoS( s );

                var varX:Number = ( s.v_trmX - s.v_orgX ) / rAcrc;
                var varY:Number = ( s.v_trmY - s.v_orgY ) / rAcrc;
                var b_varX:Number = ( s.bv_trmX - s.bv_orgX ) / rAcrc;
                var b_varY:Number = ( s.bv_trmY - s.bv_orgY ) / rAcrc;

                for ( var j:uint = 0; j < rAcrc; j++ )
                {
                    var line:Sprite = new Sprite();
                    line.graphics.lineStyle( 1.6, grad.getColor( j / rAcrc ) );
                    line.graphics.moveTo( s.x + varX * j - varX * rAcrc / 2, s.y + varY * j - varY * rAcrc / 2 );
                    line.graphics.lineTo( s.bx + b_varX * j - b_varX * rAcrc / 2, s.by + b_varY * j - b_varY * rAcrc / 2 );
                    _canvas.draw( line )
                }
            }
            _canvas.unlock();
        }
        private function IridescentMake():void {
            grad = new Gradation( 0x660066, 0x0000FF, 0x00FFFF, 0x00FF00, 0xFFFF00, 0xFF6600, 0xFF0000 );
            grad.setEasing(Circ.easeInOut);
        }
    }
}

import flash.display.Sprite;
class Satellite extends Sprite {
    public var scale:Number;
    public var px:Number;
    public var py:Number;
    public var pz:Number;

    public var vx:Number;
    public var vy:Number;
    public var vz:Number;

    public var line_width:Number;

    public var pr:Number;
    public var vr:Number;

    public var orgX:Number;
    public var orgY:Number;
    public var orgZ:Number;
    public var trmX:Number;
    public var trmY:Number;
    public var trmZ:Number;

    public var v_orgX:Number;
    public var v_orgY:Number;
    public var bv_orgX:Number;
    public var bv_orgY:Number;
    public var v_trmX:Number;
    public var v_trmY:Number;
    public var bv_trmX:Number;
    public var bv_trmY:Number;

    public var bx:Number;
    public var by:Number;

    public var hx:Number;
    public var hy:Number;
    public var hz:Number;

    public var ratioX:Number;
    public var ratioY:Number;
    public var ratioZ:Number;

    public var friction:int;
    public var depth:int;

    public function Satellite() {
        init();
    }
    private function init():void {
        line_width = 6;

        px = Math.random() * 240 - 120;
        py = Math.random() * 240 - 120;
        pz = Math.random() * 240 - 120;

        hx = 0;
        hy = 0;
        hz = 0;

        friction = 1;
        depth = 640;

        ratioX = ( Math.random() * 4 + 2 ) / depth;
        ratioY = ( Math.random() * 4 + 2 ) / depth;
        ratioZ = ( Math.random() * 4 + 2 ) / depth;

        vx = 0;
        vy = 0;
        vz = 0;

        pr = 0;
        vr = Math.random() * 0.6 - 0.3;

        axisCalculate();
    }
    public function motion():void {
        vx = ( vx * friction) + ( ( hx - px ) * ratioX );
        vy = ( vy * friction) + ( ( hy - py ) * ratioY );
        vz = ( vz * friction) + ( ( hz - pz ) * ratioZ );

        px += vx;
        py += vy;
        pz += vz;
        if ( Math.abs( px ) < 8 && Math.abs( py ) < 8  && Math.abs( pz ) < 8 ) {
            if( Math.abs( vx ) < 1 && Math.abs( vy ) < 1  && Math.abs( vz ) < 1 ){
                init();
            }
        }
    }
    public function axisCalculate():void {
        var pp_orgX:Number = px + 0;
        var pp_orgY:Number = py + line_width / 2;
        var pp_orgZ:Number = pz + 0;
        var pp_trmX:Number = px + 0;
        var pp_trmY:Number = py - line_width / 2;
        var pp_trmZ:Number = pz + 0;
        var angle:Number = Math.atan2( py, px );

        pr += vr;
        angle += pr;

        var p_orgX:Number = Math.cos( angle ) * ( pp_orgX - px ) - Math.sin( angle ) * ( pp_orgY - py );
        var p_orgY:Number = Math.cos( angle ) * ( pp_orgY - py ) + Math.sin( angle ) * ( pp_orgX - px );
        var p_trmX:Number = Math.cos( angle ) * ( pp_trmX - px ) - Math.sin( angle ) * ( pp_trmY - py );
        var p_trmY:Number = Math.cos( angle ) * ( pp_trmY - py ) + Math.sin( angle ) * ( pp_trmX - px );

        p_orgX += px;
        p_orgY += py;
        p_trmX += px;
        p_trmY += py;

        orgX = p_orgX;
        orgY = p_orgY;
        trmX = p_trmX;
        trmY = p_trmY;
    }
}

import frocessing.color.ColorLerp;
import org.libspark.betweenas3.core.easing.IEasing;
import org.libspark.betweenas3.easing.Linear;

class Gradation {
    private var _colors:Array;
    private var _easing:IEasing;

    public function Gradation(...args) {
        _colors = args.concat();
        _easing = Linear.linear;
    }

    public function setEasing(easing:IEasing):void {
        _easing = easing;
    }

    public function getColor(position:Number):uint {
        position = (position < 0 ? 0 : position > 1 ? 1 : position) * (_colors.length - 1);
        var idx:int = position;
        var alpha:Number = _easing.calculate(position - idx, 0, 1, 1);
        if (alpha == 0) {
            return _colors[idx];
        } else {
            return ColorLerp.lerp(_colors[idx], _colors[idx + 1], alpha);
        }
    }
}