/**
 * Copyright devon_o ( http://wonderfl.net/user/devon_o )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/sjvZ
 */

package {
    
    import com.bit101.components.PushButton;
    
    import gs.easing.Back;
    import gs.TweenLite;
    
    import flash.display.Graphics;
    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.Point;
    import flash.utils.Dictionary;
    
    [SWF(width='465', height='465', backgroundColor='#000000', frameRate='31')]
    public class Main extends Sprite {
        
        public static const GRID_SIZE:int         = 10;
        public static const NUM_ROWS:int         = 33;
        public static const NUM_COLS:int         = 30;
        public static const GRID_COLOR:uint     = 0xFF00FF;
        public static const SHOW_GRID:Boolean     = false;
        public static const BUFFER:int             = 40;
        
        
        private var _grid:Vector.<Vector.<Boolean>>;
        private var _positions:Dictionary;
        private var _spacing:Number = 2.00;
        
        private var _numItems:int = 45;
        private var _items:Array;
        
        
        public function Main():void {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(event:Event = null):void {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            
            createGrid();
            if (SHOW_GRID) showGrid();
            createItems();
            
            setTargets();
            showItems();
            
            var b:PushButton = new PushButton(this, 5, stage.stageHeight - 25, "Arrange Grid", rearrangeGrid);
        }
        
        private function rearrangeGrid(event:MouseEvent):void {
            createGrid();
            setTargets();
            showItems();
        }
        
        private function createGrid():void {
            _grid = new Vector.<Vector.<Boolean>>(NUM_ROWS + 1, true);
            var l:int = _grid.length;
            for (var row:int = 0; row < l - 1; row++) {
                var v:Vector.<Boolean> = new Vector.<Boolean>(NUM_COLS + 1, true);
                var l2:int = v.length;
                for (var col:int = 0; col < l2 - 1; col++) {
                    v[col] = false;
                }
                v[col] = true;
                _grid[row] = v;
            }
            var cap:Vector.<Boolean> = new Vector.<Boolean>(NUM_COLS + 1, true);
            var l3:int = cap.length;
            for (var i:int = 0; i < l3; i++) {
                cap[i] = true;
            }
            _grid[row] = cap;
        }
        
        private function createItems():void {
            _items = new Array(_numItems);
            for (var i:int = 0; i < _numItems; i++) {
                var s:Shape = new Shape();
                var w:int = randRange(5, 2) * GRID_SIZE;
                var h:int = randRange(5, 2) * GRID_SIZE;
                var g:Graphics = s.graphics;
                g.beginFill(randRange(0xFFFFFF));
                g.drawRect(0, 0, w, h);
                g.endFill();
                s.x = -s.width;
                s.y = -s.height;
                addChild(s);
                _items[i] = s;
            }
        }
        
        private function showGrid():void {
            var s:Shape = new Shape();
            s.graphics.lineStyle(0, GRID_COLOR);
            var i:int;
            for (i = 0; i < NUM_COLS + 1; i++) {
                s.graphics.moveTo(i * (GRID_SIZE + _spacing), 0);
                s.graphics.lineTo(i * (GRID_SIZE + _spacing), NUM_ROWS * (GRID_SIZE + _spacing));
            }
            for (i = 0; i < NUM_ROWS + 1; i++) {
                s.graphics.moveTo(0, i * (GRID_SIZE + _spacing));
                s.graphics.lineTo(NUM_COLS * (GRID_SIZE + _spacing), i * (GRID_SIZE + _spacing));
            }
            s.x = s.y = BUFFER;
            addChild(s);
        }
        
        private function showItems():void {
            var l:int = _items.length;
            for (var i:int = 0; i < l; i++) {
                var item:Shape = _items[i];
                if (_positions[item] != null) {
                    item.visible = true;
                    var tx:int = _positions[item].x;
                    var ty:int = _positions[item].y;
                    TweenLite.to(item, .75, { x:tx, y:ty, ease:Back.easeInOut } );
                } else {
                    item.visible = false;
                    trace ("couldn't find room for item");
                }
            }
        }
        
        private function setTargets():void {
            _items = shuffleArray(_items);
            _positions = new Dictionary();
            var l:int = _items.length;
            for(var i:int = 0; i < l; i++) {
                var item:Shape = _items[i];
                var colCheck:int = item.width / GRID_SIZE;
                var rowCheck:int = item.height / GRID_SIZE;
                var goodLocation:Boolean = false;
                gridLoop: for (var row:int = 0; row < NUM_ROWS; row++) {
                    var x:int, y:int;
                    var firstPos:int = randRange(NUM_COLS);
                    var stepVal:int = randRange(8, 1);
                    for (var col:int = firstPos; col < NUM_COLS; col+=stepVal) {
                        if (!_grid[row][col]) {
                            goodLocation = true;
                            for (x = 0; x < colCheck; x++) {
                                for (y = 0; y < rowCheck; y++) {
                                    if (_grid[row + y][col + x]) {
                                        goodLocation = false;
                                        break; 
                                    }
                                }
                                if (!goodLocation) break;
                            }
                        }    
                        if (goodLocation) {
                            _positions[item] = new Point((col * (GRID_SIZE + _spacing)) + BUFFER, (row * (GRID_SIZE + _spacing)) + BUFFER);
                            for(x = 0; x < colCheck; x++) {
                                for(y=0; y < rowCheck; y++) {
                                    _grid[row + y][col + x] = true;
                                }
                            }
                            break gridLoop;
                        }
                    }
                }
            }
        }
        
        private function randRange(max:Number, min:Number = 0, decimals:int = 0):Number {
            if (min > max) return NaN;
            var rand:Number = Math.random() * (max - min) + min;
            var d:Number = Math.pow(10, decimals);
            return ~~((d * rand) + 0.5) / d;
        }
        
        public function shuffleArray(arr:Array):Array {
            var len:int = arr.length;
            var temp:*;
            for (var i:int = 0; i < len; i ++) {
                var rand:int = Math.floor (Math.random() * len);
                temp = arr[i];
                arr[i] = arr[rand];
                arr[rand] = temp;
            }
            temp = null;
            return arr;
        }
    }
}