/**
 * Copyright yooKo_old_account ( http://wonderfl.net/user/yooKo_old_account )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/sj8a
 */

package {
	import flash.display.Loader;
	import flash.display.LoaderInfo;
	import flash.display.Sprite;
	import flash.display.MovieClip;
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.filters.BlurFilter;
	import flash.geom.ColorTransform;
	import flash.filters.BitmapFilterQuality;
	import flash.geom.Point;
	import flash.geom.Rectangle;
	import flash.events.Event;
	import flash.events.TimerEvent;
	import flash.events.MouseEvent;
	import flash.net.URLRequest;
	import flash.text.TextField;
	import flash.text.TextFieldAutoSize;
	import flash.text.TextFormat;
	import flash.utils.Timer;
	import flash.utils.getTimer;
	import net.hires.debug.Stats;
	
	[SWF(width = "500", height = "500", backgroundColor = "0x000000", frameRate = "30")]
	
	public class RyukyuClock extends Sprite {
		private var loader:Loader;
		private var startTime:int ;	
		private var flg:Boolean = true;
		// 画像のURL
		private static const IMAGE_URL:String = "http://wonderfl.net/static/tmp/related_images/ecb5ca0f778d1224de1265c912317b1fb0967001m";
		// パーティクルを描画するカンバスのBitmapData
		private var canvas:BitmapData;
		// テキストを描画するカンバスのBitmapData
		private var source:BitmapData;
		// Particleリスト
		private var particlesList:Array = [];
		
		private var j:int = 1;
		// 描画するパーティクルの数
		private var p_num:int;
		private var angle:Number = 150;
		// パーティクルを元の位置から移動させる最大距離
		private var maxDis:int = 400;

		// 定数
		private static const PARTICLE_MAX:int = 6000;
		private static const POINT_ZERO:Point = new Point();
		private static const TRANSFORM_COLOR:ColorTransform = new ColorTransform(1, 1, 1, .95, 0, 0, 0, 0);	
		private static const FILTER_BLUR:BlurFilter = new BlurFilter(4, 4, BitmapFilterQuality.LOW);	
		
		//========================================================================
		// コンストラクタ
		//========================================================================
		public function RyukyuClock() {			
			loader = new Loader();			 
			loader.contentLoaderInfo.addEventListener(Event.COMPLETE, loadComplete);
			loader.load(new URLRequest(IMAGE_URL));
		}
		
		//========================================================================
		// ソース画像の読み込み後に実行される処理
		//========================================================================
		public function loadComplete(e:Event = null):void {
			currentParticle();
			
			// テキストを作成する
			var tf:TextField = new TextField();
			tf.defaultTextFormat = new TextFormat("Swis721 BdRnd BT", 40, 0xFFFFFF); 
			tf.autoSize = TextFieldAutoSize.LEFT;
			tf.text = String(loader);
			// textCanvasに文字を描画する
			var textCanvas:BitmapData = new BitmapData(tf.textWidth, tf.textHeight, false, 0x000000);
			textCanvas.draw(tf);			
			analysisOfImage(textCanvas);			
			addChild(tf);
			var o:LoaderInfo = e.target as LoaderInfo;
			o.removeEventListener(Event.COMPLETE, loadComplete);			
			// カンバスの生成
			//canvas = new BitmapData(stage.stageWidth, stage.stageHeight, false, 0x000000);
			//addChild(new Bitmap(canvas));
			
			// ソース画像
			//var bmp:Bitmap = loader.content as Bitmap;
			//source = bmp.bitmapData;			
			// ソース画像の解析
			//analysisOfImage(bmp.bitmapData);	
			//analysisOfImage(textCanvas);	
			//var timer:Timer = new Timer(10);
			//timer.addEventListener(TimerEvent.TIMER, loop);
			//timer.start();		
			
			//stage.addEventListener(MouseEvent.CLICK, onClick);
			
			//addChild(new Stats());
		}
		
		public function currentParticle():void {
			var particles:Array = [];
			for (var i:int = 0; i < PARTICLE_MAX; i++) {
				var p:Particle = new Particle();
				var rad:Number = Math.random() * ( Math.PI * 2 );
				p.x = stage.stageWidth / 2 + 120 * Math.cos( rad );
				p.y = stage.stageHeight / 2 + 120 * Math.sin( rad );
				p.ex = p.x;
				p.ey = p.y;
				p.c = 0xFFFFFF;
				particles.push(p);
			}
			particlesList.push(particles);
		}		

		//========================================================================
		// ソース画像の解析をする関数
		//========================================================================
		public function analysisOfImage(o:BitmapData):void {
			var particles:Array = [];
			for (var _x:Number = 0; _x < o.width; _x++) {
				for (var _y:Number = 0; _y < o.height; _y++) {
					var c:uint = o.getPixel(_x, _y);
					if (c != 0x000000) {
						var p:Particle = new Particle();
						p.x = _x + stage.stageWidth / 2 - o.width / 2;
						p.y = _y + stage.stageHeight / 2 - o.height / 2;
						//p.c = c;						
						particles.push(p);
					}
				}
			}
			particlesList.push(particles);
			// パーティクルの総数
			//trace(particles.length);
		}
		
		//========================================================================
		// パーティクル配列内の情報を元に常にcanvasの描画を更新する
		//========================================================================
		private function loop(e:TimerEvent = null):void {
			
			var wait:Number;
			var now:int = getTimer();	
			canvas.lock();
			canvas.colorTransform(canvas.rect, TRANSFORM_COLOR);
			canvas.applyFilter(canvas, canvas.rect, POINT_ZERO, FILTER_BLUR);	
			for (var i:int = 0; i < PARTICLE_MAX; i++) {
				var p:Particle = particlesList[0][i];	
				//p.ex = p.ex + .12;
				//p.ey = p.ey + .12;
				if (particlesList[j][i]) {
					var tp:Particle = particlesList[j][i];
					wait = ( 1 - ( tp.x / loader.content.width  ) ) * 5000;
					if ( startTime + wait > now ) continue ; 	
					
					// パーティクルが到達点に近づいたら（xが0.5以内　かつ　yも0.5以内)ならスナップさせる
					if (Math.abs(tp.x - p.x) < 0.5 && Math.abs(tp.y - p.y) < 0.5) {
						p.x = tp.x;
						p.y = tp.y;
					}else{
						// イージングでXY座標を設定
						p.x += (tp.x - p.x) * .05;
						p.y += (tp.y - p.y) * .05;
					}
				//canvas.setPixel( p.x, p.y, p.c );
				}else {
					//wait = ( 1 - ( p.x / loader.content.width  ) ) * 5000;
					//if ( startTime + wait > now ) continue ; 	
					// パーティクルが到達点に近づいたら（xが0.5以内　かつ　yも0.5以内)ならスナップさせる
					if (Math.abs(p.ex - p.x) < 0.5 && Math.abs(p.ey - p.y) < 0.5) {
						p.x = p.ex;
						p.y = p.ey;
					}else{
						// イージングでXY座標を設定
						p.x += (p.ex - p.x) * .05;
						p.y += (p.ey - p.y) * .05;
					}
				}
				canvas.setPixel( p.x, p.y, p.c );
			}	
			// 描画するパーティクルの数を増やす
			//var n:int = particlesList[i].length;
			//p_num = ( p_num + 100 < n ) ? p_num + 100 : n;			
			canvas.unlock();
		}
		
		//========================================================================
		// 配列の中身をランダムに並び替える
		//========================================================================
		private function shuffle(list:Array):Array{
			var i:int = list.length;
			while (--i) {
				var j:Number = Math.floor(Math.random() * (i + 1));
				if (i == j) continue;
				var k:Particle = list[i];
				list[i] = list[j];
				list[j] = k;
			}
			return list;
		}		
		
		//========================================================================
		// パーティクルをリセットする
		//========================================================================
		private function onClick(e:MouseEvent = null):void {
			startTime = getTimer();
			flg = !flg;
			j = (flg) ? 1 : 2;
			
			//shuffle(particlesList[0]);
		}
	}
}

//========================================================================
// Particleクラス
//========================================================================
class Particle {
	// X座標
	public var x:Number;
	// Y座標
	public var y:Number;
	// Xの初期位置
	public var ex:Number;
	// Yの初期位置
	public var ey:Number;
	// カラー
	public var c:int;
	
	public function Particle() {
		x = 0;
		y = 0;
		c = 0;
	}
}


