/**
 * Copyright itsukichang ( http://wonderfl.net/user/itsukichang )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/sj89
 */

package {
    
    import flash.display.Sprite;
    [SWF(backgroundColor="#ffffff", frameRate="30",width="550",height="400" )]
    public class MoveStick extends Sprite {
        
        private var _stick:Stick;
        private var _width:Number = 50;
        
        public function MoveStick() {
            init();
        }    
        
        private function init():void {
            
            for (var i:uint = 0; i < stage.stageWidth / _width; i++) {
                _stick = new Stick(_width, 0 , Math.random() * 0xffffff, stage.stageHeight);
                _stick.x = i * _width;
                addChild(_stick);
            }
        }
    }
}

import flash.display.Sprite;
import flash.events.Event;
import flash.events.MouseEvent;
import flash.filters.DropShadowFilter;
import flash.filters.GlowFilter;
import flash.filters.BlurFilter;


class Stick extends Sprite {
    
    private var _sp:Sprite;
    private var _parent:Sprite;
    
    private var _width:Number;
    private var _height:Number;
    private var _col:Number;
    private var _targetY:Number;
    private var _maxHeight:Number
    private var _speed:Number;
    private var _p:ParticleMove;
    private var _nowMouseY:Number;
    
    public function Stick(w:Number = 20, h:Number = 0, col:Number = 0xff0000, maxHeight:Number = 500) {
        _width = w;
        _height = h;
        _col = col;
        _maxHeight = maxHeight;
        init();
    }    
    
    private function init():void {
        
        trace(_width,_height);
        _parent = new Sprite();
        //_parent.graphics.lineStyle(1);
        _parent.graphics.beginFill(0xffffff);
        _parent.graphics.drawRect(0, 0, _width, _maxHeight);
        _parent.graphics.endFill();
        //_parent.filters = [new BlurFilter()];
        addChild(_parent);
        
        _sp = new Sprite();
        _sp.graphics.beginFill(_col);
        _sp.graphics.drawRoundRect(0, _maxHeight, _width, -_height,20,20);
        _sp.graphics.endFill();    
        //_sp.filters = [new BlurFilter()];
        _sp.alpha = 0.5;
        _parent.addChild(_sp);
        
        _parent.addEventListener(MouseEvent.MOUSE_OVER, onOver);
        _parent.addEventListener(MouseEvent.MOUSE_OUT, onOut);
        _parent.addEventListener(MouseEvent.MOUSE_MOVE, onMove);
        
        _p = new ParticleMove(_width/2, _maxHeight - 20);
        addChild(_p);
        
    }
    
    private function onMove(e:MouseEvent):void {
        _nowMouseY = mouseY;
        _targetY = _maxHeight - _nowMouseY;
    }
    private function onOver(e:MouseEvent):void {
        trace("over");
        _targetY = _maxHeight - _nowMouseY;
        _speed = 1.5;
        _sp.addEventListener(Event.ENTER_FRAME, onLoop);
        trace(mouseY);
        
    }
    
    private function onOut(e:MouseEvent):void {
        trace("out");
        _targetY = 0;
        _speed = 50;
        _sp.addEventListener(Event.ENTER_FRAME, onLoop);
        
    }
    
    private function onLoop(e:Event):void {
        _height += (_targetY - _height) / _speed;
        _p.yPos = stage.stageHeight - _height;
        initGraphics();
        
        if (Math.abs(_targetY - _height) < 3) {
            trace("end");
            _height = _targetY;
            _sp.removeEventListener(Event.ENTER_FRAME,onLoop);
        }
    }
    
    private function initGraphics():void {
        _sp.graphics.clear();
        _sp.graphics.beginFill(_col);
        //_sp.graphics.drawRoundRect(0, _maxHeight, _width, -_height, 20,20);
        _sp.graphics.drawRect(0, _maxHeight, _width, -_height);

        _sp.graphics.endFill();    
        _sp.alpha = 0.5;
    }
    
    public function set hei(h:Number):void {
        _height = h;
        initGraphics();
    }
    
    public function set col(c:Number):void {
        _col = c;
        initGraphics();    
    }
}


import flash.display.Sprite;
    
class Ball extends Sprite {
    
    private var _sp:Sprite;
    private var _col:uint;
    private var _r:Number;
    
    public function Ball(r:Number = 10, col:uint = 0xff0000) {
        _r = r;
        _col = col;
        
        init();
    }
    
    private function init():void {
        _sp = new Sprite();
        _sp.graphics.beginFill(_col);
        _sp.graphics.drawCircle(0, 0, _r);
        _sp.graphics.endFill();
        _sp.alpha = 0.5;
        addChild(_sp);
    }
}


import flash.display.Sprite;
import flash.events.Event;

class Particle extends Sprite {
    
    private var _ball:Ball;
    private var _x:Number;
    private var _y:Number;
    private var _vx:Number;
    private var _vy:Number;
    private var _ay:Number;
    
    public function Particle(xx:Number, yy:Number, vx:Number, vy:Number, ay:Number) {
        
        _x = xx;
        _y = yy;
        _vx = vx;
        _vy = vy;
        _ay = ay;
        
        init();
    }
    
    private function init():void {
        
        _ball = new Ball(Math.random() * 10, Math.random()*0xffffff);
        _ball.x = _x;
        _ball.y = _y;
        addChild(_ball);
        _ball.addEventListener(Event.ENTER_FRAME, onLoop);
    }
    
    private function onLoop(e:Event):void {    
        _ball.x += _vx;
        _ball.y += _vy;
        _vy += _ay;
        
        if (_ball.x > 550 || _ball.x < 0 || _ball.y > 400 || _ball.y < 0) {
            _ball.removeEventListener(Event.ENTER_FRAME, onLoop);
            removeChild(_ball);
            _ball = null;
        }
    }
}


import flash.display.Sprite;
import flash.events.Event;
import flash.events.TimerEvent;
import flash.utils.Timer;

class ParticleMove extends Sprite {
    
    private var _p:Particle;
    private var _x:Number;
    private var _y:Number;
    private var _timer:Timer;
    
    public function ParticleMove(xx:Number, yy:Number) {
        _x = xx;
        _y = yy;
        
        init();
    }
    
    private function init():void  {
        _timer = new Timer(200);
        _timer.addEventListener(TimerEvent.TIMER, onLoop);
        _timer.start();
        
    //    addEventListener(Event.ENTER_FRAME, onLoop);
    }
    
    private function onLoop(e:Event):void {
        _p = new Particle(_x, _y,  2 - Math.random()* 3, 3 - Math.random()* 3, Math.random()*2);
        addChild(_p);    
    }
    
    public function set yPos(val:Number):void {
        _y = val;
    }
}