/**
 * Copyright alotfuck ( http://wonderfl.net/user/alotfuck )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/sina
 */

package {

    import flash.display.*;
    import flash.events.*;
    import flash.filters.*;
    import frocessing.color.*;
    
    /**
     * Original Code at Processing 
     * Plasma Demo Effect by luis2048. 
     */
    public class FlashTest extends Sprite {
       
        private var pixelSize:Number=10;
        private var pg:BitmapData;
        private var pg2:BitmapData;

        private var frameCountX:Number=0;
        private var frameCountY:Number=0;
        
        private var bt2:Bitmap;
        private var count:Number=0;
        
        private var blendMode_ary:Array=[
        BlendMode.ADD,
        BlendMode.INVERT,
        BlendMode.DARKEN,
        BlendMode.ERASE,
        BlendMode.HARDLIGHT,
        BlendMode.ERASE,
        BlendMode.LAYER,
        BlendMode.LIGHTEN,
        BlendMode.MULTIPLY,
        BlendMode.OVERLAY,
        BlendMode.SCREEN,
        BlendMode.SUBTRACT];
 
        public function FlashTest() {
            setup();
        }

        private function setup() :void{
	    pg = new BitmapData(30, 30);
            pg2 = new BitmapData(30, 30);
            
	    var bt:Bitmap=new Bitmap(pg);
	    bt2=new Bitmap(pg2);

	    addChild(bt);
	    addChild(bt2);

	    bt2.blendMode=BlendMode.HARDLIGHT;
	    bt.filters=bt2.filters=[new BlurFilter(32,64,1)];
	    bt.width=bt2.width=stage.stageWidth;
	    bt.height=bt2.height=stage.stageHeight;
	    addEventListener(Event.ENTER_FRAME , draw);
            stage.addEventListener(MouseEvent.MOUSE_UP,onMouseUp);
        }

        private function draw(evt:Event):void{
	    frameCountX+=8;
	    frameCountY+=2;

	    var xc:Number=5;
	    var calculation1:Number = Math.sin( (frameCountX * 0.61655617)/180*Math.PI);
	    var calculation2:Number = Math.sin( (frameCountY * -3.6352262)/180*Math.PI);
	    for (var x:int = 0; x < pg.width; x++, xc += pixelSize) {
		var yc:Number = 40;
		var s1:Number = 128 + 128 * Math.sin((xc)/180*Math.PI * calculation1 );
		for (var y:int = 0; y < pg.height; y++, yc += pixelSize) {
		    var s2:Number = 128 + 128 * Math.sin((yc)/180*Math.PI * calculation2 );
		    var s3:Number = 128 + 128 * Math.sin(((xc + yc + frameCountX * 5)/180*Math.PI / 2));
		    var s :Number = (s1+ s2 + s3) *0.4;
		    pg.setPixel(x,y,new ColorHSV(s/300*360 , s/50  , 1).value);
		    pg2.setPixel(pg2.width-x-1,pg2.height-y-1,new ColorHSV(s/200*360 , s  , 1).value);
		}
	    }
        }
        
        private function onMouseUp(evt:MouseEvent):void{
	    bt2.blendMode=blendMode_ary[count];
	    if(blendMode_ary.length<=++count)count=0;
        }
    }
}