/**
 * Copyright uwi ( http://wonderfl.net/user/uwi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/si6M
 */

package {
    import flash.display.Sprite;
    import flash.text.TextField;
    import flash.utils.getTimer;
    // @see http://projecteuler.net/index.php?section=problems&id=171
    public class Euler171 extends Sprite {
        private var _tf : TextField;
  
        public function Euler171() {
            _tf = new TextField();
            _tf.width = 465;
            _tf.height = 465;
            addChild(_tf);
            
            var s : int = getTimer();
            tr(solve(20));
            var g : int = getTimer();
            tr((g - s) + " ms");
        }

        // 下の桁から二乗和のテーブルを足していく。
        // 和を求めるため、個数テーブルも途中まで必要。
        private function solve(N : uint) : Number
        {
        		var a : Array = new Array(81 * N + 1);
        		var i : uint, j : uint, k : Number, l : uint;
        		// index:二乗和, [0]:個数, [1]:和
        		for(i = 0;i < a.length;i++)a[i] = [0, 0];
        		a[0] = [1, 0];
        		
        		for(j = 0, k = 1;j < N;j++, k*=10){
	        		var n : Array = new Array(81 * N + 1);
	        		for(i = 0;i < n.length;i++)n[i] = [0, 0];
	        		
	        		for(i = 0;i <= 81 * j;i++){
	        			for(l = 0;l <= 9;l++){
	        				if(k > 1E9){
	        					n[i+l*l][1] += a[i][1];
	        				}else{
		        				n[i+l*l][0] += a[i][0];
		        				n[i+l*l][1] += a[i][1] + ((l * k * a[i][0]) % 1E9);
	        				}
	        				n[i+l*l][1] %= 1E9;
	        			}
	        		}
	        		a = n;
        		}
        		
        		// 二乗和が平方数になるやつだけ足す
        		var sum : uint = 0;
        		for(i = 0;i * i <= 81 * N;i++){
        			sum += a[i*i][1];
        			sum %= 1E9;
        		}
        		return sum;
        }

        private function tr(...o : Array) : void
        {
            _tf.appendText(o + "\n");
            _tf.scrollV = _tf.maxScrollV;
        }
    }
}