/**
 * Copyright Mr.Star ( http://wonderfl.net/user/Mr.Star )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/shqi
 */

package   
{  
    import flash.display.Sprite;  
    import flash.display.MovieClip;  
    import flash.text.TextField;  
    import flash.events.MouseEvent;  
 
    public class Main extends Sprite  
    {  
 
        private var num:int = 16;  
        private var id:Array=new Array();  
        private var box:Array=new Array();  
        private var tempPic:*,p1:int,p2:int;//用来标记被拖动的图片和目的  
          
        public function Main()  
        {  
            createBox();  
            setPosition();  
        }  
        private function createBox():void
        {  
            var i:int = 0,j:int = 0;  
            for (i; i<num; i++)  
            {  
                id[i] = new Array(int(i / 4),i % 4);//基本排列算法  
                  
                var pic:MovieClip = new MovieClip  ;  
                pic.graphics.beginFill(0xcc9900+16*i,1);  
                pic.graphics.drawRect(-25,-25,50,50);  
                pic.graphics.endFill();  
                  
                var txt:TextField=new TextField();  
                txt.height = 50;  
                txt.width = 50;  
                txt.x = -25;  
                txt.y = -25;  
                txt.text = i + "\n" + id[i][0] + "," + id[i][1];  
                txt.scaleX=txt.scaleY=1.5  
                txt.selectable = false;  
                  
                addChild(pic);  
                pic.addChild(txt);  
                box.push(pic);  
                pic.mouseChildren = false;//不然文本框会影响MouseEvent。  
                this.addEventListener(MouseEvent.MOUSE_UP,mouseup)  
            }  
        }  
        private function setPosition():void  
        {  
            var i:int = 0;  
            for (i; i<num; i++)  
            {  
                box[i].x = id[i][1] * 100 + 50;  
                box[i].y = id[i][0] * 100 + 50;  
                box[i].n=i;//手动添加属性n来标记哪块pic被点击了。  
                box[i].addEventListener(MouseEvent.MOUSE_DOWN,mousedown);  
            }  
        }  
        private function mousedown(e:MouseEvent):void  
        {
            tempPic=e.target;  
            p1=tempPic.n;//记下当前按下鼠标的那个方块序号p1  
            tempPic.startDrag();  
        }  
        private function mouseup(e:MouseEvent):void{  
            tempPic.stopDrag();  
            //这个鼠标位置判断很关键:  
            var tx:int=int((mouseX)/100);  
            var ty:int=int((mouseY)/100);  
            var i:int=0;  
            for(i;i<num;i++){  
                if(id[i][0]==ty && id[i][1]==tx){  
                    p2=i;//记下鼠标放开所在位置的序号p2，可能这个比较不容易想到。  
                }  
            }  
            //这样一来就取得了被拖动pic的序号p1以及目的序号p2,于是就方便了对id数组的变换。  
            changePicArray();  
        }  
        private function changePicArray():void{  
            //调换pic在box中的序列:  
            var i:int,temp:*;  
            if(p1<p2){  
                temp =box[p1];  
                for(i=p1;i<p2;i++){  
                    box[i]=box[i+1];  
                }  
                box[p2]=temp;  
            }else if(p1>p2){  
                temp=box[p1];  
                for(i=p1;i>p2;i--){  
                    box[i]=box[i-1];  
                }  
                box[p2]=temp;  
            }  
            setPosition();  
        }  
 
    }  
 
} 