/**
 * Copyright itsukichang ( http://wonderfl.net/user/itsukichang )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/shm8
 */

package {
    
    import flash.display.Sprite;    
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.TimerEvent;
    import flash.utils.Timer;
    import flash.events.MouseEvent;
    
    public class ParticleClock extends Sprite {
        
        private var _clock:Array;
        private var _colon:Array;
        private var _p:ParticleEffect;
        private var _timer:Timer;
        
        private var sec1:uint; //10の位
        private var sec2:uint; //1の位
        private var min1:uint;
        private var min2:uint;
        private var hour1:uint;
        private var hour2:uint;

        public function ParticleClock() {
            
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            
            _clock = new Array;
            _colon = new Array;
            var cnt:uint = 0;
            for (var i:uint = 0; i < 6; i++) {    
                if (i == 2 || i == 4) {
                    _p = new ParticleEffect(55,55,":");
                    _p.x = i * 50 + cnt * 40 + 50;
                    _p.y = stage.stageHeight / 2;
                    _p.nowFontSize = 60;
                    cnt++;
                    _colon.push(_p)
                    addChild(_p);
                }
                
                _p = new ParticleEffect(55,55);
                _clock.push(_p);
                _clock[i].x = i * 50 + cnt * 40 + 50;
                _clock[i].y = stage.stageHeight / 2;
                _clock[i].nowNum = i;
                addChild(_clock[i]);
            }
            _timer = new Timer(1000);
            _timer.addEventListener(TimerEvent.TIMER, onLoop);
            _timer.start();
            stage.addEventListener(MouseEvent.CLICK, onClick);
        }
        
        private function onLoop(e:TimerEvent):void {
            var now:Date = new Date();
            var nowSec:Number = now.getSeconds();
            var nowMin:Number = now.getMinutes();
            var nowHour:Number = now.getHours();
                        
            sec1  = (nowSec / 10); //10の位
            sec2  = (nowSec % 10); //1の位
            min1  = (nowMin / 10);
            min2  = (nowMin % 10);
            hour1 = (nowHour / 10);
            hour2 = (nowHour % 10);
                
            if (sec2 != _clock[5].nowNum)
                _clock[5].nowNum = (sec2 % 10);
                
            if (sec1 != _clock[4].nowNum)
                _clock[4].nowNum = (sec1 % 10);
                
            if (min2 != _clock[3].nowNum)
                _clock[3].nowNum = (min2 % 10);
                
            if (min1 != _clock[2].nowNum)
                _clock[2].nowNum = (min1 % 10);
            
            if (hour2 != _clock[1].nowNum)
                _clock[1].nowNum = (hour2 % 10);
                
            if (hour1 != _clock[0].nowNum)
                _clock[0].nowNum = (hour1 % 10);
        }
        
        private function onClick(e:MouseEvent):void {
            var col:uint = 0xffffff * Math.random();
            for (var i:uint = 0; i < 6; i++) {
                _clock[i].nowFontColor = col;
            }
        }
    }    
}

import flash.display.Sprite;    
import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.events.TimerEvent;
import flash.utils.Timer;
import flash.filters.ColorMatrixFilter;
import flash.geom.Rectangle;
import flash.text.TextField;
import flash.text.TextFieldAutoSize;
import flash.text.TextFormat;

class ParticleEffect extends Sprite{
    
    private var _w:Number;
    private var _h:Number;
    private var _canvas:BitmapData;
    private var _textCanvas:BitmapData;
    private var _particles:Array;
    private var _p_num:int;
    private var _textAry:Array;
    private var _index:uint = 0;
    
    private var _maxDix:int = 100;
    private var _timer:Timer;
    
    private var _color:uint;
    private var _size:uint;
            
    public function ParticleEffect(w:Number, h:Number, s:String = "0") {
        _w = w;
        _h = h;
        _size = 70;
        _color = 0xffffff
        _canvas = new BitmapData(_w, _h, false, 0x0);
        addChild(new Bitmap(_canvas));
        
        _textAry = new Array; 
        for ( var i:uint = 0; i < 1; i++)
            _textAry[i] = new Array(2);  //2次元配列，1次元目には文字列を．2次元目にはフォントサイズを.
            
        _textAry[0][0] = s;
        _textAry[0][1] = _size;
        
        init(_textAry[0][0], _textAry[0][1], _color);
        _timer = new Timer(33);
        _timer.addEventListener(TimerEvent.TIMER, onLoop);
        _timer.start();
    }
    
    private function init(st:String, size:uint, col:uint):void {

        var tf:TextField = new TextField;
        tf.defaultTextFormat = new TextFormat("Times", size, col);
        tf.autoSize = TextFieldAutoSize.LEFT;
        tf.text = st;
        
        _textCanvas = new BitmapData(tf.textWidth, tf.textHeight, false, 0x000000);
        _textCanvas.draw(tf);
        _particles = new Array();
        
        createText();
    }
    
    private function createText():void {
        
        var ofx:Number = _w / 2 - _textCanvas.width / 2;
        var ofy:Number = _h / 2 - _textCanvas.height / 2;
        
        for (var ex:uint = 0; ex < _textCanvas.width; ex++) {
            for (var ey:uint = 0; ey < _textCanvas.height; ey++) {
                var c:uint = _textCanvas.getPixel(ex, ey);
                
                if(c != 0x000000)
                    createParticle(ex + ofx, ey + ofy, c);
            }
        }
    } 
    
    private function createParticle(ex:Number, ey:Number, col:Number):void {
        var p:Particle = new Particle;
        
        p.ex = ex;
        p.ey = ey;
        p.col  = col;
        
        initParticle(p);
        _particles.push(p);
        _p_num = 0;
    }
    
    public function initParticle(p:Particle):void {
        var rad:Number = Math.random() * Math.PI * 2;
        var dis:Number = Math.random() * _maxDix;
        p.x = p.ex + dis * Math.cos(rad);
        p.y = p.ey + dis * Math.sin(rad);
    }
    
    private function onLoop(e:TimerEvent):void {
        _canvas.lock();
        _canvas.fillRect(_canvas.rect, 0x0);
        
        for (var i:uint = 0; i < _p_num; i++) {
            var p:Particle = _particles[i];
            if (Math.abs(p.ex - p.x) < 0.5 && Math.abs(p.ey - p.y) < 0.5) {
                p.x = p.ex;
                p.y = p.ey;
            } else { 
                p.x += (p.ex - p.x) / 2;
                p.y += (p.ey - p.y) / 2;
            }
            
            _canvas.setPixel(p.x, p.y, p.col);
        }
        
        var n:uint = _particles.length;
        _p_num = (_p_num + 500 < n) ? _p_num + 500 : n;
        
        _canvas.unlock();
    }
    
    public function get nowNum():uint {
        return _textAry[0][0];
    }
    
    public function set nowNum(n:uint):void {
        _textAry[0][0] = n.toString();
        init(_textAry[0][0], _textAry[0][1], _color);
    }
    
    public function get nowFontSize():uint {
        return _textAry[0][1];
    }
    
    public function set nowFontSize(n:uint):void {
        _size = n;
        _textAry[0][1] = _size;
        init(_textAry[0][0], _textAry[0][1], _color);
    }
    
    public function get nowFontColor():uint {
        return _color;
    }
    
    public function set nowFontColor(col:uint):void {
        _color = col;
        init(_textAry[0][0], _textAry[0][1], _color);
    }
}

class Particle {
    public var x:Number;
    public var y:Number;
    public var ex:Number;
    public var ey:Number;
    public var col:int;
    
    public function Particle() {
        x = 0;
        y = 0;
        ex = 0;
        ey = 0;
        col = 0;
    }
}