/**
 * Copyright sakusan393 ( http://wonderfl.net/user/sakusan393 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/shjC
 */

// forked from leichtgewicht's forked from: Papervision3Dでマウスイベントを設定する（1）
// forked from kamipoo's Papervision3Dでマウスイベントを設定する（1）
/**
 * Papervision3D で マウスイベント を設定する（1）
 * プリミティブ に マウスイベント を設定する方法
 */
package
{
    import com.bit101.components.TextArea;
    
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    
    import org.libspark.betweenas3.BetweenAS3;
    import org.libspark.betweenas3.tweens.ITween;
    import org.papervision3d.cameras.Camera3D;
    import org.papervision3d.core.proto.MaterialObject3D;
    import org.papervision3d.events.InteractiveScene3DEvent;
    import org.papervision3d.materials.ColorMaterial;
    import org.papervision3d.objects.DisplayObject3D;
    import org.papervision3d.objects.primitives.Plane;
    import org.papervision3d.render.BasicRenderEngine;
    import org.papervision3d.scenes.Scene3D;
    import org.papervision3d.view.Viewport3D;
    
    [SWF(backgroundColor="#FFFFFF", width="465", height="465", frameRate="30")]
    public class PV3DMouseEvent1 extends Sprite
    {
        
        //PV3Dに使用する変数
        protected var _scene:Scene3D;
        protected var _viewport:Viewport3D;
        protected var _renderer:BasicRenderEngine;
        protected var _camera:Camera3D;
        
        protected var _overStage:Boolean = false;
        
        private var _primitive2:Plane;
        
        //表示に使用するマテリアルを格納する変数
        protected var _material:MaterialObject3D;
        
        //表示するプリミティブ（Plane：板、Cube：立方体 など）を格納する変数
        protected var _primitive:DisplayObject3D;
        
        public function PV3DMouseEvent1()
        {
            super();
            
            //3D表示に必要なクラスを初期化します
            _init3D();
            
            //3D表示に必要な情報を設定します
            _setup3D();
            
            //3D空間に追加するオブジェクトを生成します
            _initObject();
            
            //生成したオブジェクトに マウスイベント を設定します
            _setupObject();
            
            //毎フレーム レンダリングを行います。
            addEventListener( Event.ENTER_FRAME, _enterframeHandler );
            
            
            //ログ出力を初期化します（無視して結構です。）
            _initLogger();
        }
        
        /**
         * PV3Dでボタンを使えるようにセットアップします。
         */
        protected function _setup3D():void
        {
            //Viewport3D の interactive プロパティを true に設定します。
            //※Viewport3D の コンストラクタ の 第4引数 を true に設定してもよい
            _viewport.interactive = true;
        }
        
        /**
         * PV3Dのオブジェクトを追加します。
         */
        protected function _initObject():void
        {
            _material = new ColorMaterial( 0x000000, 1, false );
            
            //マテリアルの interactive プロパティを true に設定します。
            _material.interactive = false;
            
            //裏面の描画を有効化します。
            _material.doubleSided = true;
            
            //今回は Plane を追加します。
            _primitive = new Plane( _material, 100, 100, 1, 1 );
            
            var m2:ColorMaterial = new ColorMaterial(0xFF0000,1,false)
            m2.interactive = true;
            _primitive2 = new Plane(m2,50,50);
            _primitive2.z = -1;
            
            //シーンに追加します。
            _scene.addChild( _primitive );
            
            _scene.addChild(_primitive2);
            
            //3Dなのでオブジェクトを回転させておきます。
            var t:ITween = BetweenAS3.to(_primitive, {rotationY: 360}, 10);
            t.stopOnComplete = false;
            //t.play();
        }
        
        /**
         * PV3Dに追加したオブジェクトにマウスイベントを設定します
         */
        protected function _setupObject():void
        {
            //InteractiveScene3DEvent を使って マウスイベント を設定します。
            //PV3Dを使う上で一番基本となる設定の仕方かと思います。
            _primitive.addEventListener( InteractiveScene3DEvent.OBJECT_OVER, _logEvent );
            _primitive.addEventListener( InteractiveScene3DEvent.OBJECT_OUT, _logEvent );
            _primitive.addEventListener( InteractiveScene3DEvent.OBJECT_CLICK, _logEvent );
        }
        
        /**
         * オブジェクトをクリックした時に発生するイベント
         */
        protected function _logEvent(e:Event):void
        {
            //Viewport3D の buttonMode を true 設定すると
            //Viewport3D に描画されているすべてのオブジェクトにオンマウスで指アイコンになってしまうので、
            //Viewport3D の buttonMode を イベントタイプによって切り替える
            switch( e.type) {
                //case InteractiveScene3DEvent.OBJECT_OVER: 
                //case MouseEvent.ROLL_OVER: _viewport.buttonMode = true; break;
                //case InteractiveScene3DEvent.OBJECT_OUT: 
                //case MouseEvent.ROLL_OUT: _viewport.buttonMode = false; break;
                default: break;
            }
            
            //出力する
            log( e.type );
        }
        
        /**
         * PV3Dを初期化します。
         */
        protected function _init3D():void
        {
            _scene = new Scene3D();
            _viewport = new Viewport3D( stage.stageWidth-50, stage.stageHeight - 200, false, false, true, true );
            _viewport.interactive = true;
            _viewport.addEventListener(MouseEvent.ROLL_OUT, outHandler);
            _viewport.interactiveSceneManager.addEventListener(InteractiveScene3DEvent.OBJECT_MOVE, _handleOver);
            _renderer = new BasicRenderEngine();
            _camera = new Camera3D();
            _camera.z = -(_camera.zoom * _camera.focus);
            addChild( _viewport );
        }
        private function outHandler(e:MouseEvent):void
        {
            log("out");
        }

        
        protected function _handleOver(e:InteractiveScene3DEvent):void
        {
            
            var overStage:Boolean = true;
            if(e.renderHitData != null)
            {
                overStage = !e.renderHitData.hasHit || e.renderHitData.displayObject3D == _primitive;
                
            }
            if(overStage != _overStage)
            {
                _overStage = overStage;
                log("I am  now "+(overStage?"over":"out of")+" the stage!!!");
            }
        }

        
        /**
         * PV3Dを描画します。
         */
        protected function _render():void
        {
            _renderer.renderScene( _scene, _camera, _viewport );
        }
        
        
        protected function _enterframeHandler(e:Event):void
        {
            _render();
        }
        
        
        
        
        
        
        
        
        
        protected var _logger:TextArea;
        
        protected function _initLogger():void
        {
            _logger = new TextArea(this, 0, stage.stageHeight - 101, "");
            _logger.width = stage.stageWidth;
            _logger.height = 100;
        }
        
        public function log(msg:String):void
        {
            if(_logger.text != "") msg = msg + "\n";
            _logger.text = msg + _logger.text;
        }
    }
}