/**
 * Copyright _ueueueueue ( http://wonderfl.net/user/_ueueueueue )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/shYr
 */

package 
{
	import flash.display.*;
	import flash.events.*;
	import flash.geom.*;
	import flash.text.*;
	import flash.ui.*;
	
	//描画まで時間かかります
	//パラメーターはテキトーです
	[SWF(width=465,height=465,backgroundColor=0xFFFFFF)]
	
	/**
	 * ...
	 * @author ue
	 */
	
	public class Main extends Sprite 
	{
		private const NUM_PARTICLE:int = 1000;
		
		private var canvas:BitmapData;
		private var particles:Vector.<Particle>;
		private var parts:Shape;
		private var tmp:Number;
		
		private var damp:Number = 0.98;
		private var accel:Number = 10;
		private var rad:Number;
		private var dRad:Number;
		
		public function Main():void 
		{
			stage.scaleMode = StageScaleMode.NO_SCALE;
			stage.align = StageAlign.TOP_LEFT;
            	Wonderfl.capture_delay( 50 );
			
			canvas = new BitmapData(465, 465, false, 0x0);
			addChild(new Bitmap(canvas)) as Bitmap;
			
			parts = new Shape();
			parts.graphics.beginFill(0xffffff,.3);
			parts.graphics.drawCircle(0, 0, 0.5);
			tmp = 0;

			addEventListener(Event.ENTER_FRAME, update);
			stage.addEventListener(MouseEvent.CLICK, reset);
			
			reset();
		}
		
		private function reset(e:MouseEvent = null):void
		{
			canvas.fillRect(canvas.rect, 0x0);
			tmp = Math.random() * 200 + 300;
			
			particles = new Vector.<Particle>(NUM_PARTICLE, true);
			for (var i:int = 0; i < NUM_PARTICLE; i++) 
			{
				var p:Particle = new Particle();
				p.x = Math.random() * 465;
				p.y = Math.random() * 465;
				p.vx = Math.random() * accel - accel / 2;
				p.vy = Math.random() * accel - accel / 2;
				particles[i] = p;
			}
		}
		
		private function update(e:Event):void 
		{
			canvas.lock();
			for (var i:int = 1; i < NUM_PARTICLE; i++) 
			{
				var p:Particle = particles[i] as Particle;
				p.vx += Math.sin(tmp * 0.00002) - (particles[i - 1].y / 15000);
				p.vy += Math.sin(tmp * 0.00002) - (particles[i - 1].x / 15000);
				p.x += p.vx;
				p.y += p.vy;
				p.vx *= damp;
				p.vy *= damp;
				
				if (p.x < 0) p.x = stage.stageWidth;
				else if (p.x > stage.stageWidth) p.x = 0;
				if (p.y < 0) p.y = stage.stageHeight;
				else if (p.y > stage.stageHeight) p.y = 0;

				var m:Matrix = new Matrix();
				m.translate(p.x, p.y);
				var color:ColorTransform = new ColorTransform(Math.sin(p.x/5), Math.sin(p.y/5), Math.sin(p.x), 1);
				canvas.draw(parts, m,color,BlendMode.ADD);
			}
			canvas.unlock();
		}
	}
}

class Particle
{
	public var x:Number;
	public var y:Number;
	public var vx:Number;
	public var vy:Number;
	
	public function Particle(){}
}