/**
 * Copyright minodisk ( http://wonderfl.net/user/minodisk )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/shJ2
 */

package  
{
	import com.flashdynamix.utils.SWFProfiler;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.filters.GlowFilter;
	import org.papervision3d.cameras.Camera3D;
	import org.papervision3d.events.InteractiveScene3DEvent;
	import org.papervision3d.materials.ColorMaterial;
	import org.papervision3d.materials.special.CompositeMaterial;
	import org.papervision3d.materials.WireframeMaterial;
	import org.papervision3d.objects.primitives.Plane;
	import org.papervision3d.render.BasicRenderEngine;
	import org.papervision3d.scenes.Scene3D;
	import org.papervision3d.view.Viewport3D;
	
	/**
	 * 解説 http://ferv.jp/blog/2009/11/11/displayobject3d-buttonmode/
	 * 
	 * @langversion ActionScript 3.0
	 * @playerversion Flash 9.0
	 * 
	 * @author dsk
	 * @since 2009/11/11
	 */
	[SWF(backgroundColor = '0x000000', width = '465', height = '465', frameRate = '30')]
	public class PV3DButtonMode extends Sprite 
	{
		
		//--------------------------------------
		// CLASS CONSTANTS
		//--------------------------------------
		
		
		//--------------------------------------
		// PRIVATE VARIABLES
		//--------------------------------------
		
		private var _render:BasicRenderEngine;
		private var _scene:Scene3D;
		private var _camera:Camera3D;
		private var _viewport:Viewport3D;
		
		private var _buttonModePlane:ExtPlane;
		private var _normalPlane:ExtPlane;
		
		
		//--------------------------------------
		// GETTER/SETTERS
		//--------------------------------------
		
		
		//--------------------------------------
		// CONSTRUCTOR
		//--------------------------------------
		
		public function PV3DButtonMode() 
		{
			SWFProfiler.init(this);
			
			_render = new BasicRenderEngine();
			_scene = new Scene3D();
			_camera = new Camera3D();
			_viewport = new Viewport3D(stage.stageWidth, stage.stageHeight, false, true);
			addChild(_viewport);
			
			graphics.beginFill(0x000000, 1);
			graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
			graphics.endFill();
			
			var blueMaterial:CompositeMaterial = new CompositeMaterial();
			blueMaterial.addMaterial(new ColorMaterial(0x4697CE, 0.9));
			blueMaterial.addMaterial(new WireframeMaterial(0x4697CE, 1, 1));
			blueMaterial.doubleSided = true;
			blueMaterial.interactive = true;
			_buttonModePlane = new ExtPlane(blueMaterial, 300, 300, 1, 1);
			_buttonModePlane.buttonMode = true;
			_buttonModePlane.useOwnContainer = true;
			_buttonModePlane.x = -250;
			_buttonModePlane.addEventListener(InteractiveScene3DEvent.OBJECT_OVER, _onObjectOver);
			_buttonModePlane.addEventListener(InteractiveScene3DEvent.OBJECT_OUT, _onObjectOut);
			_scene.addChild(_buttonModePlane);
			
			var redMaterial:CompositeMaterial = new CompositeMaterial();
			redMaterial.addMaterial(new ColorMaterial(0xFF3B9A, 0.9));
			redMaterial.addMaterial(new WireframeMaterial(0xFF3B9A, 1, 1));
			redMaterial.doubleSided = true;
			redMaterial.interactive = true;
			_normalPlane = new ExtPlane(redMaterial, 300, 300, 1, 1);
			_normalPlane.useOwnContainer = true;
			_normalPlane.x = 250;
			_normalPlane.addEventListener(InteractiveScene3DEvent.OBJECT_OVER, _onObjectOver);
			_normalPlane.addEventListener(InteractiveScene3DEvent.OBJECT_OUT, _onObjectOut);
			_scene.addChild(_normalPlane);
			
			addEventListener(Event.ENTER_FRAME, _onEnterFrame);
		}
		
		
		//--------------------------------------
		// PUBLIC METHODS
		//--------------------------------------
		
		
		//--------------------------------------
		// PRIVATE METHODS
		//--------------------------------------
		
		private function _onObjectOver(e:InteractiveScene3DEvent):void 
		{trace(e);
			var extPlane:ExtPlane = e.currentTarget as ExtPlane;
			extPlane.filters = [new GlowFilter(0xFFFFFF, 1, 10, 10, 2, 1, false ,false)];
		}
		
		private function _onObjectOut(e:InteractiveScene3DEvent):void 
		{trace(e);
			var extPlane:ExtPlane = e.currentTarget as ExtPlane;
			extPlane.filters = [];
		}
		
		private function _onEnterFrame(e:Event):void 
		{
			_buttonModePlane.rotationY ++;
			_normalPlane.rotationY = _buttonModePlane.rotationY;
			
			_render.renderScene(_scene, _camera, _viewport);
		}
		
		
	}
	
	
}
	
	
	
	import flash.ui.Mouse;
	import flash.ui.MouseCursor;
	import org.papervision3d.core.proto.MaterialObject3D;
	import org.papervision3d.events.InteractiveScene3DEvent;
	import org.papervision3d.objects.primitives.Plane;
	
	internal class ExtPlane extends Plane 
	{
		private var _buttonMode:Boolean;
		
		public function get buttonMode():Boolean { return _buttonMode; }
		public function set buttonMode(value:Boolean):void 
		{
			_buttonMode = value;
			
			if (_buttonMode) {
				addEventListener(InteractiveScene3DEvent.OBJECT_OVER, _onObjectOver);
				addEventListener(InteractiveScene3DEvent.OBJECT_OUT, _onObjectOut);
			} else {
				_onObjectOut();
				
				removeEventListener(InteractiveScene3DEvent.OBJECT_OVER, _onObjectOver);
				removeEventListener(InteractiveScene3DEvent.OBJECT_OUT, _onObjectOut);
			}
		}
		
		public function ExtPlane(material:MaterialObject3D, width:Number = 0, height:Number = 0, segmentsW:Number = 0, segmentH:Number = 0) 
		{
			super(material, width, height, segmentsW, segmentH);
			_buttonMode = false;
		}
		
		private function _onObjectOver(e:InteractiveScene3DEvent):void 
		{
			Mouse.cursor = MouseCursor.BUTTON;
		}
		
		private function _onObjectOut(e:InteractiveScene3DEvent = null):void 
		{
			Mouse.cursor = MouseCursor.AUTO;
		}
		
		
	}









