/**
 * Copyright beinteractive ( http://wonderfl.net/user/beinteractive )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/shHm
 */

package
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.DisplayObject;
    import flash.display.Graphics;
    import flash.display.Loader;
    import flash.display.LoaderInfo;
    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.display.StageQuality;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.Matrix;
    import flash.net.URLRequest;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import flash.text.TextFormat;
    
    [SWF(width = 456, height = 456, frameRate = 30, bakcgroundColor = 0xffffff)]
    public class WonderflUmareruWanco extends Sprite
    {
        // ウンコSWF URL
        protected static const UNKO_URL:String = 'http://swf.wonderfl.net/static/assets/checkmate05/wancoProfessional.swf';
        
        // テクスチャサイズ
        protected static const TEXTURE_SIZE:uint = 70 * 2.0;
        // テクスチャ分割数
        protected static const TEXTURE_SPLIT:uint = 10;
        
        public function WonderflUmareruWanco()
        {
            // 設定
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.quality = StageQuality.MEDIUM;
            
            // ウンコロード
            var loader:Loader = new Loader();
            loader.contentLoaderInfo.addEventListener(Event.COMPLETE, loadCompleteHandler);
            loader.load(new URLRequest(UNKO_URL));
        }
        
        /**
         * テクスチャ.
         */
        protected var texture:BitmapData;
        
        /**
         * キャンバス.
         */
        protected var canvas:Shape;
        
        /**
         * マウスが押されているか?
         */
        protected var isPressed:Boolean;
        
        /**
         * 生まれ具合.
         */
        protected var phase:Number;
        protected var vp:Number;
        
        /**
         * 頂点データ.
         */
        protected var vertices:Vector.<Number>;
        
        /**
         * 元の頂点データ.
         */
        protected var originalVertices:Vector.<Number>;
        
        /**
         * 頂点インデックス.
         */
        protected var indices:Vector.<int>;
        
        /**
         * テクスチャUV.
         */
        protected var uvData:Vector.<Number>;
        
        /**
         * ウンコロード完了.
         */
        protected function loadCompleteHandler(e:Event):void
        {
            // 後始末
            var loaderInfo:LoaderInfo = e.target as LoaderInfo;
            loaderInfo.removeEventListener(Event.COMPLETE, loadCompleteHandler);
            
            // ウンコクラス取り出し
            var unkoClass:Class = loaderInfo.applicationDomain.getDefinition('WakeMotion') as Class;
            
            // テクスチャ生成
            texture = makeTexture(new unkoClass(), 35, 55, TEXTURE_SIZE, 2.0);
            
            // 頂点データなど
            originalVertices = makeVertices(TEXTURE_SIZE, TEXTURE_SPLIT);
            vertices = makeVertices(TEXTURE_SIZE, TEXTURE_SPLIT);
            indices = makeIndices(TEXTURE_SPLIT);
            uvData = makeUvData(TEXTURE_SPLIT);
            phase = 0.0;
            
            // ヒットエリア
            var s:Sprite = new Sprite();
            s.graphics.beginFill(0xffffff);
            s.graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
            s.graphics.endFill();
            
            // 指カーソル他ボタン設定
            s.buttonMode = true;
            s.useHandCursor = true;
            s.mouseChildren = false;
            addChild(s);
            
            // *
            var f:Sprite = new Sprite();
            f.x = mouseX;
            f.y = mouseY;
            f.mouseChildren = false;
            f.mouseEnabled = false;
            addChild(f);
            var field:TextField = new TextField();
            field.defaultTextFormat = new TextFormat('Arial', 72, 0x000000, true);
            field.autoSize = TextFieldAutoSize.LEFT;
            field.text = '*';
            field.selectable = false;
            field.x = field.textWidth / -2.0;
            // field.y = -field.textHeight;
            f.addChild(field);
            f.startDrag();
            
            // キャンバス
            canvas = new Shape();
            addChild(canvas);
            
            // マウスイベント
            stage.addEventListener(MouseEvent.MOUSE_DOWN, mouseDownHandler);
            stage.addEventListener(MouseEvent.MOUSE_UP, mouseUpHandler);
            
            // フレームイベント
            addEventListener(Event.ENTER_FRAME, enterFrameHandler);
        }
        
        /**
         * <code>image</code> を元に生成したテクスチャ.
         * 
         * @param    image    元画像
         * @param    x    中心X
         * @param    y    中心Y
         * @param    size    画像サイズ
         * @return    生成されたテクスチャ
         */
        protected function makeTexture(image:DisplayObject, x:int, y:int, size:Number, scale:Number):BitmapData
        {
            var texture:BitmapData = new BitmapData(size, size, true, 0x00000000);
            var m:Matrix = new Matrix();
            
            m.translate(x, y);
            m.scale(scale, scale);
            
            texture.draw(image, m);
            
            return texture;
        }
        
        /**
         * <code>size</code> ピクセルの正方形を分割数 <code>split</code> で描画するための頂点データ.
         * 
         * @param    size    正方形のサイズ
         * @param    split    分割数
         * @return    頂点データ.
         */
        protected function makeVertices(size:Number, split:uint):Vector.<Number>
        {
            var seg:Number = size / Number(split);
            
            var v:Vector.<Number> = new Vector.<Number>((split + 1) * (split + 1) * 2);
            
            var i:uint;
            for (var x:uint = 0; x <= split; ++x) {
                for (var y:uint = 0; y <= split; ++y) {
                    i = (y * (split + 1) + x) * 2;
                    v[i + 0] = seg * x;
                    v[i + 1] = seg * y;
                }
            }
            
            return v;
        }
        
        /**
         * 分割数 <code>split</code> の四角形を描画するための頂点インデックスデータ.
         * 
         * @param    split 分割数
         * @return    頂点インデックスデータ
         */
        protected function makeIndices(split:uint):Vector.<int>
        {
            var v:Vector.<int> = new Vector.<int>(split * split * 2 * 3);
            
            var i:uint;
            for (var x:uint = 0; x < split; ++x) {
                i = (x * (6 * split));
                for (var y:uint = 0; y < split; ++y) {
                    v[i + y * 6 + 0] = (y + 0) * (split + 1) + (x + 0);
                    v[i + y * 6 + 1] = (y + 0) * (split + 1) + (x + 1);
                    v[i + y * 6 + 2] = (y + 1) * (split + 1) + (x + 0);
                    v[i + y * 6 + 3] = (y + 0) * (split + 1) + (x + 1);
                    v[i + y * 6 + 4] = (y + 1) * (split + 1) + (x + 0);
                    v[i + y * 6 + 5] = (y + 1) * (split + 1) + (x + 1);
                    
                }
            }
            
            return v;
        }
        
        /**
         * 分割数 <code>split</code> の四角形のテクスチャデータ.
         * 
         * @param    split    分割数
         * @return    テクスチャデータ
         */
        protected function makeUvData(split:uint):Vector.<Number>
        {
            var v:Vector.<Number> = new Vector.<Number>((split + 1) * (split + 1) * 2);
            
            var i:uint;
            for (var x:uint = 0; x <= split; ++x) {
                for (var y:uint = 0; y <= split; ++y) {
                    i = (y * (split + 1) + x) * 2;
                    v[i + 0] = Number(x) / Number(split);
                    v[i + 1] = Number(y) / Number(split);
                }
            }
            
            return v;
        }
        
        /**
         * マウス押し下げ.
         */
        protected function mouseDownHandler(e:MouseEvent):void
        {
            if (isPressed) {
                return;
            }
            isPressed = true;
            phase = 0.0;
            vp = 0.003;
        }
        
        /**
         * マウス押し上げ.
         */
        protected function mouseUpHandler(e:MouseEvent):void
        {
            isPressed = false;
        }
        
        /**
         * フレームイベント.
         */
        protected function enterFrameHandler(e:Event):void
        {
            // マウス押されてる?
            if (isPressed) {
                // 生まれる
                if (phase < 1.0) {
                    phase += vp;
                    vp *= 1.05;
                }
                else {
                    phase = 1.0;
                }
            }
            else {
                // 戻る
                if (phase > 0.0) {
                    phase -= 0.1;
                }
            }
            
            // 描画コンテキスト
            var g:Graphics = canvas.graphics;
            
            // クリア
            g.clear();
            
            // マウス位置
            var mx:Number = mouseX;
            var my:Number = mouseY;
            // テクスチャサイズ
            var size:Number = TEXTURE_SIZE;
            // テクスチャ分割数
            var split:uint = TEXTURE_SPLIT;
            
            // 頂点データを再計算
            for (var x:uint = 0; x <= split; ++x) {
                for (var y:uint = 0; y <= split; ++y) {
                    var i:uint = (y * (split + 1) + x) * 2;
                    // 元の頂点位置
                    var vx:Number = originalVertices[i + 0];
                    var vy:Number = originalVertices[i + 1];
                    // どのくらい出てるか的な係数
                    var py:Number = ((size * phase) + (vy - size)) / size + phase * 0.75;
                    if (py <= 0.0) { py = 0.0; }
                    if (py >= 1.0) { py = 1.0; }
                    // X の変動係数
                    var p:Number = py / 3.0 + (phase * phase);
                    if (p <= 0.0) { p = 0.0; }
//                    if (p >= 1.0) { p = 1.0; }
                    // フェーズに応じて変形
                    vx = (size / 2.0) + (vx - size / 2.0) * p;
                    vy = vy * py;
                    // マウス位置に移動
                    vx = vx + mx - size / 2.0 + 2;
                    vy = vy + my + 32;
                    // 描画用の頂点データに反映
                    vertices[i + 0] = vx;
                    vertices[i + 1] = vy;
                }
            }
            
            // 描画
            g.beginBitmapFill(texture);
            g.drawTriangles(vertices, indices, uvData);
            g.endFill();
        }
    }
}