/**
 * Copyright bongiovi015 ( http://wonderfl.net/user/bongiovi015 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/shAF
 */

package
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Loader;
    import flash.display.Shader;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.filters.BlurFilter;
    import flash.filters.ShaderFilter;
    import flash.geom.Point;
    import flash.net.URLLoader;
    import flash.net.URLLoaderDataFormat;
    import flash.net.URLRequest;
    import flash.system.LoaderContext;
    import flash.utils.ByteArray;
    
    public class LensBlur extends Sprite{
        public var loaderImage : Loader = new Loader;
        public var loaderShader : URLLoader = new URLLoader;
        public var bmp : Bitmap;
        public var shader : Shader = new Shader;
        
        public function LensBlur(){
            graphics.beginFill(0, 1);
            graphics.drawRect(0, 0, 465, 465);
            graphics.endFill();
            loaderImage.contentLoaderInfo.addEventListener(Event.COMPLETE, imgLoaded);
            loaderImage.load(new URLRequest("http://www.bongiovi.tw/wonderfl/mood.jpg"), new LoaderContext(true));
        }
        
        
        private function imgLoaded(e:Event) : void {
            bmp = Bitmap(loaderImage.content);
            addChild(bmp).y = ( 465 - bmp.height ) * .5;
            loaderShader.addEventListener(Event.COMPLETE, shaderLoaded);
            loaderShader.dataFormat = URLLoaderDataFormat.BINARY;
            loaderShader.load(new URLRequest("http://www.bongiovi.tw/wonderfl/LensBlur.pbj"));
        }
        
        
        private function shaderLoaded(e:Event) : void {
            shader.byteCode = ByteArray(loaderShader.data);
            var bmpdBlur:BitmapData = bmp.bitmapData.clone();
            bmpdBlur.applyFilter(bmpdBlur, bmpdBlur.rect, new Point, new BlurFilter(10, 10, 3));
            shader.data.srcBlur.input = bmpdBlur;
            render(465 / 2 , 465 / 2);
            addEventListener(Event.ENTER_FRAME, loop);
        }
        
        
        public function loop(e:Event) : void {
            render(mouseX, mouseY);
        }
        
        
        public function render(tx:Number, ty:Number) : void {
            shader.data.center.value = [tx, ty];
            bmp.filters = [new ShaderFilter(shader)];
        }
    }
}


/*

<languageVersion : 1.0;>

kernel LensBlur
<   namespace : "bongiovi.tw";
    vendor : "bongiovi";
    version : 1;
    description : "Lens Blur";
>
{
    input image4 src;
    input image4 srcBlur;
    
    output pixel4 dst;
    
    
    parameter float2 center
    <
        minValue:float2(0.0, 0.0);
        maxValue:float2(1000.0, 1000.0);
        defaultValue:float2(0.0, 0.0);
    >;
    
    
    parameter float radius
    <
        minValue:1.0;
        maxValue:1000.0;
        defaultValue:200.0;
    >;
    
    
    
    void
    evaluatePixel()
    {
        float2 pos = outCoord();
        float dis = distance(pos, center);
        float angle = dis / radius * 90.0;
        if(angle > 90.0) angle = 90.0;
        float offset = 1.0 - cos(radians(angle));
        dst = mix(sampleNearest(src, pos), sampleNearest(srcBlur, pos), offset);
    }
}


*/