/**
 * Copyright mmlemon_ ( http://wonderfl.net/user/mmlemon_ )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/sh3u
 */

// forked from mmlemon_'s BlendModeを使ってカラフルな図形を表示させる
package
{
	import flash.display.BlendMode;
	import flash.display.GradientType;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.filters.BlurFilter;
	import flash.geom.Matrix;
	import flash.geom.Point;
	
	/**
	 * 一番上にグラデのシートを貼付けて、下の線に色を映す。
	 * 
	 */
	[SWF(backgroundColor=0x0,frameRate=60,width=465,height=465)]
	public class Circle2 extends Sprite
	{
		
		private static const CENTER:Point = new Point(465/2,465/2);
		private var m_arcNum:int = 10;
		private var arcs:Vector.<Arc>;
		
		private var colorContainer:Sprite;
		
		public function Circle2()
		{
			init();
		}
		
		private function init():void
		{
			arcs = new Vector.<Arc>();
			for(var i:uint=0;i < m_arcNum; i++)
			{
				createArc();
				arcs[i].rotation = 360/m_arcNum*i;
			}
			initColorContainer();
			addEventListener(Event.ENTER_FRAME, onLoop, false, 0,false);
			
			var blur:BlurFilter = new BlurFilter(1.5, 1.5);
			filters = [blur];
		}
		private function initColorContainer():void
		{
			colorContainer = new Sprite();
			
			var matrix:Matrix = new Matrix();
			matrix.createGradientBox(800, 600, 0, 0, 0);
			var type:String = GradientType.RADIAL;
			var colors:Array = [0xff0000, 0xffff00, 0x00ff00, 0x00ffff, 0x0000ff, 0xff00ff];
			var alphas:Array = [1, 1, 1, 1, 1, 1];
			var ratios:Array = [0, 50, 100, 150, 200, 255];
			colorContainer.graphics.beginGradientFill(type, colors, alphas, ratios, matrix);
			
			colorContainer.graphics.drawRect(0, 0, 800, 600);
			colorContainer.graphics.endFill();
			// 要するにこれで抜いた感じ。
			colorContainer.blendMode = BlendMode.SUBTRACT;
			addChild(colorContainer);
		}
		private function createArc():void
		{
			var arc:Arc = new Arc();
			arc.x = CENTER.x;
			arc.y = CENTER.y;
			arc.arcWidth = 200;
			arc.arcHeight = 100;
			
			addChild(arc);
			
			arcs.push(arc);
		}
		private function onLoop(event:Event):void
		{
			for(var i:uint=0; i < m_arcNum; i++)
			{
				arcs[i].rotation++;
			}
		}
	}
}
import flash.display.Sprite;
import flash.display.BlendMode;
        class Arc extends Sprite
	{
		
		private var m_arcWidth:Number;
		private var m_arcHeight:Number;
		public function get arcWidth():Number
		{
			return m_arcWidth;
		}
		public function set arcWidth(value:Number):void
		{
			m_arcWidth = value;
			updateShape();
		}
		public function get arcHeight():Number
		{
			return m_arcHeight;
		}
		public function set arcHeight(value:Number):void
		{
			m_arcHeight = value;
			updateShape();
		}
		private function updateShape():void
		{
			updateArc();
			width = m_arcWidth;
			height = m_arcHeight;
		}
		
		private function updateArc():void
		{
			graphics.clear();
			graphics.lineStyle(1, 0xffffff, 0.5);
			var lines:uint = 5;
			for(var i:uint=1; i < lines; i++)
			{
				graphics.moveTo(0,0);
				graphics.curveTo(m_arcWidth/i, m_arcHeight*i, m_arcWidth*i, m_arcHeight*i);
			}
			graphics.endFill();
		}
		
		public function Arc()
		{
			super();
			blendMode = BlendMode.ADD;
		}
	}
