/**
 * Copyright kappaLab ( http://wonderfl.net/user/kappaLab )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/sgpz
 */

package  
{
    
    import flash.display.*;
    import flash.events.Event;
    import flash.geom.Point;
    import flash.geom.Rectangle;
    import flash.media.*;

    public class LightTracer extends Sprite 
    {
        private var container:Sprite
        private var canvas:Sprite
        private var camera:Camera;
        private var video:Video;
        private var srcBmd:BitmapData
        private var w:Number;
        private var h:Number;
        private var r:Rectangle;
        private var p:Point
        private var g:Graphics;

        public function LightTracer() 
        {
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            
            container = addChild(new Sprite()) as Sprite;
            
            if (!(camera = Camera.getCamera())) return;
            
            w = camera.width;
            h = camera.height;
            r = new Rectangle(0, 0, w, h);
            p = new Point()
            video = new Video(w, h);
            video.attachCamera(camera);
            
            srcBmd = new BitmapData(w, h, false, 0xFF000000);
            var bmp:DisplayObject = addChild(new Bitmap(srcBmd))
            bmp.x = w;
            container.addChild(video);
            canvas = container.addChild(new Sprite()) as Sprite;
            g = canvas.graphics;
            
            addEventListener(Event.ENTER_FRAME,onEnterFrame)
        }
        
        private function onEnterFrame(e:Event):void 
        {
            srcBmd.unlock();
            srcBmd.lock();
            srcBmd.draw(video);
            srcBmd.threshold(srcBmd, r, p, ">", 0xFFEEEEEE, 0xFFFFFFFF, 0xFFFFFFFF);
            srcBmd.threshold(srcBmd, r, p, "<", 0xFFFFFFFF, 0x00000000, 0xFFFFFFFF);
            var rec:Rectangle = srcBmd.getColorBoundsRect(0xFFFFFF, 0xFFFFFF)
            g.clear()
            g.lineStyle(1, 0xFF0000)
            g.drawRect(rec.x,rec.y,rec.width,rec.height)
            
            
        }
        
    }
    
}