/**
 * Copyright NaruOno ( http://wonderfl.net/user/NaruOno )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/sgI8
 */

package {
    import flash.display.*;
    import flash.geom.*;
    import flash.text.*;
    import flash.events.*;
    import flash.media.*;
    import flash.net.*;
    import com.adobe.images.PNGEncoder;
    
   public class CameRakugaki extends Sprite{
       
       public function CameRakugaki(){
           //カメラ取得
           var camera:Camera = Camera.getCamera();
           
           
           //ペンの色
           var colors:Array = [
               0x000000,
               0xFF0000,
               0xFF3399,
               0xFFFF00,
               0x99FFCC,
               0x66CC66,
               0x0000CC,
               0xFFFFFF
           ];
           var color:Number = colors[0];
           
           //カメラサイズと表示位置
           var V:Video = new Video(320,240);
           V.attachCamera(camera);
           V.x = 50;
           V.y = 50;
           this.addChild(V);
           
           //キャンパスの位置と枠
           var Canvas:Sprite = new Sprite();
           Canvas.x = 50;
           Canvas.y = 50;
           Canvas.graphics.lineStyle(1,0xFF3399);
           Canvas.graphics.beginFill(0xFFFFFF,0);
           Canvas.graphics.drawRect(0,0,320,240);
           Canvas.graphics.endFill();
           this.addChild(Canvas);
           
           //線の描画
           Canvas.addEventListener(MouseEvent.MOUSE_DOWN,function(event:MouseEvent):void{
               Canvas.graphics.lineStyle(3,color);//ペン
               Canvas.graphics.moveTo(event.localX,event.localY)
           });
           Canvas.addEventListener(MouseEvent.MOUSE_MOVE,function(event:MouseEvent):void{
               if(event.buttonDown){
                   Canvas.graphics.lineTo(event.localX,event.localY);
                                   }
            });
            
            //カメラボタン
            var Vbutton:Sprite = new Sprite();
            Vbutton.graphics.lineStyle(2,0xFF3399);
            Vbutton.graphics.beginFill(0xFFCCCC);
            Vbutton.graphics.drawRect(0,0,70,30);//ボタンサイズ
            Vbutton.graphics.endFill();
            Vbutton.addEventListener(MouseEvent.MOUSE_DOWN,function(event:MouseEvent):void{
                V.visible = !V.visible;
            });
            var V_label:TextField = new TextField();
            V_label.text = 'カメラ';
            V_label.autoSize = TextFieldAutoSize.CENTER;
            V_label.x = 15;
            V_label.y = 5;
            Vbutton.addChild(V_label);
            Vbutton.x = 380;
            Vbutton.y = 50;
              //書式の指定
            var format:TextFormat = new TextFormat();                
            format.bold = true;  //フトジ    
            V_label.setTextFormat(format);
            this.addChild(Vbutton);
            
            //おえかきボタン
            var Cbutton:Sprite = new Sprite();
            Cbutton.graphics.lineStyle(2,0xFF3399);
            Cbutton.graphics.beginFill(0xFFCCCC);
            Cbutton.graphics.drawRect(0,0,70,30);//ボタンサイズ
            Cbutton.graphics.endFill();
            Cbutton.addEventListener(MouseEvent.MOUSE_DOWN,function(event:MouseEvent):void{
                Canvas.visible = !Canvas.visible;
            });
            var C_label:TextField = new TextField();
            C_label.text = '落書き';
            C_label.autoSize = TextFieldAutoSize.CENTER;
            C_label.x = 15;
            C_label.y = 5;
            Cbutton.addChild(C_label);
            Cbutton.x = 380;
            Cbutton.y = 90;
              //書式の指定  
            format.bold = true;  //フトジ    
            C_label.setTextFormat(format);
            this.addChild(Cbutton);
           
            //クリアボタン
            var Rbutton:Sprite = new Sprite();
            Rbutton.graphics.lineStyle(2,0xFF3399);
            Rbutton.graphics.beginFill(0xFFCCCC);
            Rbutton.graphics.drawRect(0,0,70,30);//ボタンサイズ
            Rbutton.graphics.endFill();
            Rbutton.addEventListener(MouseEvent.MOUSE_DOWN,function(event:MouseEvent):void{
               Canvas.graphics.clear();
               Canvas.graphics.lineStyle(1,0xFF3399);
               Canvas.graphics.beginFill(0xFFFFFF,0);
               Canvas.graphics.drawRect(0,0,320,240);
               Canvas.graphics.endFill();
               });
            var R_label:TextField = new TextField();
            R_label.text = 'リセット';
            R_label.autoSize = TextFieldAutoSize.CENTER;
            R_label.x = 15;
            R_label.y = 5;
            Rbutton.addChild(R_label);
            Rbutton.x = 380;
            Rbutton.y = 130;
              //書式の指定  
            format.bold = true;  //フトジ    
            R_label.setTextFormat(format);
            this.addChild(Rbutton);
            
            //saveボタン
            var savebutton:Sprite = new Sprite();
            savebutton.graphics.lineStyle(2,0xFF3399);
            savebutton.graphics.beginFill(0xFFCCCC);
            savebutton.graphics.drawRect(0,0,70,30);//ボタンサイズ
            savebutton.graphics.endFill();
           
             // save image
            savebutton.addEventListener(MouseEvent.MOUSE_UP, function(e:MouseEvent):void{
                var bd:BitmapData = new BitmapData(320, 240);
                bd.draw(V); bd.draw(Canvas);
                   (new FileReference()).save(
                    PNGEncoder.encode(bd),
                    'rakugaki.png'
                );
            });
             //save文字       
            var save_label:TextField = new TextField();
            save_label.text = '保存';
            save_label.autoSize = TextFieldAutoSize.CENTER;
            save_label.x = 15;
            save_label.y = 5;
            savebutton.addChild(save_label);
            savebutton.x = 380;
            savebutton.y = 170;
              //書式の指定  
            format.bold = true;  //フトジ    
            save_label.setTextFormat(format);
            this.addChild(savebutton);
            
          
            
            //色ボタン
            for(var i:Number = 0; i < colors.length;i++){
                var s:Sprite = new Sprite();
                s.graphics.lineStyle(1,0xCCCCCC);
                s.graphics.beginFill(colors[i]);
                s.graphics.drawRect(0,0,10,10);
                s.graphics.endFill();
                s.x =50 + 15*i;
                s.y = 300;
                (function():void{
                    var index:Number = i;
                    s.addEventListener(MouseEvent.MOUSE_DOWN,function(event:MouseEvent):void{
                        color = colors[index];
                    });
                })();
                this.addChild(s);
                    }

           }
       }
}

 