/**
 * Copyright ohisama ( http://wonderfl.net/user/ohisama )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/sgGJ
 */

// forked from Redstar's flash on 2009-5-23
package
{
    import Box2D.Collision.Shapes.b2CircleDef;
    import Box2D.Collision.Shapes.b2PolygonDef;
    import Box2D.Collision.b2AABB;
    import Box2D.Common.Math.b2Vec2;
    import Box2D.Dynamics.b2Body;
    import Box2D.Dynamics.b2BodyDef;
    import Box2D.Dynamics.b2DebugDraw;
    import Box2D.Dynamics.b2World;
    import flash.display.MovieClip;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    [SWF(backgroundColor='#eeeeee', frameRate='3')]
    public class Box2DTest2 extends MovieClip
    {
        private var m_world : b2World;
        private var m_physScale : Number = 50;
        private var m_timeStep : Number = 1.0 / 30.0;
        private var m_iterations : int = 10;
        private static const COLORS : Array = [0xee30dd, 0x3069e1, 0x3cb371];
        private static const DEGREE120 : Number = 2 / 3 * Math.PI;
        private static const DEGREE240 : Number = 4 / 3 * Math.PI;
        private static const DELTA_X : Number = 50 + 10 * Math.sqrt(3);
        public function Box2DTest2()
        {
            configStage();
            createWorld();
            createWall();
            createBalls();
            addEventListener(Event.ENTER_FRAME, update, false, 0, true);
        }
 　     private function configStage() : void
        {
            stage.scaleMode = StageScaleMode.NO_SCALE;
        }
        private function createWorld() : void
        {
            var worldAABB : b2AABB = new b2AABB();
            worldAABB.lowerBound.Set(-1000.0, -1000.0);
            worldAABB.upperBound.Set(1000.0, 1000.0);
            var gravity : b2Vec2 = new b2Vec2(0.0, 0.0);
            var doSleep : Boolean = true;
            m_world = new b2World(worldAABB, gravity, doSleep);
        }
        private function createWall() : void
        {
            var wallSd : b2PolygonDef = new b2PolygonDef();
            wallSd.friction = 0.0;
            wallSd.restitution = 1.0;
            var wallBd : b2BodyDef = new b2BodyDef();
            var wallB : b2Body;
            wallBd.position.Set(
                (50.0 + 10.0 * Math.sqrt(3)) / m_physScale,
                (10.0 + 50.0 * Math.sqrt(3)) / m_physScale
            );
            wallBd.angle = 0;
            wallSd.SetAsBox(
                (50.0 + 10.0 * Math.sqrt(3)) / m_physScale,
                10.0 / m_physScale
            );
            wallB = m_world.CreateBody(wallBd);
            wallB.CreateShape(wallSd);
            wallB.SetMassFromShapes();
            wallBd.position.Set(
                (25.0 + 5.0 * Math.sqrt(3)) / m_physScale,
                (-5.0 + 25.0 * Math.sqrt(3)) / m_physScale
            );
            wallBd.angle = - Math.PI / 3;
            wallSd.SetAsBox(
                (50.0 + 10.0 * Math.sqrt(3)) / m_physScale,
                10.0 / m_physScale
            );
            wallB = m_world.CreateBody(wallBd);
            wallB.CreateShape(wallSd);
            wallB.SetMassFromShapes();
            wallBd.position.Set(
                (75.0 + 15.0 * Math.sqrt(3)) / m_physScale,
                (-5.0 + 25.0 * Math.sqrt(3)) / m_physScale
            );
            wallBd.angle = Math.PI / 3;
            wallSd.SetAsBox(
                (50.0 + 10.0 * Math.sqrt(3)) / m_physScale,
                10.0 / m_physScale
            );
            wallB = m_world.CreateBody(wallBd);
            wallB.CreateShape(wallSd);
            wallB.SetMassFromShapes();
        }
        private function createBalls() : void
        {
            for (var i : int = 0; i < 35; i++) 
            {
                var bodyDefC : b2BodyDef = new b2BodyDef();
                var radius : Number = (Math.random() * 5 + 1) / m_physScale;
                var circDef : b2CircleDef = new b2CircleDef();
                circDef.density = 1.0;
                circDef.radius = radius;
                circDef.friction = 0.0;
                circDef.restitution = 1.0;
                bodyDefC.position.Set((30 + i * 1) / m_physScale, 70 / m_physScale);
                bodyDefC.angle = Math.random() * Math.PI;
                var body : b2Body = m_world.CreateBody(bodyDefC);
                body.CreateShape(circDef);
                body.SetMassFromShapes();
                var userData : Object = {color: COLORS[(int)(Math.random() * 3)], radius: radius};
                body.SetUserData(userData);
                var velocity : b2Vec2 = new b2Vec2();
                velocity.x = Math.random() * 10 - 5;
                velocity.y = Math.random() * 10 - 5;
                body.SetLinearVelocity(velocity);
            }
        }
        private function update(e : Event) : void
        {
            graphics.clear();
            m_world.Step(m_timeStep, m_iterations);
            for (var body : b2Body = m_world.GetBodyList(); body; body = body.GetNext()) 
            {
                if (body.GetUserData()) 
                {
                    var userData : Object = body.GetUserData();
                    var x : Number = body.GetPosition().x * m_physScale - DELTA_X;
                    var y : Number = body.GetPosition().y * m_physScale;
                    var radius : Number = userData.radius * m_physScale;
                    var color : uint = userData.color;
                    drawParticles(x, y, radius, color, stage.stageWidth / 2 - DELTA_X, stage.stageHeight / 2);
                }
            }
        }
        private function drawParticles(x : Number, y : Number, radius : Number, color : uint, centerX : Number, centerY : Number) : void
        {
            graphics.lineStyle(1.0, color, 0.5);
            graphics.beginFill(color, 0.8);
            graphics.drawCircle(x + centerX + 50 + 10 * Math.sqrt(3), y + centerY, radius);
            graphics.endFill();
            graphics.lineStyle(1.0, color, 0.5);
            graphics.beginFill(color, 0.8);
            graphics.drawCircle(x + centerX + 50 + 10 * Math.sqrt(3), - y + centerY, radius);
            graphics.endFill();
            graphics.lineStyle(1.0, color, 0.5);
            graphics.beginFill(color, 0.8);
            graphics.drawCircle(
                x * Math.cos(DEGREE120) - y * Math.sin(DEGREE120) + centerX + DELTA_X,
                x * Math.sin(DEGREE120) + y * Math.cos(DEGREE120) + centerY,
                radius
            );
            graphics.endFill();
            graphics.lineStyle(1.0, color, 0.5);
            graphics.beginFill(color, 0.8);
            graphics.drawCircle(
                x * Math.cos(DEGREE120) - y * Math.sin(DEGREE120) + centerX + DELTA_X,
                - x * Math.sin(DEGREE120) - y * Math.cos(DEGREE120) + centerY,
                radius
            );
            graphics.endFill();
            graphics.lineStyle(1.0, color, 0.5);
            graphics.beginFill(color, 0.8);
            graphics.drawCircle(
                x * Math.cos(DEGREE240) - y * Math.sin(DEGREE240) + centerX + DELTA_X,
                x * Math.sin(DEGREE240) + y * Math.cos(DEGREE240) + centerY,
                radius
            );
            graphics.endFill();
            graphics.lineStyle(1.0, color, 0.5);
            graphics.beginFill(color, 0.8);
            graphics.drawCircle(
                x * Math.cos(DEGREE240) - y * Math.sin(DEGREE240) + centerX + DELTA_X,
                - x * Math.sin(DEGREE240) - y * Math.cos(DEGREE240) + centerY,
                radius
            );
            graphics.endFill();
        }
    }
}
