/**
 * Copyright wcssoft ( http://wonderfl.net/user/wcssoft )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/sfAM
 */

// forked from jhey's forked from: Graph
// forked from hashito's Graph
// MainStage
package {
    import flash.display.Sprite;
    [SWF(frameRate=60,width=456,height=456)]
    public class MainStage extends Sprite {
        public function MainStage(){
            addChild(new Main());
        }
    }
}


import flash.display.*;
import flash.filters.BlurFilter;
import flash.geom.Point;
import flash.geom.ColorTransform;
import flash.events.*;
import flash.text.TextField;
import net.hires.debug.Stats;


class Main extends Sprite{
    public const H:Number = 200;
    public const W:Number = 200;
    
    private var d:Vector.<GraphData> = new Vector.<GraphData>();
    private var g:Graph = new Graph(W,H);
    //Constructor
    public function Main() {addEventListener(Event.ADDED_TO_STAGE, init);}
    //init
    public function init(e:*):void{
      
        var l:GraphLine=new GraphLine(g,d);
        reset();
        g.addLine(l);
        addChild(g);
        stage.addEventListener(MouseEvent.MOUSE_DOWN,reset);
    }
    public function reset(e:MouseEvent=null):void{
        var i:int;
        for(i=0;i<20;i++){
            d[i]=new GraphData(Math.random()*100,Math.random()*100);
        }
        d.sort(GraphData.Sortfunc);
        g.draw();
    }
    
}
//graph
class Graph extends Sprite{
    private var row:Number,col:Number,tick:Number,H:Number,W:Number;
    private var map:Bitmap=new Bitmap(),mapd:BitmapData,pen:Shape=new Shape(),board:Sprite=new Sprite();
    private const SPACE_W:Number=10,SPACE_H:Number=10;
    private const TICK_COLOR:uint = 0xEEEEEE,BACK_COLOR:uint = 0x0 ,SOLID_COLOR:uint=0xffffff;
    private var lines:Vector.<GraphLine> = new Vector.<GraphLine>(),lineBoard:Sprite=new Sprite;
    // constructor
    public function Graph(w:Number,h:Number,row:Number=100,col:Number=100,tick:Number=10):void{
        this.row=row;this.col=col;this.tick=tick;
        board.addChild(pen);
        addChild(map);
        addChild(lineBoard);
        setSize(w,h);
    }
    public function get graphW():Number{return W - SPACE_W;}
    public function get graphH():Number{return H - SPACE_H;}
    public function get graphCol():Number{return col;}
    public function get graphRow():Number{return row;}
    // set size
    public function setSize(w:Number,h:Number):void{
        mapd = new BitmapData((W = w),(H = h),false,BACK_COLOR);
        map.bitmapData = mapd;
        // col row 基準線
        pen.graphics.lineStyle(1,SOLID_COLOR);
        pen.graphics.moveTo(SPACE_W     , 0      );
        pen.graphics.lineTo(SPACE_W     , graphH );
        pen.graphics.lineTo(          W , graphH );
        
        // col row 目盛り線
        pen.graphics.lineStyle(1,TICK_COLOR);
        var t:int/* tick count */,s:Number/* tick size */,i:int;
        //縦目盛り
        t=Math.floor(row/tick);
        s=(W-SPACE_W)/tick;
        for(i=1;i<t;i++){
            pen.graphics.moveTo(s*i+SPACE_W,0);
            pen.graphics.lineTo(s*i+SPACE_W,H-SPACE_H);
        }
        //横目盛り
        t=Math.floor(col/tick);
        s=(H-SPACE_H)/tick;
        for(i=1;i<t;i++){
            pen.graphics.moveTo(SPACE_W,s*i);
            pen.graphics.lineTo(W,s*i);
        }
        mapd.draw(board);
        pen.graphics.clear();
        draw();
    }
    // line add
    public function addLine(l:GraphLine):int{
        lineBoard.addChild(l);
        l.x = SPACE_W;
        return lines.push(l);
    }
    // 描画
    public function draw():void{
        for each(var l:GraphLine in lines){
            l.draw();
        }
    }
    // line remove
    public function removeLine(l:GraphLine):GraphLine{
        lineBoard.removeChild(l);
        return lines.splice(lines.indexOf(l),1)[0];
    }
}
//graph line
class GraphLine extends Bitmap{
    private var d:Vector.<GraphData> = new Vector.<GraphData>();
    private var color:uint;
    private var bitdata:BitmapData,pen:Shape=new Shape(),board:Sprite=new Sprite,txt:TextField=new TextField();
    private var map:Graph;
    private const BACK_COLOR:uint=0x000001,TEXT_COLOR:uint=0xffeeee;
    public function GraphLine(map:Graph,d:Vector.<GraphData>=null,color:uint=0xff0000){
        this.d=d;
        this.map=map;
        this.color=color;
        board.addChild(pen);
        board.addChild(txt);
        //init txt
        txt.autoSize  = flash.text.TextFieldAutoSize.LEFT;
        txt.textColor = TEXT_COLOR;
    }
    //描画
    public function draw():void{
        var w:Number = map.graphW ,h:Number = map.graphH,c:Number = map.graphCol ,r:Number = map.graphRow,i:int;
        bitdata=new BitmapData(w,h,true,BACK_COLOR);
        // 描画処理
        pen.graphics.clear();
        pen.graphics.lineStyle(1,color);
        pen.graphics.moveTo((d[i].time/c)*w,(d[i].data/r)*h);
        for(i=1;i<d.length;i++){
            var px:Number=(d[i].time/c)*w , py:Number=(d[i].data/r)*h;
            pen.graphics.lineTo(px,py);
            txt.x=px;txt.y=py;
            txt.text="("+uint(d[i].time)+","+uint(d[i].data)+")";
            bitdata.draw(board);//描画
        }
        bitmapData=bitdata;
    }
    public function getData():Vector.<GraphData>{return d;}
    public function setData(d:Vector.<GraphData>):void{this.d=d;}
    
}
//graph data
class GraphData{
    public var time:Number,data:Number;
    public function GraphData(t:Number,d:Number){time=t;data=d;}
    public static function Sortfunc(a:GraphData,b:GraphData):Number{
        // sort に渡す関数の戻り値は小数点以下は認識しないため
        var t:Number=(a.time-b.time);
        if(t<0)      return -1;
        else if(t>0) return 1;
        else         return 0;
    }
}
