/**
 * Copyright J.J ( http://wonderfl.net/user/J.J )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/seP7
 */

package  {

    import flash.events.Event;
    import flash.display.Sprite;
    /**
     * @author javid
     */
    public class Wave extends Sprite {
        private const NUM:Number=30
        private var w : Number,h : Number
        private var wave : WWave;
        public function Wave() {
            w=stage.stageWidth,h=stage.stageHeight;
            stage.frameRate=60;
            wave=new WWave(h/2+10,w,h,NUM,false)
            addChild(wave)           
            this.addEventListener(Event.ENTER_FRAME, loop)
        }
        private function loop(event : Event) : void {
            wave.render(true)
        }
    }
}

import flash.events.MouseEvent;
import flash.display.MovieClip;
class WWave extends MovieClip{
    private var Particles:Vector.<WVParticle>;
    private var PSprting:Array;
    private var l:int;
    private const FK:Number=.5
    private var w : Number,h : Number
    private var __y:Number
    private var nodeNum:int
    private var showPoints:Boolean
    public function WWave(_y:Number,_w:Number,_h:Number,_nodeNum:int=20,_showPoints:Boolean=true){
        nodeNum=_nodeNum
        w=_w
        h=_h
        __y=_y
        showPoints=_showPoints
        Particles=new Vector.<WVParticle>();
        PSprting=[];
        repair()
    }

    private function repair():void{
        for (var k : int = 0; k <nodeNum ; k++) {
                var p:WVParticle=new WVParticle(k*w/(nodeNum-2),__y,showPoints)
                addChild(p)
                Particles.push(p)
    }
    l=Particles.length;
    for (var i : int = 0; i <l; i++) {
    if(i+1<l) PSprting.push({iy:Particles[i+1].y-Particles[i].y})
    Particles[i].addEventListener(MouseEvent.MOUSE_MOVE, onParticleTouched)
    }
    }
    public function onParticleTouched(e:MouseEvent):void{
    var trgt:WVParticle=e.target as WVParticle;
    var indx:int=Particles.indexOf(trgt)
    if(indx-2>0 && indx+2<l) {
                Particles[indx-2].vy=(mouseY-Particles[indx-2].mposY)/6
                Particles[indx-1].vy=(mouseY-Particles[indx-1].mposY)/5
                Particles[indx].vy=(mouseY-Particles[indx].mposY)/3
                Particles[indx+2].vy=(mouseY-Particles[indx+2].mposY)/6
                Particles[indx+1].vy=(mouseY-Particles[indx+1].mposY)/5
        }
        trgt.mposY=mouseY;
    }
    public function render(drawShape:Boolean=true):void{
    for(var i:int=l-1;i>=0;i--){
    var extnsY:Number=0,forceY:Number=0
    if(i>0){
    extnsY=Particles[i-1].y-Particles[i].y-PSprting[i-1].iy;
    forceY+=-FK*extnsY
    }
    if(i<l-1){
    extnsY=Particles[i].y - Particles[i+1].y - PSprting[i].iy;
    forceY+=FK*extnsY
    }
    extnsY= Particles[i].y - Particles[i].baseY;
    forceY+=FK/15*extnsY
    with(Particles[i]){
    a= -forceY/m;
    vy+= a;
    posY+=vy;
    vy/= 1.04;
    }
    }
    if(drawShape){
    this.graphics.clear()
    this.graphics.lineStyle(1)
    this.graphics.beginFill(0x000000)
    this.graphics.moveTo(Particles[0].x,Particles[0].y )
    for(var j:Number = 0; j < l; j++)
            {    
            //    mcParticles[j].x= mcParticles[j].posX;
            if(j+1<l) with(Particles[j]){
            y=posY;
            this.graphics.curveTo(x,y,x+(Particles[j+1].x-x)/2,y+(Particles[j+1].y-y)/2)}
            }
            this.graphics.lineTo(w,h)
            this.graphics.lineTo(0,h)
    }else{
    for(var k:Number = 0; k < l; k++) if(k+1<l) with(Particles[k]) y=posY;        
    }
    }
}
import flash.display.Sprite;
class WVParticle extends Sprite{
    public var posX:Number
    public var posY:Number
    public var m:Number=10
    public var a:Number=0
    public var baseY:Number
    public var vy:Number=0
    public var mposY:Number
    public var delta:Number=50
public function WVParticle(_x:Number,_y:Number,_showPoints:Boolean){
        posX=this.x=_x
        baseY=posY=this.y=_y
        mposY=baseY+delta
        with(this.graphics){
        beginFill(0x808080);
        drawCircle(0, 0, 8);
        endFill()
        if(!_showPoints) this.alpha=0;
        }

}

}