/**
 * Copyright flashrod ( http://wonderfl.net/user/flashrod )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/seIv
 */

package {
    import flash.display.Sprite;
    import flash.text.TextField;
    import flash.events.Event;
    import flash.events.KeyboardEvent;
    [SWF(width="465", height="465", backgroundColor="0xFFFFFF", frameRate="30")]
    public class Shoot extends Sprite {
        private const W:int = 465;
        private const H:int = 465;
        private var key:Array = [];
        private var ship:Object = {x:W/2, y:H-16, dead:1};
        private var score:int;
        private var missile:Array;
        private var enemy:Array;
        private var bomb:Array;
        public function Shoot() {
            var t:TextField = new TextField();
            t.autoSize = "left";
            addChild(t);
            stage.focus = this;
            stage.addEventListener(KeyboardEvent.KEY_DOWN, function(e:KeyboardEvent):void {
                key[e.keyCode] = 1;
            });
            stage.addEventListener(KeyboardEvent.KEY_UP, function(e:KeyboardEvent):void {
                key[e.keyCode] = 0;
            });
            addEventListener(Event.ENTER_FRAME, function(e:Event):void {
                if (ship.dead) {
                    if (--ship.dead == 0) {
                        score = 0;
                        ship.x = W/2;
                        ship.y = H-16;
                        t.text = "Click to focus, ARROW key to Move, SPACE key to shoot";
                        bomb = [];
                        missile = [];
                        enemy = [];
                    }
                } else {
                    if ((key[72] || key[37]) && ship.x > 0)
                        ship.x -= 8;
                    if ((key[74] || key[40]) && ship.y < H)
                        ship.y += 8;
                    if ((key[75] || key[38]) && ship.y > 0)
                        ship.y -= 8;
                    if ((key[76] || key[39]) && ship.x < W)
                        ship.x += 8;
                    if (key[32]) {
                        key[32] = 0;
                        missile.push({x:ship.x, y:ship.y});
                    }
                }
                for (var i:int = missile.length-1; i >= 0; --i) {
                    var m:Object = missile[i];
                    m.y -= 16;
                    if (m.y < 0) {
                        missile.splice(i, 1);
                    }
                }
                for (i = enemy.length-1; i >= 0; --i) {
                    var o:Object = enemy[i];
                    if (o.dead) {
                        if (--o.dead==0 || o.y > H || o.x < 0 || o.x > W)
                            enemy.splice(i, 1);
                    } else {
                        o.x += o.u;
                        o.y += o.v;
                        if (!ship.dead && Math.random() < (1/100)) {
                            dx = ship.x - o.x;
                            dy = ship.y - o.y;
                            var d:Number = Math.sqrt(dx * dx + dy * dy);
                            if (d > 50) {
                                d /= 4;
                                bomb.push({x:o.x, y:o.y, u:dx/d, v:dy/d});
                            }
                        }
                    }
                }
                for (i = bomb.length-1; i >= 0; --i) {
                    var b:* = bomb[i];
                    b.x += b.u;
                    b.y += b.v;
                    if (b.y < 0 || b.y > H && b.x < 0 || b.y > W)
                        bomb.splice(i, 1);
                }
                for each (m in missile) {
                    for each (o in enemy) {
                        if (!o.dead) {
                            var dx:Number = o.x - m.x;
                            var dy:Number = o.y - m.y;
                            if ((dx * dx + dy * dy) < 256) {
                                m.y = -1;
                                o.dead = 10;
                                score += 1;
                                t.text = String(score);
                            }
                        }
                    }
                }
                for each (b in bomb) {
                    dx = b.x - ship.x;
                    dy = b.y - ship.y;
                    if ((dx * dx + dy * dy) < 64)
                        ship.dead = 90;
                }
                for each (o in enemy) {
                    dx = o.x - ship.x;
                    dy = o.y - ship.y;
                    if ((dx * dx + dy * dy) < 100)
                        ship.dead = 90;
                }
                if (!ship.dead && Math.random() < (1/30))
                    enemy.push({x:Math.random()*W, y:0, u:int(Math.random()*3)-1, v:2, f:0});
                with (graphics) {
                    clear();
                    lineStyle(1, 0);
                    if (ship.dead) {
                        moveTo(ship.x-8, ship.y-8);
                        lineTo(ship.x+8, ship.y+8);
                        moveTo(ship.x-8, ship.y+8);
                        lineTo(ship.x+8, ship.y-8);
                    } else {
                        moveTo(ship.x, ship.y-8);
                        lineTo(ship.x+8, ship.y+8);
                        lineTo(ship.x-8, ship.y+8);
                        lineTo(ship.x, ship.y-8);
                    }
                    for each (m in missile) {
                        moveTo(m.x, m.y-8);
                        lineTo(m.x, m.y+8);
                    }
                    for each (o in enemy)
                        if (o.dead) {
                            moveTo(o.x-8, o.y-8);
                            lineTo(o.x+8, o.y+8);
                            moveTo(o.x-8, o.y+8);
                            lineTo(o.x+8, o.y-8);
                        } else {
                            drawCircle(o.x, o.y, 8);
                        }
                    for each (b in bomb) {
                        beginFill(0);
                        drawCircle(b.x, b.y, 4);
                    }
                }
            });
        }
    }
}
