/**
 * Copyright h1ro ( http://wonderfl.net/user/h1ro )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/se5Z
 */

//----------------------------------------
// copyPositionとcopyTransformの練習
// @author h1ro
//----------------------------------------
package {
    
    import flash.events.Event;
    import org.papervision3d.materials.ColorMaterial;
    import org.papervision3d.objects.primitives.Plane;
    import org.papervision3d.objects.DisplayObject3D;
    import org.papervision3d.cameras.*;
    import org.papervision3d.view.BasicView;
    
    public class copyPosTest extends BasicView {
        
        private var container:DisplayObject3D;        
        
        public function copyPosTest():void{
            
            
            container = new DisplayObject3D();
            scene.addChild(container);
            
            //cameraの値をセット
            camera.focus = 600;
            camera.y = 0;
            camera.x = 0;
            camera.z = 600;
            camera.zoom = 1;
            
            //Plane1を生成
            var material1:ColorMaterial = new ColorMaterial(0x333333);
            material1.doubleSided = true;
            var plane1:Plane = new Plane(material1, 100, 100);
            plane1.x = 0;
            plane1.y = 0;
            plane1.z = 0;
                
            //Plane2を生成
            var material2:ColorMaterial = new ColorMaterial(0x003300);
            material2.doubleSided = true;
            var plane2:Plane = new Plane(material2, 50, 50);
            plane2.x = 0;
            plane2.y = 100;
            plane2.z = 0;
                
            //シーンに追加
            //plane1はcontainerの中に
            container.addChild(plane1);
            //plane1はcontainerの中に
            container.addChild(plane2);
            
            //イベント追加
            addEventListener(Event.ENTER_FRAME, function(e:Event):void {
                plane1.yaw(3);
                
                //copyPositionだと位置だけ動く
                plane2.copyPosition(plane1);
                
                //copyTransformだと位置も動きも動く
                //plane2.copyTransform(plane1);
                }
            );
            //レンダリングスタート
            startRendering();
        }
    }
}