/**
 * Copyright coppieeee ( http://wonderfl.net/user/coppieeee )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/sd0h
 */

/*
 * ドラッグできるWindowを作ってみた。
 * 読みやすさ重視してるので、機能としてはドラッグと色の変更ぐらい。
 * 機能追加したいなら、Forkすればいいんじゃない？
 */ 

package 
{
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.text.TextField;
	import flash.text.TextFieldType;
	import flash.display.Graphics;
	
	public class Main extends Sprite 
	{
		public function Main():void 
		{
			var tf:TextField = new TextField();
			tf.text = "This is \nSimpleWindow!\nドラッグできるよ！";
			tf.border = true;
			tf.type = TextFieldType.INPUT;
			tf.multiline = true;
			tf.width = 200;
			
			var w:SimpleWindow = new SimpleWindow(tf);
			w.barColor = 0xAAAAFF;
			addChild(w);
		}
	}
}
import flash.display.DisplayObject;
import flash.display.Graphics;
import flash.display.Sprite;
import flash.events.MouseEvent;
class SimpleWindow extends Sprite
{
	/**
	 * contensに代入すれば、SimpleWindowにaddChild()されて、refresh()する。
	 */
	public function get contents():DisplayObject { return _contents; }
	public function set contents(value:DisplayObject):void
	{
		if (_contents) { removeChild(_contents); }
		if (value) { addChild(value); }
		_contents = value;
		refresh();
	}
	private var _contents:DisplayObject;
	private var _bar:Sprite;
	
	public function get barColor():uint { return _barColor; }
	public function set barColor(value:uint):void { _barColor = value; refresh(); }
	private var _barColor:uint = 0x0000FF;
	
	/**
	 * シンプルに実装したWindow。
	 * @param	contents
	 */
	public function SimpleWindow(contents:DisplayObject = null)
	{
		_bar = new Sprite();
		addChild(_bar);
		
		this.contents = contents;
		refresh();
		
		_bar.addEventListener(MouseEvent.MOUSE_DOWN, function(e:MouseEvent):void {
			startDrag();
		});
		_bar.addEventListener(MouseEvent.MOUSE_UP, function(e:MouseEvent):void {
			stopDrag();
		});
	}
	
	/**
	 * Windowのサイズをあわせる。
	 */
	public function refresh():void
	{
		var barWidth:Number = _contents ? _contents.width : 100;
		var g:Graphics = _bar.graphics;
		g.clear();
		g.beginFill(barColor);
		g.drawRect(0, 0,barWidth ,15);
		g.endFill();
		_contents && (_contents.y = _bar.height);
	}
}