/**
 * Copyright davidejones ( http://wonderfl.net/user/davidejones )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/scgK
 */

package 
{
    import alternativa.engine3d.core.events.MouseEvent3D;
    import alternativa.engine3d.core.RayIntersectionData;
    import alternativa.engine3d.primitives.Plane;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.display.Stage3D;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import alternativa.engine3d.primitives.Box;
    import alternativa.engine3d.core.Resource;
    import alternativa.engine3d.controllers.SimpleObjectController;
    import alternativa.engine3d.core.Camera3D;
    import alternativa.engine3d.core.Object3D;
    import alternativa.engine3d.core.View;
    import alternativa.engine3d.materials.FillMaterial;
    import flash.events.MouseEvent;
    import flash.geom.Vector3D;
    
    /**
     * ...
     * @author David E Jones
     */
    public class Main extends Sprite 
    {
        private var scene:Object3D = new Object3D();
        private var camera:Camera3D;
        private var controller:SimpleObjectController;
        private var stage3D:Stage3D;
        private var box:Box;
        private var boxSelected:Boolean = false;
        private var startPoint:Vector3D;
        
        public function Main():void 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            
            stage.align = StageAlign.TOP_LEFT;
            stage.scaleMode = StageScaleMode.NO_SCALE;
            
            camera = new Camera3D(1, 100000);
            camera.x = 0;
            camera.y = 500;
            camera.z = -800;
            camera.view = new View(stage.stageWidth, stage.stageHeight, false, 0, 0, 4);
            camera.view.backgroundColor = 0x000000;
            addChild(camera.view);
            addChild(camera.diagram);
            
            controller = new SimpleObjectController(stage, camera, 200);
            controller.lookAt(new Vector3D(0,0,0));
            scene.addChild(camera);
            
            stage3D = stage.stage3Ds[0];
            stage3D.addEventListener(Event.CONTEXT3D_CREATE, onContextCreate);
            stage3D.requestContext3D();
        }
        
        private function onContextCreate(e:Event):void {
            stage3D.removeEventListener(Event.CONTEXT3D_CREATE, onContextCreate);
            
            var plane:Plane = new Plane(1500, 1500, 1, 1);
            plane.setMaterialToAllSurfaces(new FillMaterial( 0x00FF00 ));
            plane.rotationX = 90 * Math.PI / 180;
            plane.y = -50;
            scene.addChild(plane);
            uploadResources(plane.getResources(true));
                        
            box = new Box(100, 100, 100, 1, 1, 1, false, null);
            var material:FillMaterial = new FillMaterial( 0xFF0000 );
            box.setMaterialToAllSurfaces(material);
            scene.addChild(box);
            uploadResources(box.getResources(true));
            
            box.addEventListener(MouseEvent3D.MOUSE_DOWN, onMouseDown);
            
            stage.addEventListener(Event.ENTER_FRAME, onEnterFrame);
            stage.addEventListener(Event.RESIZE, onResize);
            onResize();
        }
        
        private function onMouseDown(e:MouseEvent3D):void 
        {
            stage.addEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
            stage.addEventListener(MouseEvent.MOUSE_UP, onMouseUp);
            
            var object:Object3D = e.target as Object3D;
            var origin:Vector3D = new Vector3D();
            var direction:Vector3D = new Vector3D();
            camera.calculateRay(origin, direction, stage.mouseX, stage.mouseY);
            var data:RayIntersectionData = object.intersectRay(origin, direction);
            
            if (data != null) {
                startPoint = data.point;
            }
        }
        
        private function onMouseUp(e:MouseEvent):void
        {
            stage.removeEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
            stage.removeEventListener(MouseEvent.MOUSE_UP, onMouseUp);
        }
        
        private function onMouseMove(e:MouseEvent):void
        {
            if (startPoint != null)
            {
                var origin:Vector3D = new Vector3D;
                var directionA:Vector3D = new Vector3D;
                var directionB:Vector3D = new Vector3D;
                var direction:Vector3D = new Vector3D;
                
                camera.calculateRay(origin, directionA, camera.view.width/2, camera.view.height/2);
                camera.calculateRay(origin, directionB, mouseX, mouseY);
                
                var pos : Vector3D = intersectionPoint(origin, directionB, new Vector3D(0, startPoint.y, 0), new Vector3D(0, 1, 0));
                box.x = pos.x - startPoint.x;
                box.y = pos.y - startPoint.y;
                box.z = pos.z - startPoint.z;
            }
        }
        
        public static function intersectionPoint(lineStart:Vector3D, lineDirection:Vector3D, planePosition:Vector3D, planeNormal:Vector3D):Vector3D {
            
            var result:Vector3D = new Vector3D();
            var w:Vector3D = lineStart.subtract(planePosition);
            var d:Number = planeNormal.dotProduct(lineDirection);
            var n:Number = -planeNormal.dotProduct(w);
            
            if (Math.abs(d) < 0.0000001) return result;    
            
            var sI:Number = n / d;
            
            result.x = lineStart.x + (lineDirection.x * sI);
            result.y = lineStart.y + (lineDirection.y * sI);
            result.z = lineStart.z + (lineDirection.z * sI);

            return result;    
        }

        
        
        private function onMouse9Move(e:MouseEvent3D):void 
        {
            if (boxSelected) {
                var object:Object3D = e.target as Object3D;
                //var target:Vector3D = object.localToGlobal(new Vector3D(e.localX, e.localY, e.localZ));
                //var target:Vector3D = object.globalToLocal(new Vector3D(e.localX, e.localY, e.localZ));
                //object.x = e.localX;
                //object.y = e.localY;
                //object.z = object.z;
                //object.x = target.x;
                //object.y = target.y;
                //object.z = target.z;
                //trace(box.x);
                //trace(e.localX);
                //trace(target.x);
            }
        }
        
        private function onClick(e:MouseEvent3D):void
        {
            var box:Box = new Box(50,50,50,1,1,1,false,new FillMaterial(0xFF0000));
            box.x = e.localX;
            box.y = e.localY;
            box.z = e.localZ + 25;
            scene.addChild(box);

            uploadResources(box.getResources());
        }

        private function uploadResources(resources:Vector.<Resource>):void {
            for each (var resource:Resource in resources) {
                resource.upload(stage3D.context3D);
            }
        }
        
        private function onEnterFrame(e:Event):void {
            if (boxSelected) {
                
            }
            camera.render(stage3D);
        }
        
        private function onResize(e:Event = null):void {
            camera.view.width = stage.stageWidth;
            camera.view.height = stage.stageHeight;
        }
        
    }
    
}