/**
 * Copyright yasnis ( http://wonderfl.net/user/yasnis )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/sbJM
 */

package {
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Sprite;
	import flash.display.StageAlign;
	import flash.display.StageScaleMode;
	import flash.events.Event;
	import flash.events.TimerEvent;
	import flash.geom.Rectangle;
	import flash.utils.Timer;
    public class FlashTest extends Sprite {
		private var scale:int = 3;
		private var x_max:int = 500;
		private var y_max:int = 500;
		private var bmpd:BitmapData = new BitmapData(x_max, y_max, false, 0xffffffff);
		private var bmp:Bitmap = new Bitmap(bmpd);
		private var currentnode:Vector.<int> = new Vector.<int>(x_max);
		private var oldnode:Vector.<int>;
		private var currentstep:int = 0;
		private var interval:int = 20;
		private var timer:Timer = new Timer(interval, 0);
        public function FlashTest() {
            // write as3 code here..
            
			stage.align = StageAlign.TOP_LEFT;
			stage.scaleMode = StageScaleMode.NO_SCALE;
			stage.addEventListener(Event.RESIZE, resetLayout);
			addChild(bmp);
			resetLayout(null);
			timer.start();
			timer.addEventListener(TimerEvent.TIMER, updateTimer);
			//addEventListener(Event.ENTER_FRAME, enterframeHandler);
        }
		private function updateTimer(e:TimerEvent):void {
			calcLife();
			updateBitmap();
		}
		private function enterframeHandler(e:Event):void {
			calcLife();
			updateBitmap();
		}
		private function resetLayout(e:Event):void {
			currentstep = 0;
			x_max = stage.stageWidth/scale;
			y_max = stage.stageHeight/scale;
			bmpd = new BitmapData(x_max, y_max, false, 0xffffffff);
			bmp.bitmapData = bmpd;
			bmp.x = bmp.y = 0;
			bmp.width = stage.stageWidth;
			bmp.height = stage.stageHeight;
			initialize();
		}
		private function initialize():void {
			var l:int = currentnode.length;
			currentnode = new Vector.<int>(x_max);
			for (var i:int = 0; i < l; i++) {
				currentnode[i] = Math.round(Math.random());
			}
			oldnode = currentnode;
			updateBitmap();
		}
		private function calcLife():void {
			currentnode = new Vector.<int>(x_max);
			var l:int = oldnode.length;
			var life:int = 0;
			for (var i:int = 0; i < l; i++) {
				life = 0;
				if (i == 0) {
					life += 4 * oldnode[l - 1];
					life += 1 * oldnode[i + 1];
				}else if (i == l - 1) {
					life += 4 * oldnode[i - 1];
					life += 1 * oldnode[0];
				}else {
					life += 4 * oldnode[i-1];
					life += 1 * oldnode[i + 1];
				}
				life += 2 * oldnode[i];
				currentnode[i] = (life == 7 || life == 4 || life == 1)?1:0;
			}
			oldnode = currentnode;
		}
		private function updateBitmap():void {
			if (currentstep == y_max) {
				currentstep = y_max-1;
				bmpd.scroll(0, -1);
			}
			bmpd.lock();
			var l:int = oldnode.length;
			for (var i:int = 0; i < l; i++) {
				bmpd.setPixel32(i, currentstep, oldnode[i]?0xff000000:0xffffffff);
			}
			bmpd.unlock(new Rectangle(0, currentstep, x_max, 1));
			currentstep++;
		}
    }
}