/**
 * Copyright umi_kappa ( http://wonderfl.net/user/umi_kappa )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/sau3
 */

// forked from umi_kappa's 曲げセンサで音を鳴らす。SiON
// forked from umi_kappa's Gainerで曲げセンサを使ってみる
/*Gainerで値をとることができたから、
 * 次はSiONライブラリを使って音をならしてみる。
 * ナイキのあれみたいだね
 * あそこまでいいものじゃないけど（笑）
 * 
 * SiONのことなら、ほかのサイトさんを参考にした
 * SiONの練習シリーズをどうぞ
 * http://wonderfl.net/c/ttPL
 * 
 * 音に映像をぷらす。
 * こちらのソースをいただきました。
 * http://wonderfl.net/c/xn08
 * 
 * 1キーでpiano
 * 2	lead
 * 3	wind
 * */

package {
	import flash.display.*;
	import flash.events.*;
	import flash.geom.*;
	import flash.media.*;
	import flash.text.*;
	import flash.utils.Timer;
	import funnel.*;
	import org.si.sion.*;
	import org.si.sion.utils.*;
	
    public class Main extends Sprite {
		//Gainer--------------------------------------------------------
		private var _gio:Gainer;
		//曲げセンサーの入力を入れるピン
		private var _mage_Pin:Pin;
		
		//曲げセンサの値を保存する変数
		private var _mage_value:int = 0;
		//--------------------------------------------------------------
		
		//SiON----------------------------------------------------------
		private var sion_Driver:SiONDriver;
		private var prisetVoice:SiONPresetVoice;
		private var voice:SiONVoice;
		private var _timer:Timer = new Timer(50);
		//--------------------------------------------------------------
		
		//WEBカメラ用------------------------------------------------------
        // 震えの許容値
        private var LATITUDE:Number = 1;
		
		//bitmapdataの倍率
		private var zoom:Number = 1.2;
        
        private var _cam:Camera;
        private var _vid:Video;
        private var _bmp:Bitmap;
        private var _bmpDataSrc:BitmapData = new BitmapData(stage.stageWidth, stage.stageHeight, true);
        private var _bmpDataDst:BitmapData = new BitmapData(stage.stageWidth, stage.stageHeight, true);
        private var _bmpDataC:BitmapData = new BitmapData(stage.stageWidth, stage.stageHeight, true);
        private var _bmpDataM:BitmapData = new BitmapData(stage.stageWidth, stage.stageHeight, true);
        private var _bmpDataY:BitmapData = new BitmapData(stage.stageWidth, stage.stageHeight, true);
        private var _bmpDataK:BitmapData = new BitmapData(stage.stageWidth, stage.stageHeight, true);
		//--------------------------------------------------------------
		
		
        public function Main() {
			addEventListener(Event.ADDED_TO_STAGE, add);
        }
		
		//配置完了！
		private function add(e:Event):void 
		{
			removeEventListener(Event.ADDED_TO_STAGE, add);
			
			gainer_set();
			camera_set();
			
			addEventListener(Event.ENTER_FRAME, onEF);
		}
		
		private function camera_set():void
		{// ビデオ準備
            _cam = Camera.getCamera();
            _cam.setMode(stage.stageWidth, stage.stageHeight, stage.frameRate);
            _vid = new Video(stage.stageWidth, stage.stageHeight);
            _vid.attachCamera(_cam);
			
			//カメラがactiveになったら音を流す。
			_cam.addEventListener(ActivityEvent.ACTIVITY, onActive);
            
            // 表示用Bitmapに出力用bitmapを関連づける
            _bmp = new Bitmap(_bmpDataDst);
			_bmp.width = stage.stageWidth * zoom;
			_bmp.height = stage.stageHeight * zoom;
            
            // stageにadd
            addChild(_bmp);
		}
		
		private function onActive(e:ActivityEvent):void 
		{
			SiON_set();
		}
		
		private function SiON_set():void
		{
			sion_Driver = new SiONDriver;
			prisetVoice = new SiONPresetVoice;
			voice = new SiONVoice;
			voice = prisetVoice["valsound.piano1"];
			sion_Driver.play();
			
			_timer.addEventListener(TimerEvent.TIMER, onTimer);
			_timer.start();
			
			stage.addEventListener(KeyboardEvent.KEY_DOWN, onKD);
		}
		
		private function onTimer(e:TimerEvent):void 
		{
			//曲げセンサーの値をSiONに対応させる
			sion_Driver.noteOn(_mage_value, voice, 1, 0, 0, 0, true);
		}
		
		private function onKD(e:KeyboardEvent):void 
		{
			switch(e.keyCode) {
				case 49:
				voice = prisetVoice["valsound.piano1"];
				break;
				
				case 50:
				voice = prisetVoice["valsound.lead5"];
				break;
				
				case 51:
				voice = prisetVoice["valsound.wind1"];
				break;
				
				case 52:
				voice = prisetVoice["valsound.bell1"];
				break;
				
				case 53:
				voice = prisetVoice["midi.dram24"];
				break;
				
				case 54:
				voice = prisetVoice["midi.drum30"];
				break;
				
				case 55:
				voice = prisetVoice["midi.drum35"];
				break;
				
				case 56:
				voice = prisetVoice["midi.drum45"];
				break;
				
				case 57:
				voice = prisetVoice["midi.drum65"];
				break;
				
				case 48:
				voice = prisetVoice["midi.drum72"];
				break;
			}
		}
		
		private function gainer_set():void
		{
			_gio = new Gainer();
			//アナログINの0を使うよ
			_mage_Pin = _gio.analogInput(0);
			
			//フィルターをかける
			_mage_Pin.addFilter(new Scaler(0.5, 0.65, 40, 120, Scaler.LINEAR, true));
            _mage_Pin.addFilter(new Convolution(Convolution.MOVING_AVERAGE));
		}
		
		private function onEF(e:Event):void 
		{
			//曲げセンサーの値を毎フレーム見る。
			_mage_value = Math.round(_mage_Pin.value);
			
			
			
			//WEBカメラ用
			LATITUDE = _mage_value - 40;
			
            // 基画像
            _bmpDataSrc.draw(_vid);
            
            // CMYK4色抽出
			/*別の BitmapData オブジェクトまたは現在の BitmapData オブジェクトの 1 つのチャンネルのデータを、
			 * 現在の BitmapData オブジェクトのチャンネルに転送します。
			 * */
            _bmpDataC.copyChannel(
                _bmpDataSrc,
                _bmpDataSrc.rect,
                new Point(Math.random() * LATITUDE - LATITUDE, Math.random() * LATITUDE - LATITUDE),
                BitmapDataChannel.RED,
                BitmapDataChannel.RED
            );
            _bmpDataM.copyChannel(
                _bmpDataSrc,
                _bmpDataSrc.rect,
                new Point(Math.random() * LATITUDE - LATITUDE, Math.random() * LATITUDE - LATITUDE),
                BitmapDataChannel.GREEN,
                BitmapDataChannel.GREEN
            );
            _bmpDataY.copyChannel(
                _bmpDataSrc,
                _bmpDataSrc.rect,
                new Point(Math.random() * LATITUDE - LATITUDE, Math.random() * LATITUDE - LATITUDE),
                BitmapDataChannel.BLUE,
                BitmapDataChannel.BLUE
            );
            _bmpDataK.copyChannel(
                _bmpDataSrc,
                _bmpDataSrc.rect,
                new Point(Math.random() * LATITUDE - LATITUDE, Math.random() * LATITUDE - LATITUDE),
                BitmapDataChannel.ALPHA,
                BitmapDataChannel.ALPHA
            );
            
            // 描画
            _bmpDataDst.draw(_bmpDataC, null, new ColorTransform());
            _bmpDataDst.draw(_bmpDataM, null, new ColorTransform(), BlendMode.MULTIPLY);
            _bmpDataDst.draw(_bmpDataY, null, new ColorTransform(), BlendMode.MULTIPLY);
            _bmpDataDst.draw(_bmpDataK, null, new ColorTransform(), BlendMode.MULTIPLY);
		}
    }
}